/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.features.property_reading.properties.optifine_properties;

import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.minecraft.class_2483;
import net.minecraft.class_2487;
import net.minecraft.class_2514;
import net.minecraft.class_2520;
import org.jetbrains.annotations.NotNull;
import traben.entity_texture_features.features.property_reading.properties.RandomProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.SimpleIntegerArrayProperty;
import traben.entity_texture_features.features.property_reading.properties.generic_properties.StringArrayOrRegexProperty;
import traben.entity_texture_features.utils.ETFEntity;
import traben.entity_texture_features.utils.ETFUtils2;

public class NBTProperty
extends RandomProperty {
    private final Map<String, NBTTester> NBT_MAP;
    private boolean printAll = false;

    protected NBTProperty(Properties properties, int propertyNum) throws RandomProperty.RandomPropertyException {
        String keyPrefix = "nbt." + propertyNum + ".";
        this.NBT_MAP = new Object2ObjectLinkedOpenHashMap();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            if (key == null || !key.startsWith(keyPrefix)) continue;
            String nbtName = key.replaceFirst(keyPrefix, "");
            String instruction = entry.getValue().toString().trim().replace("print_raw:", "print:raw:");
            if (!nbtName.isBlank() && !instruction.isBlank()) {
                this.printAll = this.printAll || instruction.startsWith("print_all:");
                this.NBT_MAP.put(nbtName, NBTTester.of(nbtName, instruction));
                continue;
            }
            throw new RandomProperty.RandomPropertyException("NBT failed, as instruction or nbt name was blank: " + keyPrefix + nbtName + "=" + instruction);
        }
        if (this.NBT_MAP.isEmpty()) {
            throw new RandomProperty.RandomPropertyException("NBT failed as the final testing map was empty");
        }
    }

    public static NBTProperty getPropertyOrNull(Properties properties, int propertyNum) {
        try {
            return new NBTProperty(properties, propertyNum);
        }
        catch (RandomProperty.RandomPropertyException e) {
            return null;
        }
    }

    private static boolean isStringValidInt(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected boolean testEntityInternal(ETFEntity entity) {
        Iterator<Map.Entry<String, NBTTester>> iterator;
        class_2487 entityNBT = entity.etf$getNbt();
        if (entityNBT.method_33133()) {
            ETFUtils2.logError("NBT test failed, as could not read entity NBT");
            return false;
        }
        if (this.printAll) {
            ETFUtils2.logMessage("NBT property [full] print:\n" + this.formatNbtPretty(entityNBT));
        }
        if ((iterator = this.NBT_MAP.entrySet().iterator()).hasNext()) {
            boolean doesTestPass;
            Map.Entry<String, NBTTester> nbtPropertyEntry = iterator.next();
            NBTTester data = nbtPropertyEntry.getValue();
            class_2520 finalNBTElement = this.findNBTElement(entityNBT, nbtPropertyEntry.getKey());
            boolean bl = doesTestPass = finalNBTElement == null ? data.wantsBlank : (Boolean)data.tester.apply((Object)finalNBTElement);
            if (data.print) {
                String printString = finalNBTElement == null ? "<NBT component not found>" : finalNBTElement.method_10714();
                ETFUtils2.logMessage("NBT property [single] print data: " + nbtPropertyEntry.getKey() + "=" + printString);
                ETFUtils2.logMessage("NBT property [single] print result: " + (data.inverts != doesTestPass));
            }
            return data.inverts != doesTestPass;
        }
        return true;
    }

    public String formatNbtPretty(class_2487 nbt) {
        String input = nbt.method_10714();
        StringBuilder output = new StringBuilder();
        int indent = 1;
        boolean inString = false;
        block7: for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (inString && c != '\"') {
                output.append(c);
                continue;
            }
            switch (c) {
                case '[': 
                case '{': {
                    output.append(c).append('\n');
                    output.append(" ".repeat(indent += 4));
                    continue block7;
                }
                case ']': 
                case '}': {
                    output.append('\n').append(" ".repeat(indent -= 4)).append(c);
                    continue block7;
                }
                case ',': {
                    output.append(c).append('\n').append(" ".repeat(indent));
                    continue block7;
                }
                case '\"': {
                    inString = !inString;
                    output.append(c);
                    continue block7;
                }
                case ':': {
                    output.append(c).append(" ");
                    continue block7;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString().replaceAll("\\{\\s+}", "{}").replaceAll("\\[\\s+]", "[]");
    }

    private class_2520 findNBTElement(class_2487 entityNBT, String nbtIdentifier) {
        class_2487 lastElement = entityNBT;
        for (String instruction : nbtIdentifier.split("\\.")) {
            if (lastElement == null) {
                ETFUtils2.logWarn("null nbt in ETF");
                return null;
            }
            if (lastElement instanceof class_2487) {
                class_2487 nbtCompound = lastElement;
                lastElement = nbtCompound.method_10580(instruction);
                continue;
            }
            if (lastElement instanceof class_2483) {
                class_2483 nbtList = (class_2483)lastElement;
                lastElement = this.handleListInstruction(nbtList, instruction);
                continue;
            }
            ETFUtils2.logError("Invalid NBT instruction: " + instruction);
            return null;
        }
        return lastElement;
    }

    private class_2520 handleListInstruction(class_2483<?> nbtList, String instruction) {
        if ("*".equals(instruction)) {
            return nbtList;
        }
        if (NBTProperty.isStringValidInt(instruction)) {
            try {
                return (class_2520)nbtList.get(Integer.parseInt(instruction));
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
        ETFUtils2.logWarn("Invalid list index: " + instruction);
        return null;
    }

    @Override
    @NotNull
    public String[] getPropertyIds() {
        return new String[]{"nbt"};
    }

    @Override
    protected String getPrintableRuleInfo() {
        return null;
    }

    public record NBTTester(boolean inverts, Function<class_2520, Boolean> tester, boolean wantsBlank, boolean print) {
        public static NBTTester of(String nbtId, String instructionMaybePrint) throws RandomProperty.RandomPropertyException {
            try {
                String instruction;
                String step1 = instructionMaybePrint.replaceFirst("^print_all:", "");
                boolean printSingle = step1.startsWith("print:");
                String step2 = printSingle ? step1.substring(6) : step1;
                boolean invert = step2.startsWith("!");
                String string = instruction = invert ? step2.substring(1) : step2;
                if (instruction.startsWith("raw:")) {
                    StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher matcher;
                    String raw = instruction.replaceFirst("raw:", "");
                    boolean blank = raw.isBlank();
                    StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher regexAndPatternPropertyMatcher = matcher = blank ? String::isBlank : StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(raw);
                    if (matcher == null) {
                        throw new RandomProperty.RandomPropertyException("NBT failed, as raw: instruction was invalid: " + instruction);
                    }
                    return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> matcher.testString(((class_2520)s).method_10714())), blank, printSingle);
                }
                if (instruction.startsWith("exists:")) {
                    boolean exists = instruction.contains("exists:true");
                    boolean notExists = instruction.contains("exists:false");
                    return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> exists), notExists, printSingle);
                }
                if (instruction.startsWith("range:")) {
                    SimpleIntegerArrayProperty.IntRange range = SimpleIntegerArrayProperty.getIntRange(instruction.replaceFirst("range:", ""));
                    return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> {
                        if (s instanceof class_2514) {
                            class_2514 nbtNumber = (class_2514)s;
                            return range.isWithinRange(nbtNumber.method_10702().intValue());
                        }
                        ETFUtils2.logWarn("Invalid range for non-number NBT: " + nbtId + "=" + instruction);
                        return false;
                    }), false, printSingle);
                }
                StringArrayOrRegexProperty.RegexAndPatternPropertyMatcher matcher = StringArrayOrRegexProperty.getStringMatcher_Regex_Pattern_List_Single(instruction);
                if (matcher == null) {
                    throw new RandomProperty.RandomPropertyException("NBT failed, as instruction was invalid: " + instruction);
                }
                return new NBTTester(invert, (Function<class_2520, Boolean>)((Function)s -> {
                    String test = s instanceof class_2514 ? ((class_2520)s).method_10714().replaceAll("[^\\d.]", "") : ((class_2520)s).method_10714();
                    return matcher.testString(test);
                }), false, false);
            }
            catch (RandomProperty.RandomPropertyException e) {
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RandomProperty.RandomPropertyException("NBT failed, unexpected exception: " + e.getMessage());
            }
        }
    }
}

