/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.jem_objects;

import java.util.Arrays;

public class EMFBoxData {
    public float[] textureOffset = new float[0];
    public float[] uvDown = new float[0];
    public float[] uvUp = new float[0];
    public float[] uvFront = new float[0];
    public float[] uvBack = new float[0];
    public float[] uvLeft = new float[0];
    public float[] uvRight = new float[0];
    public float[] uvNorth = new float[0];
    public float[] uvSouth = new float[0];
    public float[] uvWest = new float[0];
    public float[] uvEast = new float[0];
    public float[] coordinates = new float[0];
    public float sizeAdd = 0.0f;
    public float sizeAddX = 0.0f;
    public float sizeAddY = 0.0f;
    public float sizeAddZ = 0.0f;

    public void prepare(boolean invertX, boolean invertY, boolean invertZ) {
        this.checkAndFixUVLegacyDirections();
        if (this.sizeAdd != 0.0f && this.sizeAddX == 0.0f && this.sizeAddY == 0.0f && this.sizeAddZ == 0.0f) {
            this.sizeAddX = this.sizeAdd;
            this.sizeAddY = this.sizeAdd;
            this.sizeAddZ = this.sizeAdd;
        }
        if (invertX) {
            this.coordinates[0] = -this.coordinates[0] - this.coordinates[3];
        }
        if (invertY) {
            this.coordinates[1] = -this.coordinates[1] - this.coordinates[4];
        }
        if (invertZ) {
            this.coordinates[2] = -this.coordinates[2] - this.coordinates[5];
        }
    }

    public void checkAndFixUVLegacyDirections() {
        if (this.uvFront.length == 4) {
            this.uvNorth = this.uvFront;
        }
        if (this.uvBack.length == 4) {
            this.uvWest = this.uvBack;
        }
        if (this.uvLeft.length == 4) {
            this.uvNorth = this.uvLeft;
        }
        if (this.uvRight.length == 4) {
            this.uvEast = this.uvRight;
        }
    }

    public String toString() {
        return "EMF_BoxData{coordinates=" + Arrays.toString(this.coordinates) + ", uvDown=" + Arrays.toString(this.uvDown) + ", uvUp=" + Arrays.toString(this.uvUp) + ", uvNorth=" + Arrays.toString(this.uvNorth) + ", uvSouth=" + Arrays.toString(this.uvSouth) + ", uvWest=" + Arrays.toString(this.uvWest) + ", uvEast=" + Arrays.toString(this.uvEast) + ", textureOffset=" + Arrays.toString(this.textureOffset) + ", sizeAdd=" + this.sizeAdd + "}";
    }
}

