/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.parts;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import traben.entity_model_features.models.animation.EMFAnimationEntityContext;
import traben.entity_model_features.models.parts.EMFModelPart;
import traben.entity_model_features.utils.EMFUtils;

public abstract class EMFModelPartWithState
extends EMFModelPart {
    public final Int2ObjectOpenHashMap<EMFModelState> allKnownStateVariants = new Int2ObjectOpenHashMap<EMFModelState>(){

        public EMFModelState get(int k) {
            if (!this.containsKey(k)) {
                EMFUtils.logWarn("EMFModelState variant with key " + k + " does not exist in part [" + EMFModelPartWithState.this.toStringShort() + "], returning copy of 0");
                this.put(k, EMFModelState.copy(this.get(0)));
            }
            return (EMFModelState)super.get(k);
        }
    };
    public int currentModelVariant = 0;
    Map<String, class_630> vanillaChildren = new HashMap<String, class_630>();
    Runnable startOfRenderRunnable = null;
    EMFModelPart.Animator tryAnimate = new EMFModelPart.Animator();

    public EMFModelPartWithState(List<class_630.class_628> cuboids, Map<String, class_630> children) {
        super(cuboids, children);
    }

    void receiveOneTimeRunnable(Runnable run) {
        this.startOfRenderRunnable = run;
        this.field_3661.values().forEach(child -> {
            if (child instanceof EMFModelPartWithState) {
                EMFModelPartWithState emf = (EMFModelPartWithState)((Object)child);
                emf.receiveOneTimeRunnable(run);
            }
        });
    }

    @Override
    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, int k) {
        if (this.startOfRenderRunnable != null) {
            this.startOfRenderRunnable.run();
        }
        if (this.tryAnimate != null && !EMFAnimationEntityContext.isEntityAnimPaused()) {
            this.tryAnimate.run();
        }
        super.method_22699(matrices, vertices, light, overlay, k);
    }

    EMFModelState getCurrentState() {
        return new EMFModelState(this.method_41921(), this.field_3663, this.field_3661, this.field_37938, this.field_37939, this.field_37940, this.field_3665, this.field_38456, this.textureOverride, this.tryAnimate);
    }

    EMFModelState getStateOf(class_630 modelPart) {
        if (modelPart instanceof EMFModelPartWithState) {
            EMFModelPartWithState emf = (EMFModelPartWithState)modelPart;
            return new EMFModelState(modelPart.method_41921(), modelPart.field_3663, modelPart.field_3661, modelPart.field_37938, modelPart.field_37939, modelPart.field_37940, modelPart.field_3665, modelPart.field_38456, emf.textureOverride, emf.tryAnimate);
        }
        return new EMFModelState(modelPart.method_41921(), modelPart.field_3663, new HashMap<String, class_630>(), modelPart.field_37938, modelPart.field_37939, modelPart.field_37940, modelPart.field_3665, modelPart.field_38456, null, new EMFModelPart.Animator());
    }

    void setFromState(EMFModelState newState) {
        this.method_41918(newState.defaultTransform());
        this.method_32085(this.method_41921());
        this.field_3663 = newState.cuboids();
        this.field_3661 = newState.variantChildren();
        this.field_37938 = newState.xScale();
        this.field_37939 = newState.yScale();
        this.field_37940 = newState.zScale();
        this.field_3665 = newState.visible();
        this.field_38456 = newState.hidden();
        this.textureOverride = newState.texture();
        this.tryAnimate = newState.animation();
    }

    protected void resetState() {
        this.setFromState((EMFModelState)this.allKnownStateVariants.get(this.currentModelVariant));
    }

    public void setVariantStateTo(int newVariant) {
        if (this.currentModelVariant != newVariant) {
            this.setFromState((EMFModelState)this.allKnownStateVariants.get(newVariant));
            this.currentModelVariant = newVariant;
            for (class_630 part : this.field_3661.values()) {
                if (!(part instanceof EMFModelPartWithState)) continue;
                EMFModelPartWithState p3 = (EMFModelPartWithState)part;
                p3.setVariantStateTo(newVariant);
            }
        }
    }

    public record EMFModelState(class_5603 defaultTransform, List<class_630.class_628> cuboids, Map<String, class_630> variantChildren, float xScale, float yScale, float zScale, boolean visible, boolean hidden, class_2960 texture, EMFModelPart.Animator animation) {
        public static EMFModelState copy(EMFModelState copyFrom) {
            class_5603 trans = copyFrom.defaultTransform();
            EMFModelPart.Animator animator = new EMFModelPart.Animator();
            animator.setAnimation(copyFrom.animation().getAnimation());
            return new EMFModelState(class_5603.method_32091((float)trans.field_27702, (float)trans.field_27703, (float)trans.field_27704, (float)trans.field_27705, (float)trans.field_27706, (float)trans.field_27707), new ArrayList<class_630.class_628>(copyFrom.cuboids()), new HashMap<String, class_630>(copyFrom.variantChildren()), copyFrom.xScale(), copyFrom.yScale(), copyFrom.zScale(), copyFrom.visible(), copyFrom.hidden(), copyFrom.texture(), animator);
        }
    }
}

