/*
 * Decompiled with CFR 0.152.
 */
package io.github.amerebagatelle.fabricskyboxes.util.object;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.util.object.UVRange;
import java.util.List;

public class UVRanges {
    public static final Codec<UVRanges> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)UVRange.CODEC.fieldOf("north").forGetter(UVRanges::getNorth), (App)UVRange.CODEC.fieldOf("south").forGetter(UVRanges::getSouth), (App)UVRange.CODEC.fieldOf("east").forGetter(UVRanges::getEast), (App)UVRange.CODEC.fieldOf("west").forGetter(UVRanges::getWest), (App)UVRange.CODEC.fieldOf("top").forGetter(UVRanges::getTop), (App)UVRange.CODEC.fieldOf("bottom").forGetter(UVRanges::getBottom)).apply((Applicative)instance, UVRanges::new));
    private final List<UVRange> textureList = Lists.newArrayList();
    private final UVRange north;
    private final UVRange south;
    private final UVRange east;
    private final UVRange west;
    private final UVRange top;
    private final UVRange bottom;

    public UVRanges(UVRange north, UVRange south, UVRange east, UVRange west, UVRange top, UVRange bottom) {
        this.north = north;
        this.south = south;
        this.east = east;
        this.west = west;
        this.top = top;
        this.bottom = bottom;
        this.textureList.add(bottom);
        this.textureList.add(north);
        this.textureList.add(south);
        this.textureList.add(top);
        this.textureList.add(east);
        this.textureList.add(west);
    }

    public UVRange getNorth() {
        return this.north;
    }

    public UVRange getSouth() {
        return this.south;
    }

    public UVRange getEast() {
        return this.east;
    }

    public UVRange getWest() {
        return this.west;
    }

    public UVRange getTop() {
        return this.top;
    }

    public UVRange getBottom() {
        return this.bottom;
    }

    public UVRange byId(int i) {
        return this.textureList.get(i);
    }
}

