/*
 * Decompiled with CFR 0.152.
 */
package me.flashyreese.mods.fabricskyboxes_interop.sky;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.amerebagatelle.fabricskyboxes.api.skyboxes.Skybox;
import io.github.amerebagatelle.fabricskyboxes.mixin.skybox.WorldRendererAccess;
import java.util.List;
import me.flashyreese.mods.fabricskyboxes_interop.client.config.FSBInteropConfig;
import me.flashyreese.mods.fabricskyboxes_interop.sky.OptiFineBlend;
import me.flashyreese.mods.fabricskyboxes_interop.sky.OptiFineSkyLayer;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_291;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_5294;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5636;
import net.minecraft.class_5944;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

public class OptiFineCustomSky
implements Skybox {
    public static final Codec<OptiFineCustomSky> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)OptiFineSkyLayer.CODEC.listOf().optionalFieldOf("layers", (Object)ImmutableList.of()).forGetter(OptiFineCustomSky::getLayers), (App)class_1937.field_25178.fieldOf("world").forGetter(OptiFineCustomSky::getWorldIdentifier)).apply((Applicative)instance, OptiFineCustomSky::new));
    private final List<OptiFineSkyLayer> layers;
    private final class_5321<class_1937> worldIdentifier;
    private final class_310 client = class_310.method_1551();
    private class_638 world;
    private boolean active;

    public OptiFineCustomSky(List<OptiFineSkyLayer> layers, class_5321<class_1937> worldIdentifier) {
        this.world = this.client.field_1687;
        this.active = true;
        this.layers = layers;
        this.worldIdentifier = worldIdentifier;
    }

    public void render(WorldRendererAccess worldRendererAccess, class_4587 matrixStack, Matrix4f matrix4f, float tickDelta, class_4184 camera, boolean thickFog, Runnable fogCallback) {
        this.world = (class_638)camera.method_19331().method_5770();
        this.renderSky(worldRendererAccess, matrixStack, matrix4f, tickDelta, camera, thickFog, fogCallback);
    }

    private void renderEndSky(class_4587 matrices) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)WorldRendererAccess.getEndSky());
        for (int i = 0; i < 6; ++i) {
            matrices.method_22903();
            if (i == 1) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
            }
            if (i == 2) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(-90.0f));
            }
            if (i == 3) {
                matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
            }
            if (i == 4) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
            }
            if (i == 5) {
                matrices.method_22907(class_7833.field_40718.rotationDegrees(-90.0f));
            }
            Matrix4f matrix4f = matrices.method_23760().method_23761();
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, -100.0f).method_22913(0.0f, 0.0f).method_1336(40, 40, 40, 255);
            bufferBuilder.method_22918(matrix4f, -100.0f, -100.0f, 100.0f).method_22913(0.0f, 16.0f).method_1336(40, 40, 40, 255);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, 100.0f).method_22913(16.0f, 16.0f).method_1336(40, 40, 40, 255);
            bufferBuilder.method_22918(matrix4f, 100.0f, -100.0f, -100.0f).method_22913(16.0f, 0.0f).method_1336(40, 40, 40, 255);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
            matrices.method_22909();
        }
        this.render(matrices, (class_1937)this.world, 0.0f);
        RenderSystem.depthMask((boolean)true);
        RenderSystem.disableBlend();
    }

    public void renderSky(WorldRendererAccess worldRendererAccess, class_4587 matrices, Matrix4f projectionMatrix, float tickDelta, class_4184 camera, boolean thickFog, Runnable fogCallback) {
        class_5636 cameraSubmersionType;
        fogCallback.run();
        if (!thickFog && (cameraSubmersionType = camera.method_19334()) != class_5636.field_27887 && cameraSubmersionType != class_5636.field_27885 && !this.hasBlindnessOrDarkness(camera)) {
            if (this.client.field_1687.method_28103().method_29992() == class_5294.class_5401.field_25641) {
                this.renderEndSky(matrices);
            } else if (this.client.field_1687.method_28103().method_29992() == class_5294.class_5401.field_25640) {
                float q;
                float p;
                float o;
                int m;
                float k;
                float i;
                class_243 vec3d = this.world.method_23777(this.client.field_1773.method_19418().method_19326(), tickDelta);
                float f = (float)vec3d.field_1352;
                float g = (float)vec3d.field_1351;
                float h = (float)vec3d.field_1350;
                class_758.method_3212();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.setShaderColor((float)f, (float)g, (float)h, (float)1.0f);
                class_5944 shaderProgram = RenderSystem.getShader();
                worldRendererAccess.getLightSkyBuffer().method_1353();
                worldRendererAccess.getLightSkyBuffer().method_34427(matrices.method_23760().method_23761(), projectionMatrix, shaderProgram);
                class_291.method_1354();
                RenderSystem.enableBlend();
                float[] fs = this.world.method_28103().method_28109(this.world.method_30274(tickDelta), tickDelta);
                if (fs != null) {
                    RenderSystem.setShader(class_757::method_34540);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    matrices.method_22903();
                    matrices.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                    i = class_3532.method_15374((float)this.world.method_8442(tickDelta)) < 0.0f ? 180.0f : 0.0f;
                    matrices.method_22907(class_7833.field_40718.rotationDegrees(i));
                    matrices.method_22907(class_7833.field_40718.rotationDegrees(90.0f));
                    float j = fs[0];
                    k = fs[1];
                    float l = fs[2];
                    Matrix4f matrix4f = matrices.method_23760().method_23761();
                    class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27381, class_290.field_1576);
                    bufferBuilder.method_22918(matrix4f, 0.0f, 100.0f, 0.0f).method_22915(j, k, l, fs[3]);
                    m = 16;
                    for (int n = 0; n <= 16; ++n) {
                        o = (float)n * ((float)Math.PI * 2) / 16.0f;
                        p = class_3532.method_15374((float)o);
                        q = class_3532.method_15362((float)o);
                        bufferBuilder.method_22918(matrix4f, p * 120.0f, q * 120.0f, -q * 40.0f * fs[3]).method_22915(fs[0], fs[1], fs[2], 0.0f);
                    }
                    class_286.method_43433((class_9801)bufferBuilder.method_60800());
                    matrices.method_22909();
                }
                RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
                matrices.method_22903();
                i = 1.0f - this.world.method_8430(tickDelta);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)i);
                matrices.method_22907(class_7833.field_40716.rotationDegrees(-90.0f));
                this.render(matrices, (class_1937)this.world, tickDelta);
                matrices.method_22907(class_7833.field_40714.rotationDegrees(this.world.method_30274(tickDelta) * 360.0f));
                Matrix4f matrix4f2 = matrices.method_23760().method_23761();
                k = 30.0f;
                RenderSystem.setShader(class_757::method_34542);
                RenderSystem.setShaderTexture((int)0, (class_2960)WorldRendererAccess.getSun());
                class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                bufferBuilder.method_22918(matrix4f2, -k, 100.0f, -k).method_22913(0.0f, 0.0f);
                bufferBuilder.method_22918(matrix4f2, k, 100.0f, -k).method_22913(1.0f, 0.0f);
                bufferBuilder.method_22918(matrix4f2, k, 100.0f, k).method_22913(1.0f, 1.0f);
                bufferBuilder.method_22918(matrix4f2, -k, 100.0f, k).method_22913(0.0f, 1.0f);
                class_286.method_43433((class_9801)bufferBuilder.method_60800());
                k = 20.0f;
                RenderSystem.setShaderTexture((int)0, (class_2960)WorldRendererAccess.getMoonPhases());
                int r = this.world.method_30273();
                int s = r % 4;
                m = r / 4 % 2;
                float t = (float)(s + 0) / 4.0f;
                o = (float)(m + 0) / 2.0f;
                p = (float)(s + 1) / 4.0f;
                q = (float)(m + 1) / 2.0f;
                class_287 bufferBuilder2 = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
                bufferBuilder2.method_22918(matrix4f2, -k, -100.0f, k).method_22913(p, q);
                bufferBuilder2.method_22918(matrix4f2, k, -100.0f, k).method_22913(t, q);
                bufferBuilder2.method_22918(matrix4f2, k, -100.0f, -k).method_22913(t, o);
                bufferBuilder2.method_22918(matrix4f2, -k, -100.0f, -k).method_22913(p, o);
                class_286.method_43433((class_9801)bufferBuilder2.method_60800());
                float u = this.world.method_23787(tickDelta) * i;
                if (u > 0.0f) {
                    RenderSystem.setShaderColor((float)u, (float)u, (float)u, (float)u);
                    class_758.method_23792();
                    worldRendererAccess.getStarsBuffer().method_1353();
                    worldRendererAccess.getStarsBuffer().method_34427(matrices.method_23760().method_23761(), projectionMatrix, class_757.method_34539());
                    class_291.method_1354();
                    fogCallback.run();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                RenderSystem.defaultBlendFunc();
                matrices.method_22909();
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                double d = this.client.field_1724.method_5836((float)tickDelta).field_1351 - this.world.method_28104().method_28105((class_5539)this.world);
                if (d < 0.0) {
                    matrices.method_22903();
                    matrices.method_46416(0.0f, 12.0f, 0.0f);
                    worldRendererAccess.getDarkSkyBuffer().method_1353();
                    worldRendererAccess.getDarkSkyBuffer().method_34427(matrices.method_23760().method_23761(), projectionMatrix, shaderProgram);
                    class_291.method_1354();
                    matrices.method_22909();
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.depthMask((boolean)true);
            }
        }
    }

    private boolean hasBlindnessOrDarkness(class_4184 camera) {
        class_1297 entity = camera.method_19331();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            return livingEntity.method_6059(class_1294.field_5919) || livingEntity.method_6059(class_1294.field_38092);
        }
        return false;
    }

    private void render(class_4587 matrixStack, class_1937 world, float tickDelta) {
        int timeOfDay = (int)(world.method_8532() % 24000L);
        float skyAngle = world.method_30274(tickDelta);
        float rainGradient = world.method_8430(tickDelta);
        float thunderGradient = world.method_8478(tickDelta);
        if (rainGradient > 0.0f) {
            thunderGradient /= rainGradient;
        }
        for (OptiFineSkyLayer optiFineSkyLayer : this.layers) {
            if (!optiFineSkyLayer.isActive(timeOfDay)) continue;
            optiFineSkyLayer.render(world, matrixStack, timeOfDay, skyAngle, rainGradient, thunderGradient);
        }
        float f3 = 1.0f - rainGradient;
        OptiFineBlend.ADD.getBlendFunc().accept(Float.valueOf(f3));
    }

    public void tick(class_638 clientWorld) {
        this.active = true;
        if (clientWorld.method_27983() != this.worldIdentifier) {
            this.layers.forEach(layer -> layer.setConditionAlpha(-1.0f));
            this.active = false;
        } else {
            this.layers.forEach(layer -> layer.tick((class_1937)clientWorld));
        }
    }

    public boolean isActive() {
        return FSBInteropConfig.INSTANCE.interoperability && this.active;
    }

    public List<OptiFineSkyLayer> getLayers() {
        return this.layers;
    }

    public class_5321<class_1937> getWorldIdentifier() {
        return this.worldIdentifier;
    }
}

