/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.block;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class BlockContextExpression {
    private final Expression expression;
    private final String unparsed;
    private final boolean hasTime;
    private final boolean hasRain;
    private final boolean hasX;
    private final boolean hasY;
    private final boolean hasZ;
    private final boolean hasState;
    private final boolean hasDayTime;
    private final boolean hasSkyLight;
    private final boolean hasBlockLight;
    private static final String POS_X = "POS_X";
    private static final String POS_Y = "POS_Y";
    private static final String POS_Z = "POS_Z";
    private static final String RAIN = "RAIN";
    private static final String TIME = "TIME";
    private static final String DAY_TIME = "DAY_TIME";
    private static final String BLOCK_LIGHT = "BLOCK_LIGHT";
    private static final String SKY_LIGHT = "SKY_LIGHT";
    private static final String STATE_FUNC = "state_prop";
    private static final Function STATE_PROP = new Function("state_prop", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return (float)values.indexOf(blockState.method_11654(p)) / ((float)properties.size() - 1.0f);
        }
    };
    private static final Function STATE_PROP_INT = new Function("state_prop_i", 1){

        public double apply(double ... args) {
            class_2680 blockState = STATE_HACK.get();
            ArrayList properties = new ArrayList(blockState.method_28501());
            int index = (int)args[0];
            class_2769 p = (class_2769)properties.get(class_3532.method_15340((int)index, (int)0, (int)(properties.size() - 1)));
            ArrayList values = new ArrayList(p.method_11898());
            return values.indexOf(blockState.method_11654(p));
        }
    };
    private static final ThreadLocal<class_2680> STATE_HACK = new ThreadLocal();
    public static final Codec<BlockContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            return DataResult.success((Object)new BlockContextExpression((String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    public static final BlockContextExpression ZERO = new BlockContextExpression("0");
    public static final BlockContextExpression ONE = new BlockContextExpression("1");
    public static final BlockContextExpression PARTICLE_RAND = new BlockContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(ExpressionUtils.removeHex(s)).functions(ExpressionUtils.defFunc(STATE_PROP, STATE_PROP_INT)).variables(new String[]{POS_X, POS_Y, POS_Z, RAIN, DAY_TIME, TIME, BLOCK_LIGHT, SKY_LIGHT}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    public BlockContextExpression(String expression) {
        this(BlockContextExpression.createExpression(expression), expression);
    }

    public BlockContextExpression(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTime = unparsed.contains(TIME);
        this.hasX = unparsed.contains(POS_X);
        this.hasY = unparsed.contains(POS_Y);
        this.hasZ = unparsed.contains(POS_Z);
        this.hasState = unparsed.contains(STATE_FUNC);
        this.hasRain = unparsed.contains(RAIN);
        this.hasDayTime = unparsed.contains(DAY_TIME);
        this.hasSkyLight = unparsed.contains(SKY_LIGHT);
        this.hasBlockLight = unparsed.contains(BLOCK_LIGHT);
    }

    public double getValue(class_243 pos, float entityTime) {
        ExpressionUtils.randomizeRandom();
        if (this.hasX) {
            this.expression.setVariable(POS_X, pos.field_1352);
        }
        if (this.hasY) {
            this.expression.setVariable(POS_Y, pos.field_1351);
        }
        if (this.hasZ) {
            this.expression.setVariable(POS_Z, pos.field_1350);
        }
        if (this.hasTime) {
            this.expression.setVariable(TIME, (double)entityTime);
        }
        if (this.hasRain) {
            this.expression.setVariable(RAIN, (double)ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasDayTime) {
            this.expression.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
        }
        return this.expression.evaluate();
    }

    public double getValue(class_1937 level, class_2338 pos, class_2680 state) {
        ExpressionUtils.seedRandom((long)pos.hashCode() * pos.method_10063());
        if (this.hasX) {
            this.expression.setVariable(POS_X, (double)pos.method_10263());
        }
        if (this.hasY) {
            this.expression.setVariable(POS_Y, (double)pos.method_10264());
        }
        if (this.hasZ) {
            this.expression.setVariable(POS_Z, (double)pos.method_10260());
        }
        if (this.hasTime) {
            this.expression.setVariable(TIME, ClientFrameTicker.getGameTime());
        }
        if (this.hasRain) {
            this.expression.setVariable(RAIN, (double)ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasDayTime) {
            this.expression.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
        }
        if (this.hasSkyLight) {
            this.expression.setVariable(SKY_LIGHT, (double)level.method_8314(class_1944.field_9284, pos));
        }
        if (this.hasBlockLight) {
            this.expression.setVariable(BLOCK_LIGHT, (double)level.method_8314(class_1944.field_9282, pos));
        }
        if (this.hasState) {
            STATE_HACK.set(state);
        }
        return this.expression.evaluate();
    }
}

