/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.item.AutoGeneratedModel;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.item.ItemModelOverrideList;
import net.mehvahdjukaar.polytone.item.StandaloneItemModelOverride;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_638;
import net.minecraft.class_793;
import org.apache.commons.lang3.time.StopWatch;
import org.jetbrains.annotations.Nullable;

public class CustomItemModelsManager
extends PartialReloader<Object> {
    private final Map<class_1792, ItemModelOverrideList> itemModels = new Object2ObjectOpenHashMap();
    private final Set<class_2960> extraModels = new HashSet<class_2960>();
    private final Set<AutoGeneratedModel> autoGeneratedModels = new HashSet<AutoGeneratedModel>();

    public CustomItemModelsManager() {
        super("custom_item_models");
    }

    @Override
    protected Object prepare(class_3300 resourceManager) {
        return new Object();
    }

    @Override
    protected void reset() {
    }

    @Override
    protected void process(Object obj, DynamicOps<JsonElement> ops) {
    }

    public void earlyProcess(class_3300 resourceManager) {
        this.itemModels.clear();
        this.extraModels.clear();
        this.autoGeneratedModels.clear();
        StopWatch stopWatch = StopWatch.createStarted();
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        for (Map.Entry<class_2960, JsonElement> v : jsons.entrySet()) {
            JsonElement json = v.getValue();
            class_2960 location = v.getKey();
            StandaloneItemModelOverride modelOverride = (StandaloneItemModelOverride)((Pair)StandaloneItemModelOverride.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Custom Item Model with json id " + String.valueOf(location) + "\n error: " + errorMsg))).getFirst();
            if (modelOverride == null) continue;
            if (modelOverride.isAutoModel()) {
                AutoGeneratedModel generated = AutoGeneratedModel.ofCIM(location);
                this.autoGeneratedModels.add(generated);
                modelOverride.setModel(generated.modelLocation());
            }
            this.extraModels.add(modelOverride.model());
            this.itemModels.computeIfAbsent(modelOverride.getTarget(), a -> new ItemModelOverrideList()).add(modelOverride);
        }
        Polytone.LOGGER.info("Loaded {} Custom Item Models jsons in {}", (Object)jsons.size(), (Object)stopWatch);
    }

    @Override
    protected void apply() {
        super.apply();
        int allModels = 0;
        for (ItemModelOverrideList list : this.itemModels.values()) {
            allModels += list.size();
        }
        Polytone.LOGGER.info("Loaded {} Custom Item Models for {} items", (Object)allModels, (Object)this.itemModels.size());
    }

    @Nullable
    public class_1087 getOverride(class_1799 itemStack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
        ItemModelOverrideList list = this.itemModels.get(itemStack.method_7909());
        if (list == null) {
            return null;
        }
        return list.getModel(itemStack, level, entity, seed);
    }

    public Set<class_2960> getExtraModels() {
        return this.extraModels;
    }

    public Map<class_2960, class_793> createAutoGeneratedModels() {
        HashMap<class_2960, class_793> models = new HashMap<class_2960, class_793>();
        for (AutoGeneratedModel model : this.autoGeneratedModels) {
            String texturePath = model.texturePath().toString();
            class_793 unbakedModel = class_793.method_3430((String)String.format("{\n  \"parent\": \"item/generated\",\n  \"textures\": {\n    \"layer0\": \"%s\"\n  }\n}\n", texturePath));
            models.put(model.modelLocation(), unbakedModel);
        }
        return models;
    }

    public void addModel(class_1792 target, List<ItemModelOverride> overrides) {
        this.itemModels.computeIfAbsent(target, a -> new ItemModelOverrideList()).addAll(overrides);
        this.extraModels.addAll(overrides.stream().map(ItemModelOverride::model).toList());
    }
}

