/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.item.ItemModelOverride;
import net.mehvahdjukaar.polytone.utils.DepthSearchTrie;
import net.mehvahdjukaar.polytone.utils.FrequencyOrderedCollection;
import net.minecraft.class_1087;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_638;
import net.minecraft.class_9331;
import net.minecraft.class_9336;
import org.jetbrains.annotations.Nullable;

public class ItemModelOverrideList {
    private final PropertiesSearchTrie overrides = new PropertiesSearchTrie();
    private final List<ItemModelOverride> entries = new ArrayList<ItemModelOverride>();
    private boolean populated = false;

    private void populateModels() {
        this.overrides.clear();
        this.overrides.acceptEntries(this.entries);
        this.populated = true;
        this.entries.clear();
    }

    public void addAll(Collection<ItemModelOverride> itemModelOverrides) {
        this.entries.addAll(itemModelOverrides);
    }

    public void add(ItemModelOverride itemModelOverride) {
        this.entries.add(itemModelOverride);
    }

    @Nullable
    public class_1087 getModel(class_1799 stack, @Nullable class_638 level, @Nullable class_1309 entity, int seed) {
        if (!this.populated) {
            this.populateModels();
        }
        return (class_1087)this.overrides.search(stack);
    }

    public int size() {
        return this.entries.size();
    }

    public static void testTrie() {
    }

    public static class PropertiesSearchTrie
    extends DepthSearchTrie<Object, Object, class_1087, class_1799> {
        private final List<class_9331<?>> orderedKeys = new ArrayList();

        @Override
        public void clear() {
            super.clear();
            this.orderedKeys.clear();
        }

        @Override
        protected Object getKeyOfType(Object folder) {
            if (folder instanceof class_9336) {
                class_9336 t = (class_9336)folder;
                return t.comp_2443();
            }
            if (folder instanceof Integer) {
                return Integer.class;
            }
            return folder;
        }

        @Override
        protected Object getKeyFromType(Object type, class_1799 stack) {
            if (type instanceof class_9331) {
                class_9331 t = (class_9331)type;
                return stack.method_57353().method_57834(t);
            }
            if (type == Integer.class) {
                return stack.method_7947();
            }
            return null;
        }

        public void acceptEntries(List<ItemModelOverride> entries) {
            boolean hasCount = false;
            FrequencyOrderedCollection<class_9331> keyFrequencies = new FrequencyOrderedCollection<class_9331>();
            for (ItemModelOverride entry : entries) {
                if (entry.hasStackCount()) {
                    hasCount = true;
                }
                for (class_9336 component : entry.components()) {
                    keyFrequencies.add(component.comp_2443());
                }
            }
            this.orderedKeys.addAll(keyFrequencies.stream().toList());
            for (ItemModelOverride entry : entries) {
                ArrayList<Integer> key = new ArrayList<Integer>();
                if (hasCount) {
                    key.add(entry.stackCount());
                }
                for (class_9331<?> type : this.orderedKeys) {
                    key.add((Integer)entry.components().method_57834(type));
                }
                this.insert(key, PlatStuff.getBakedModel(entry.model()));
            }
        }
    }
}

