/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.polytone.colormap.Colormap;
import net.mehvahdjukaar.polytone.colormap.IColorGetter;
import net.mehvahdjukaar.polytone.particle.CustomParticleFactory;
import net.mehvahdjukaar.polytone.particle.ParticleContextExpression;
import net.mehvahdjukaar.polytone.particle.ParticleInitializer;
import net.mehvahdjukaar.polytone.particle.ParticleParticleEmitter;
import net.mehvahdjukaar.polytone.particle.ParticleTickable;
import net.mehvahdjukaar.polytone.sound.ParticleSoundEmitter;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3940;
import net.minecraft.class_3999;
import net.minecraft.class_4002;
import net.minecraft.class_4003;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_765;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class CustomParticleType
implements CustomParticleFactory {
    private static class_2680 STATE_HACK = class_2246.field_10124.method_9564();
    private final RenderType renderType;
    @Nullable
    private final ParticleInitializer initializer;
    @Nullable
    private final Ticker ticker;
    private final List<ParticleSoundEmitter> sounds;
    private final List<ParticleParticleEmitter> particles;
    private final int lightLevel;
    private final LiquidAffinity liquidAffinity;
    private final boolean hasPhysics;
    private final boolean killOnContact;
    @Nullable
    private final IColorGetter colormap;
    private transient class_4002 spriteSet;
    public static final Codec<CustomParticleType> CODEC = RecordCodecBuilder.create(i -> i.group((App)RenderType.CODEC.optionalFieldOf("render_type", (Object)RenderType.OPAQUE).forGetter(CustomParticleType::getRenderType), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(c -> c.lightLevel), (App)Codec.BOOL.optionalFieldOf("has_physics", (Object)true).forGetter(c -> c.hasPhysics), (App)Codec.BOOL.optionalFieldOf("kill_on_contact", (Object)false).forGetter(c -> c.killOnContact), (App)LiquidAffinity.CODEC.optionalFieldOf("liquid_affinity", (Object)LiquidAffinity.ANY).forGetter(c -> c.liquidAffinity), (App)Colormap.CODEC.optionalFieldOf("colormap").forGetter(c -> Optional.ofNullable(c.colormap)), (App)ParticleInitializer.CODEC.optionalFieldOf("initializer").forGetter(c -> Optional.ofNullable(c.initializer)), (App)Ticker.CODEC.optionalFieldOf("ticker").forGetter(c -> Optional.ofNullable(c.ticker)), (App)ParticleSoundEmitter.CODEC.listOf().optionalFieldOf("sound_emitters", List.of()).forGetter(c -> c.sounds), (App)ParticleParticleEmitter.CODEC.listOf().optionalFieldOf("particle_emitters", List.of()).forGetter(c -> c.particles)).apply((Applicative)i, CustomParticleType::new));

    private CustomParticleType(RenderType renderType, int light, boolean hasPhysics, boolean killOnContact, LiquidAffinity liquidAffinity, @Nullable IColorGetter colormap, @Nullable ParticleInitializer initializer, @Nullable Ticker ticker, List<ParticleSoundEmitter> sounds, List<ParticleParticleEmitter> particles) {
        this.renderType = renderType;
        this.initializer = initializer;
        this.ticker = ticker;
        this.sounds = sounds;
        this.particles = particles;
        this.lightLevel = light;
        this.hasPhysics = hasPhysics;
        this.killOnContact = killOnContact;
        this.liquidAffinity = liquidAffinity;
        this.colormap = colormap;
    }

    private CustomParticleType(RenderType renderType, int light, boolean hasPhysics, boolean killOnContact, LiquidAffinity liquidAffinity, Optional<IColorGetter> colormap, Optional<ParticleInitializer> initializer, Optional<Ticker> ticker, List<ParticleSoundEmitter> sounds, List<ParticleParticleEmitter> particles) {
        this(renderType, light, hasPhysics, killOnContact, liquidAffinity, (IColorGetter)colormap.orElse(null), (ParticleInitializer)initializer.orElse(null), (Ticker)ticker.orElse(null), sounds, particles);
    }

    public static void setStateHack(class_2680 state) {
        STATE_HACK = state;
    }

    private RenderType getRenderType() {
        return this.renderType;
    }

    @Override
    public class_703 createParticle(class_2400 type, class_638 world, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state) {
        if (this.spriteSet != null) {
            Instance newParticle = new Instance(world, x, y, z, xSpeed, ySpeed, zSpeed, state, this, class_7923.field_41180.method_10221((Object)type));
            if (this.hasPhysics) {
                for (class_265 voxelShape : world.method_20812(null, newParticle.method_3064())) {
                    if (voxelShape.method_1110()) continue;
                    return null;
                }
            }
            if (this.ticker != null && this.ticker.removeIf != null && this.ticker.removeIf.getValue((class_703)newParticle, (class_1937)world) > 0.0) {
                return null;
            }
            return newParticle;
        }
        throw new IllegalStateException("Sprite set not set for custom particle type");
    }

    @Override
    public void setSpriteSet(class_702.class_4090 mutableSpriteSet) {
        this.spriteSet = mutableSpriteSet;
    }

    private static enum RenderType implements class_3542
    {
        TERRAIN,
        OPAQUE,
        TRANSLUCENT,
        LIT,
        INVISIBLE;

        public static final Codec<RenderType> CODEC;

        public class_3999 get() {
            return switch (this.ordinal()) {
                case 0 -> class_3999.field_17827;
                case 2 -> class_3999.field_17829;
                case 3 -> class_3999.field_17830;
                case 4 -> class_3999.field_17832;
                default -> class_3999.field_17828;
            };
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(RenderType::values);
        }
    }

    protected record Ticker(@Nullable ParticleContextExpression x, @Nullable ParticleContextExpression y, @Nullable ParticleContextExpression z, @Nullable ParticleContextExpression dx, @Nullable ParticleContextExpression dy, @Nullable ParticleContextExpression dz, @Nullable ParticleContextExpression size, @Nullable ParticleContextExpression red, @Nullable ParticleContextExpression green, @Nullable ParticleContextExpression blue, @Nullable ParticleContextExpression alpha, @Nullable ParticleContextExpression roll, @Nullable ParticleContextExpression custom, @Nullable ParticleContextExpression removeIf) {
        private static final Codec<Ticker> CODEC = RecordCodecBuilder.create(i -> i.group((App)ParticleContextExpression.CODEC.optionalFieldOf("x").forGetter(p -> Optional.ofNullable(p.x)), (App)ParticleContextExpression.CODEC.optionalFieldOf("y").forGetter(p -> Optional.ofNullable(p.y)), (App)ParticleContextExpression.CODEC.optionalFieldOf("z").forGetter(p -> Optional.ofNullable(p.z)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dx").forGetter(p -> Optional.ofNullable(p.dx)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dy").forGetter(p -> Optional.ofNullable(p.dy)), (App)ParticleContextExpression.CODEC.optionalFieldOf("dz").forGetter(p -> Optional.ofNullable(p.dz)), (App)ParticleContextExpression.CODEC.optionalFieldOf("size").forGetter(p -> Optional.ofNullable(p.size)), (App)ParticleContextExpression.CODEC.optionalFieldOf("red").forGetter(p -> Optional.ofNullable(p.red)), (App)ParticleContextExpression.CODEC.optionalFieldOf("green").forGetter(p -> Optional.ofNullable(p.green)), (App)ParticleContextExpression.CODEC.optionalFieldOf("blue").forGetter(p -> Optional.ofNullable(p.blue)), (App)ParticleContextExpression.CODEC.optionalFieldOf("alpha").forGetter(p -> Optional.ofNullable(p.alpha)), (App)ParticleContextExpression.CODEC.optionalFieldOf("roll").forGetter(p -> Optional.ofNullable(p.roll)), (App)ParticleContextExpression.CODEC.optionalFieldOf("custom").forGetter(p -> Optional.ofNullable(p.custom)), (App)ParticleContextExpression.CODEC.optionalFieldOf("remove_condition").forGetter(p -> Optional.ofNullable(p.removeIf))).apply((Applicative)i, Ticker::new));

        private Ticker(Optional<ParticleContextExpression> x, Optional<ParticleContextExpression> y, Optional<ParticleContextExpression> z, Optional<ParticleContextExpression> dx, Optional<ParticleContextExpression> dy, Optional<ParticleContextExpression> dz, Optional<ParticleContextExpression> size, Optional<ParticleContextExpression> red, Optional<ParticleContextExpression> green, Optional<ParticleContextExpression> blue, Optional<ParticleContextExpression> alpha, Optional<ParticleContextExpression> roll, Optional<ParticleContextExpression> custom, Optional<ParticleContextExpression> removeIf) {
            this((ParticleContextExpression)x.orElse(null), (ParticleContextExpression)y.orElse(null), (ParticleContextExpression)z.orElse(null), (ParticleContextExpression)dx.orElse(null), (ParticleContextExpression)dy.orElse(null), (ParticleContextExpression)dz.orElse(null), (ParticleContextExpression)size.orElse(null), (ParticleContextExpression)red.orElse(null), (ParticleContextExpression)green.orElse(null), (ParticleContextExpression)blue.orElse(null), (ParticleContextExpression)alpha.orElse(null), (ParticleContextExpression)roll.orElse(null), (ParticleContextExpression)custom.orElse(null), (ParticleContextExpression)removeIf.orElse(null));
        }

        private void tick(Instance particle, class_638 level) {
            if (this.roll != null) {
                particle.field_3857 = particle.field_3839;
                particle.field_3839 = (float)particle.ticker.roll.getValue((class_703)particle, (class_1937)level);
            }
            if (this.size != null) {
                particle.oQuadSize = particle.field_17867;
                particle.field_17867 = (float)this.size.getValue((class_703)particle, (class_1937)level);
            }
            if (this.red != null) {
                particle.field_3861 = (float)this.red.getValue((class_703)particle, (class_1937)level);
            }
            if (this.green != null) {
                particle.field_3842 = (float)this.green.getValue((class_703)particle, (class_1937)level);
            }
            if (this.blue != null) {
                particle.field_3859 = (float)this.blue.getValue((class_703)particle, (class_1937)level);
            }
            if (this.alpha != null) {
                particle.field_3841 = (float)this.alpha.getValue((class_703)particle, (class_1937)level);
            }
            if (this.x != null) {
                particle.field_3874 = this.x.getValue((class_703)particle, (class_1937)level);
            }
            if (this.y != null) {
                particle.field_3854 = this.y.getValue((class_703)particle, (class_1937)level);
            }
            if (this.z != null) {
                particle.field_3871 = this.z.getValue((class_703)particle, (class_1937)level);
            }
            if (this.dx != null) {
                particle.field_3852 = this.dx.getValue((class_703)particle, (class_1937)level);
            }
            if (this.dy != null) {
                particle.field_3869 = this.dy.getValue((class_703)particle, (class_1937)level);
            }
            if (this.dz != null) {
                particle.field_3850 = this.dz.getValue((class_703)particle, (class_1937)level);
            }
            if (this.custom != null) {
                particle.custom = this.custom.getValue((class_703)particle, (class_1937)level);
            }
            if (this.removeIf != null && this.removeIf.getValue((class_703)particle, (class_1937)level) > 0.0) {
                particle.method_3085();
            }
        }
    }

    protected static enum LiquidAffinity implements class_3542
    {
        LIQUIDS,
        NON_LIQUIDS,
        ANY;

        private static final Codec<LiquidAffinity> CODEC;

        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = class_3542.method_28140(LiquidAffinity::values);
        }
    }

    public static class Instance
    extends class_4003 {
        protected final class_3999 renderType;
        @Nullable
        protected final Ticker ticker;
        protected final class_4002 spriteSet;
        protected final LiquidAffinity liquidAffinity;
        @Nullable
        protected final IColorGetter colormap;
        protected final List<ParticleTickable> tickables;
        protected final int light;
        protected float oQuadSize;
        protected double custom;
        protected boolean killOnContact;
        private class_2960 name;

        protected Instance(class_638 level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, @Nullable class_2680 state, CustomParticleType customType, class_2960 typeId) {
            super(level, x, y, z, xSpeed, ySpeed, zSpeed);
            this.method_3080(0.1f, 0.1f);
            this.name = typeId;
            this.light = customType.lightLevel;
            this.killOnContact = customType.killOnContact;
            this.colormap = customType.colormap;
            this.tickables = new ArrayList<ParticleTickable>();
            this.tickables.addAll(customType.sounds);
            this.tickables.addAll(customType.particles);
            if (state == null) {
                state = STATE_HACK;
            }
            this.field_3874 = x;
            this.field_3854 = y;
            this.field_3871 = z;
            this.field_3852 = xSpeed;
            this.field_3869 = ySpeed;
            this.field_3850 = zSpeed;
            this.renderType = customType.renderType.get();
            this.ticker = customType.ticker;
            this.spriteSet = customType.spriteSet;
            ParticleInitializer initializer = customType.initializer;
            class_2338 pos = class_2338.method_49637((double)x, (double)y, (double)z);
            if (initializer != null) {
                initializer.initialize((class_3940)this, level, state, pos);
            }
            this.oQuadSize = this.field_17867;
            this.liquidAffinity = customType.liquidAffinity;
            this.field_3862 = customType.hasPhysics;
            if (this.colormap != null) {
                float[] unpack = ColorUtils.unpack(this.colormap.getColor(state, (class_1920)level, pos, 0));
                this.method_3084(unpack[0], unpack[1], unpack[2]);
            }
            this.method_18142(this.spriteSet);
        }

        public double getCustom() {
            return this.custom;
        }

        protected int method_3068(float partialTick) {
            int total = super.method_3068(partialTick);
            if (this.light > 0) {
                int sky = class_765.method_24187((int)total);
                int block = class_765.method_24186((int)total);
                block = Math.max(block, this.light);
                return class_765.method_23687((int)block, (int)sky);
            }
            return total;
        }

        public void method_3070() {
            class_2680 state;
            this.method_18142(this.spriteSet);
            super.method_3070();
            if (this.ticker != null) {
                this.ticker.tick(this, this.field_3851);
            }
            if (this.colormap != null) {
                class_2338 pos = class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871);
                float[] unpack = ColorUtils.unpack(this.colormap.getColor(null, (class_1920)this.field_3851, pos, 0));
                this.method_3084(unpack[0], unpack[1], unpack[2]);
            }
            if (this.field_3866 > 1 && this.field_3874 == this.field_3858 && this.field_3854 == this.field_3838 && this.field_3871 == this.field_3856 && this.field_3862) {
                this.method_3085();
            }
            if (this.field_3862 && this.field_21507) {
                this.method_3085();
            }
            if (this.liquidAffinity != LiquidAffinity.ANY && this.liquidAffinity == LiquidAffinity.LIQUIDS ^ !(state = this.field_3851.method_8320(class_2338.method_49637((double)this.field_3874, (double)this.field_3854, (double)this.field_3871))).method_26227().method_15769()) {
                this.method_3085();
            }
            if (!this.field_3843) {
                for (ParticleTickable tickable : this.tickables) {
                    tickable.tick((class_703)this, (class_1937)this.field_3851);
                }
            }
        }

        public void method_3069(double x, double y, double z) {
            class_243 wantedPos;
            class_243 myPos;
            super.method_3069(x, y, z);
            if (this.killOnContact && this.field_3866 > 1 && (myPos = new class_243(this.field_3874, this.field_3854, this.field_3871)).method_1025(wantedPos = new class_243(this.field_3858 + x, this.field_3838 + y, this.field_3856 + z)) > 1.0E-6) {
                this.method_3085();
                this.field_3852 = 0.0;
                this.field_3869 = 0.0;
                this.field_3850 = 0.0;
            }
        }

        public float method_18132(float scaleFactor) {
            return class_3532.method_16439((float)scaleFactor, (float)this.oQuadSize, (float)this.field_17867);
        }

        public class_3999 method_18122() {
            return this.renderType;
        }
    }
}

