/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.particle;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import net.mehvahdjukaar.polytone.particle.CustomParticleType;
import net.mehvahdjukaar.polytone.utils.ClientFrameTicker;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.mehvahdjukaar.polytone.utils.ExpressionUtils;
import net.minecraft.class_1937;
import net.minecraft.class_3532;
import net.minecraft.class_3940;
import net.minecraft.class_703;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import net.objecthunter.exp4j.operator.Operator;

public class ParticleContextExpression {
    private final Expression expression;
    private final String unparsed;
    private static final String COLOR = "COLOR";
    private static final String SPEED = "SPEED";
    private static final String X = "X";
    private static final String Y = "Y";
    private static final String Z = "Z";
    private static final String DX = "DX";
    private static final String DY = "DY";
    private static final String DZ = "DZ";
    private static final String RED = "RED";
    private static final String GREEN = "GREEN";
    private static final String BLUE = "BLUE";
    private static final String ALPHA = "ALPHA";
    private static final String SIZE = "SIZE";
    private static final String LIFE = "LIFETIME";
    private static final String AGE = "AGE";
    private static final String ROLL = "ROLL";
    private static final String CUSTOM = "CUSTOM";
    private static final String DAY_TIME = "DAY_TIME";
    private static final String TIME = "TIME";
    private static final String RAIN = "RAIN";
    public static final Codec<ParticleContextExpression> CODEC = Codec.STRING.flatXmap(s -> {
        try {
            Expression compiled = ParticleContextExpression.createExpression(s);
            return DataResult.success((Object)new ParticleContextExpression(compiled, (String)s));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Failed to parse expression:" + e.getMessage());
        }
    }, javaxExpression -> DataResult.success((Object)javaxExpression.unparsed));
    private final boolean hasTime;
    private final boolean hasRain;
    private final boolean hasDayTime;
    private final boolean hasCustom;
    public static final ParticleContextExpression ZERO = new ParticleContextExpression("0");
    public static final ParticleContextExpression ONE = new ParticleContextExpression("1");
    public static final ParticleContextExpression PARTICLE_RAND = new ParticleContextExpression("(rand() * 2.0 - 1.0) * 0.4");

    public ParticleContextExpression(String expression) {
        this(ParticleContextExpression.createExpression(expression), expression);
    }

    public ParticleContextExpression(Expression expression, String unparsed) {
        this.expression = expression;
        this.unparsed = unparsed;
        this.hasTime = unparsed.contains(TIME);
        this.hasRain = unparsed.contains(RAIN);
        this.hasDayTime = unparsed.contains(DAY_TIME);
        this.hasCustom = unparsed.contains(CUSTOM);
    }

    public static ParticleContextExpression parse(String s) {
        return new ParticleContextExpression(ParticleContextExpression.createExpression(s), s);
    }

    private static Expression createExpression(String s) {
        return new ExpressionBuilder(ExpressionUtils.removeHex(s)).functions(ExpressionUtils.defFunc(new Function[0])).variables(new String[]{COLOR, SPEED, X, Y, Z, DX, DY, DZ, RED, GREEN, BLUE, ALPHA, SIZE, LIFE, ROLL, AGE, CUSTOM, TIME, RAIN, DAY_TIME}).operator(ExpressionUtils.defOp(new Operator[0])).build();
    }

    public double getValue(class_703 particle, class_1937 level) {
        this.expression.setVariable(LIFE, (double)particle.method_3082());
        int pack = ColorUtils.pack(particle.field_3861, particle.field_3842, particle.field_3859);
        this.expression.setVariable(COLOR, (double)pack);
        this.expression.setVariable(RED, (double)particle.field_3861);
        this.expression.setVariable(GREEN, (double)particle.field_3842);
        this.expression.setVariable(BLUE, (double)particle.field_3859);
        this.expression.setVariable(SPEED, class_3532.method_33825((double)particle.field_3852, (double)particle.field_3869, (double)particle.field_3850));
        this.expression.setVariable(ALPHA, (double)particle.field_3841);
        this.expression.setVariable(SIZE, (double)((class_3940)particle).field_17867);
        this.expression.setVariable(DX, particle.field_3852);
        this.expression.setVariable(DX, particle.field_3869);
        this.expression.setVariable(DX, particle.field_3850);
        this.expression.setVariable(DX, particle.field_3874);
        this.expression.setVariable(DX, particle.field_3854);
        this.expression.setVariable(DX, particle.field_3871);
        this.expression.setVariable(AGE, (double)particle.field_3866);
        this.expression.setVariable(ROLL, (double)particle.field_3839);
        if (this.hasCustom && particle instanceof CustomParticleType.Instance) {
            CustomParticleType.Instance i = (CustomParticleType.Instance)particle;
            this.expression.setVariable(CUSTOM, i.getCustom());
        }
        if (this.hasTime) {
            this.expression.setVariable(TIME, ClientFrameTicker.getGameTime());
        }
        if (this.hasRain) {
            this.expression.setVariable(RAIN, (double)ClientFrameTicker.getRainAndThunder());
        }
        if (this.hasDayTime) {
            this.expression.setVariable(DAY_TIME, ClientFrameTicker.getDayTime());
        }
        ExpressionUtils.randomizeRandom();
        return this.expression.evaluate();
    }
}

