/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.slotify;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.slotify.SimpleSprite;
import net.mehvahdjukaar.polytone.slotify.SlotModifier;
import net.mehvahdjukaar.polytone.slotify.SpecialOffset;
import net.mehvahdjukaar.polytone.slotify.WidgetModifier;
import net.mehvahdjukaar.polytone.utils.ColorUtils;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public record GuiModifier(Type type, String target, List<SlotModifier> slotModifiers, int titleX, int titleY, int labelX, int labelY, @Nullable Integer titleColor, @Nullable Integer labelColor, List<SimpleSprite> sprites, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
    public static final Codec<GuiModifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_3542.method_28140(Type::values).fieldOf("target_type").forGetter(GuiModifier::type), (App)Codec.STRING.xmap(PlatStuff::maybeRemapName, PlatStuff::maybeRemapName).fieldOf("target").forGetter(GuiModifier::target), (App)SlotModifier.CODEC.listOf().optionalFieldOf("slot_modifiers", List.of()).forGetter(GuiModifier::slotModifiers), (App)Codec.INT.optionalFieldOf("title_x_offset", (Object)0).forGetter(GuiModifier::titleX), (App)Codec.INT.optionalFieldOf("title_y_offset", (Object)0).forGetter(GuiModifier::titleY), (App)Codec.INT.optionalFieldOf("label_x_offset", (Object)0).forGetter(GuiModifier::labelX), (App)Codec.INT.optionalFieldOf("label_y_offset", (Object)0).forGetter(GuiModifier::labelY), (App)ColorUtils.CODEC.optionalFieldOf("title_color").forGetter(g -> Optional.ofNullable(g.titleColor)), (App)ColorUtils.CODEC.optionalFieldOf("label_color").forGetter(g -> Optional.ofNullable(g.labelColor)), (App)SimpleSprite.CODEC.listOf().optionalFieldOf("sprites", List.of()).forGetter(GuiModifier::sprites), (App)WidgetModifier.CODEC.listOf().optionalFieldOf("widget_modifiers", List.of()).forGetter(GuiModifier::widgetModifiers), (App)Codec.unboundedMap((Codec)Codec.STRING, SpecialOffset.CODEC).optionalFieldOf("special_offsets", Map.of()).forGetter(GuiModifier::specialOffsets)).apply((Applicative)i, GuiModifier::new)).comapFlatMap(instance -> {
        Optional error;
        if (instance.type == Type.MENU_ID && (error = class_2960.method_29186((String)instance.target).error()).isPresent()) {
            return DataResult.error(() -> ((DataResult.Error)error.get()).message());
        }
        if ((instance.type == Type.SCREEN_CLASS || instance.type == Type.SCREEN_TITLE) && instance.slotModifiers.stream().anyMatch(SlotModifier::hasOffset)) {
            return DataResult.error(() -> "Slot modifiers cannot alter position when using a screen_class or screen_title target_type. Use menu_id or menu_class instead");
        }
        return DataResult.success((Object)instance);
    }, Function.identity());

    public GuiModifier(Type type, String target, List<SlotModifier> slotModifiers, int titleX, int titleY, int labelX, int labelY, Optional<Integer> titleColor, Optional<Integer> labelColor, List<SimpleSprite> sprites, List<WidgetModifier> widgetModifiers, Map<String, SpecialOffset> specialOffsets) {
        this(type, target, slotModifiers, titleX, titleY, labelX, labelY, (Integer)titleColor.orElse(null), (Integer)labelColor.orElse(null), sprites, widgetModifiers, specialOffsets);
    }

    public boolean targetsClass() {
        return this.type != Type.MENU_ID && this.type != Type.SCREEN_TITLE;
    }

    public boolean targetsMenuId() {
        return this.type == Type.MENU_ID;
    }

    public static enum Type implements class_3542
    {
        MENU_ID,
        MENU_CLASS,
        SCREEN_CLASS,
        SCREEN_TITLE;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

