/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.sound;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.sound.PolytoneSoundType;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class SoundTypesManager
extends PartialReloader<Resources> {
    private final List<class_2960> customSoundEvents = new ArrayList<class_2960>();
    private final MapRegistry<class_2498> customSoundTypes = new MapRegistry("Custom Sound Types");

    public SoundTypesManager() {
        super("custom_sound_types", "sound_types");
    }

    @Nullable
    public class_2498 getCustomSoundType(class_2960 resourceLocation) {
        return this.customSoundTypes.getValue(resourceLocation);
    }

    @Override
    protected Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        Map<class_2960, List<String>> types = CsvUtils.parseCsv(resourceManager, "sound_events");
        return new Resources(jsons, types);
    }

    @Override
    public void process(Resources resources, DynamicOps<JsonElement> ops) {
        Map<class_2960, JsonElement> soundJsons = resources.soundTypes;
        Map<class_2960, List<String>> soundEvents = resources.soundEvents;
        for (Map.Entry<class_2960, List<String>> entry : soundEvents.entrySet()) {
            for (String s : entry.getValue()) {
                class_2960 id = entry.getKey().method_45136(s);
                if (!this.customSoundEvents.contains(id) && !class_7923.field_41172.method_10250(id)) {
                    class_3414 newSound = PlatStuff.registerDynamic(class_7923.field_41172, id, class_3414.method_47908((class_2960)id));
                    this.customSoundEvents.add(id);
                    continue;
                }
                Polytone.LOGGER.error("Sound Event with id {} already exists! Ignoring.", (Object)id);
            }
        }
        if (!this.customSoundEvents.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Sound Events from Resource Packs: {}", (Object)this.customSoundEvents.size(), (Object)(String.valueOf(this.customSoundEvents) + ". Remember to add them to sounds.json!"));
            class_310.method_1551().method_1483().method_38566();
        }
        for (Map.Entry<class_2960, List<String>> entry : soundJsons.entrySet()) {
            JsonElement json = (JsonElement)entry.getValue();
            class_2960 id = entry.getKey();
            class_2498 soundType = (class_2498)((Pair)PolytoneSoundType.DIRECT_CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Sound Type with json id " + String.valueOf(id) + "\n error: " + errorMsg))).getFirst();
            this.customSoundTypes.register(id, soundType);
        }
    }

    @Override
    protected void reset() {
        PlatStuff.unregisterAllDynamic(class_7923.field_41172, this.customSoundEvents);
        this.customSoundTypes.clear();
        this.customSoundEvents.clear();
    }

    public record Resources(Map<class_2960, JsonElement> soundTypes, Map<class_2960, List<String>> soundEvents) {
    }
}

