/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.polytone.PlatStuff;
import net.mehvahdjukaar.polytone.Polytone;
import net.mehvahdjukaar.polytone.tabs.CreativeTabModifier;
import net.mehvahdjukaar.polytone.tabs.ItemToTabEvent;
import net.mehvahdjukaar.polytone.utils.CsvUtils;
import net.mehvahdjukaar.polytone.utils.PartialReloader;
import net.minecraft.class_1761;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class CreativeTabsModifiersManager
extends PartialReloader<Resources> {
    private final List<class_5321<class_1761>> customTabs = new ArrayList<class_5321<class_1761>>();
    private final Map<class_5321<class_1761>, CreativeTabModifier> modifiers = new HashMap<class_5321<class_1761>, CreativeTabModifier>();
    private final Set<class_5321<class_1761>> needsRefresh = new HashSet<class_5321<class_1761>>();
    private final Map<class_5321<class_1761>, CreativeTabModifier> vanillaTabs = new HashMap<class_5321<class_1761>, CreativeTabModifier>();

    public CreativeTabsModifiersManager() {
        super("creative_tab_modifiers");
    }

    @Override
    public Resources prepare(class_3300 resourceManager) {
        Map<class_2960, JsonElement> jsons = this.getJsonsInDirectories(resourceManager);
        this.checkConditions(jsons);
        Map<class_2960, List<String>> types = CsvUtils.parseCsv(resourceManager, "creative_tabs");
        return new Resources(jsons, types);
    }

    @Override
    protected void reset() {
        for (class_5321<class_1761> class_53212 : this.customTabs) {
            PlatStuff.unregisterDynamic(class_7923.field_44687, class_53212.method_29177());
        }
        this.customTabs.clear();
        for (Map.Entry entry : this.vanillaTabs.entrySet()) {
            ((CreativeTabModifier)entry.getValue()).applyAttributes((class_5321<class_1761>)((class_5321)entry.getKey()));
        }
        this.vanillaTabs.clear();
        this.needsRefresh.addAll(this.modifiers.keySet());
        this.modifiers.clear();
    }

    @Override
    protected void process(Resources resources, DynamicOps<JsonElement> ops) {
        class_2960 id;
        for (Map.Entry<class_2960, List<String>> e : resources.extraTabs.entrySet()) {
            for (String s : e.getValue()) {
                id = e.getKey().method_45136(s);
                class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)id);
                if (!this.customTabs.contains(key) && !class_7923.field_44687.method_35842(key)) {
                    class_1761 tab = PlatStuff.createCreativeTab(id);
                    PlatStuff.registerDynamic(class_7923.field_44687, id, tab);
                    this.customTabs.add((class_5321<class_1761>)key);
                    continue;
                }
                Polytone.LOGGER.error("Creative Tab with id {} already exists! Ignoring.", (Object)id);
            }
        }
        if (!this.customTabs.isEmpty()) {
            Polytone.LOGGER.info("Registered {} custom Creative Tabs from Resource Packs: {}", (Object)this.customTabs.size(), (Object)(String.valueOf(this.customTabs) + ". Remember to add items to them!"));
        }
        Map<class_2960, JsonElement> jsons = resources.tabsModifiers;
        for (Map.Entry<class_2960, JsonElement> j : jsons.entrySet()) {
            JsonElement json = j.getValue();
            id = j.getKey();
            CreativeTabModifier modifier = (CreativeTabModifier)((Pair)CreativeTabModifier.CODEC.decode(ops, (Object)json).getOrThrow(errorMsg -> new IllegalStateException("Could not decode Creative Mode Tab Modifier with json id " + String.valueOf(id) + " - error: " + errorMsg))).getFirst();
            this.addModifier(id, modifier);
        }
        if (!this.modifiers.isEmpty()) {
            this.needsRefresh.addAll(this.modifiers.keySet());
        }
    }

    @Override
    protected void apply() {
        if (class_310.method_1551().field_1687 != null && !this.needsRefresh.isEmpty()) {
            class_7706.field_42466 = null;
            this.needsRefresh.clear();
        }
    }

    private void addModifier(class_2960 fileId, CreativeTabModifier mod) {
        for (class_2960 id : mod.getTargetsKeys(fileId)) {
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_44688, (class_2960)id);
            this.modifiers.merge((class_5321<class_1761>)key, mod, CreativeTabModifier::merge);
            PlatStuff.addTabEventForTab((class_5321<class_1761>)key);
        }
    }

    public void modifyTab(ItemToTabEvent event) {
        class_5455 access;
        class_5321<class_1761> tab = event.getTab();
        CreativeTabModifier mod = this.modifiers.get(tab);
        if (mod != null && (access = PlatStuff.hackyGetRegistryAccess()) != null) {
            CreativeTabModifier v = mod.applyItemsAndAttributes(event, access);
            if (!this.customTabs.contains(tab)) {
                this.vanillaTabs.put(tab, v);
            }
        }
    }

    public record Resources(Map<class_2960, JsonElement> tabsModifiers, Map<class_2960, List<String>> extraTabs) {
    }
}

