/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.tabs;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.mehvahdjukaar.polytone.utils.MapRegistry;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public interface ItemPredicate
extends Predicate<class_1799> {
    public static final MapRegistry.CodecMap<ItemPredicate> TYPES = MapRegistry.ofCodec("Polytone Item Predicates");
    public static final Codec<ItemPredicate> CODEC = TYPES.dispatch("type", ItemPredicate::getCodec, c -> c);
    public static final True TRUE_PRED = new True();
    public static final MapCodec<True> TRUE = TYPES.register("true", MapCodec.unit((Object)TRUE_PRED));
    public static final MapCodec<And> AND = TYPES.register("and", CODEC.listOf().fieldOf("predicates").xmap(And::new, And::predicates));
    public static final MapCodec<Or> OR = TYPES.register("or", CODEC.listOf().fieldOf("predicates").xmap(Or::new, Or::predicates));
    public static final MapCodec<Not> NOT = TYPES.register("not", CODEC.fieldOf("predicate").xmap(Not::new, Not::predicate));
    public static final MapCodec<TagMatch> TAG_MATCH = TYPES.register("tag_match", class_6862.method_40090((class_5321)class_7924.field_41197).fieldOf("tag").xmap(TagMatch::new, TagMatch::tag));
    public static final MapCodec<ItemMatch> ITEM_MATCH = TYPES.register("items_match", class_7923.field_41178.method_39673().listOf().fieldOf("items").xmap(ItemMatch::new, ItemMatch::items));
    public static final MapCodec<ItemStackMatch> ITEMSTACK_MATCH = TYPES.register("itemstack_match", class_1799.field_49747.fieldOf("itemstack").xmap(ItemStackMatch::new, ItemStackMatch::items));
    public static final Pattern TRUE_PATTERN = Pattern.compile(".*");
    public static final MapCodec<IDMatch> ID_MATCH = TYPES.register("id_match", RecordCodecBuilder.mapCodec(i -> i.group((App)class_5699.field_37408.optionalFieldOf("namespace", (Object)TRUE_PATTERN).forGetter(IDMatch::namespace), (App)class_5699.field_37408.optionalFieldOf("path", (Object)TRUE_PATTERN).forGetter(IDMatch::path)).apply((Applicative)i, IDMatch::new)));

    public MapCodec<? extends ItemPredicate> getCodec();

    public static class True
    implements ItemPredicate {
        @Override
        public boolean test(class_1799 stack) {
            return true;
        }

        public MapCodec<True> getCodec() {
            return TRUE;
        }
    }

    public record IDMatch(Pattern namespace, Pattern path) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            class_1792 item = stack.method_7909();
            class_2960 id = class_7923.field_41178.method_10221((Object)item);
            return this.namespace.matcher(id.method_12836()).matches() && this.path.matcher(id.method_12832()).matches();
        }

        public MapCodec<IDMatch> getCodec() {
            return ID_MATCH;
        }
    }

    public record ItemStackMatch(class_1799 items) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return class_1799.method_7973((class_1799)this.items, (class_1799)stack);
        }

        public MapCodec<ItemStackMatch> getCodec() {
            return ITEMSTACK_MATCH;
        }
    }

    public record ItemMatch(List<class_1792> items) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return this.items.contains(stack.method_7909());
        }

        public MapCodec<ItemMatch> getCodec() {
            return ITEM_MATCH;
        }
    }

    public record TagMatch(class_6862<class_1792> tag) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return stack.method_31573(this.tag);
        }

        public MapCodec<TagMatch> getCodec() {
            return TAG_MATCH;
        }
    }

    public record Not(ItemPredicate predicate) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return !this.predicate.test(stack);
        }

        public MapCodec<Not> getCodec() {
            return NOT;
        }
    }

    public record Or(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return this.predicates.stream().anyMatch(p -> p.test(stack));
        }

        public MapCodec<Or> getCodec() {
            return OR;
        }
    }

    public record And(List<ItemPredicate> predicates) implements ItemPredicate
    {
        @Override
        public boolean test(class_1799 stack) {
            return this.predicates.stream().allMatch(p -> p.test(stack));
        }

        @Override
        public MapCodec<? extends ItemPredicate> getCodec() {
            return AND;
        }
    }
}

