/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.polytone.utils;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.mehvahdjukaar.polytone.Polytone;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public interface ITargetProvider {
    public static final Codec<Set<class_2960>> TARGET_CODEC = Codec.withAlternative((Codec)class_2960.field_25139.listOf(), (Codec)class_2960.field_25139, List::of).xmap(Set::copyOf, List::copyOf);

    default public <T> Set<T> mergeSet(Set<T> first, Set<T> second) {
        HashSet<T> set = new HashSet<T>();
        set.addAll(first);
        set.addAll(second);
        return Collections.unmodifiableSet(set);
    }

    default public <T> List<T> mergeList(List<T> first, List<T> second) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(first);
        list.addAll(second);
        return Collections.unmodifiableList(list);
    }

    @NotNull
    public Set<class_2960> explicitTargets();

    default public Set<class_2960> getTargetsKeys(class_2960 fileId) {
        Set<class_2960> expl = this.explicitTargets();
        if (expl.isEmpty()) {
            return Set.of(fileId);
        }
        return expl;
    }

    default public <T> Set<T> getTargets(class_2960 fileId, class_2378<T> registry) {
        HashSet set = new HashSet();
        Set<class_2960> explTargets = this.explicitTargets();
        Optional implicitTarget = registry.method_17966(fileId);
        if (!explTargets.isEmpty()) {
            if (implicitTarget.isPresent() && !explTargets.contains(fileId)) {
                Polytone.LOGGER.error("Found Polytone file with explicit Targets ({}) also having a valid IMPLICIT (file path) Target ({}).Consider moving it under your OWN namespace to avoid overriding other packs modifiers with the same path", explTargets, (Object)fileId);
            }
            for (class_2960 explicitId : explTargets) {
                Optional target = registry.method_17966(explicitId);
                target.ifPresent(set::add);
            }
        } else if (implicitTarget.isPresent()) {
            set.add(implicitTarget.get());
        } else {
            Polytone.LOGGER.error("Found Polytone file {} with no valid implicit target and no explicit targets from registry {}", (Object)fileId, registry);
        }
        return set;
    }
}

