/*
 * Decompiled with CFR 0.152.
 */
package lol.bai.badpackets.impl.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import lol.bai.badpackets.api.PacketReceiver;
import lol.bai.badpackets.api.config.ClientConfigContext;
import lol.bai.badpackets.api.config.ServerConfigContext;
import lol.bai.badpackets.api.play.ClientPlayContext;
import lol.bai.badpackets.api.play.ServerPlayContext;
import lol.bai.badpackets.impl.Constants;
import lol.bai.badpackets.impl.handler.AbstractPacketHandler;
import lol.bai.badpackets.impl.payload.UntypedPayload;
import lol.bai.badpackets.impl.registry.ChannelCodecFinder;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ChannelRegistry<B extends class_2540, C>
implements ChannelCodecFinder {
    private static final Set<class_2960> RESERVED_CHANNELS = Set.of(Constants.CHANNEL_SYNC, Constants.MC_REGISTER_CHANNEL, Constants.MC_UNREGISTER_CHANNEL);
    public static final ChannelRegistry<class_2540, ClientConfigContext> CONFIG_S2C = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<class_2540, ServerConfigContext> CONFIG_C2S = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<class_9129, ClientPlayContext> PLAY_S2C = new ChannelRegistry(RESERVED_CHANNELS);
    public static final ChannelRegistry<class_9129, ServerPlayContext> PLAY_C2S = new ChannelRegistry(RESERVED_CHANNELS);
    private final Set<class_2960> reservedChannels;
    private final Map<class_2960, class_9139<?, ?>> codecs = new HashMap();
    private final Map<class_2960, PacketReceiver<C, class_8710>> receivers = new HashMap<class_2960, PacketReceiver<C, class_8710>>();
    private final Set<AbstractPacketHandler<C, B>> handlers = new HashSet<AbstractPacketHandler<C, B>>();
    private final ReentrantReadWriteLock locks = new ReentrantReadWriteLock();

    private ChannelRegistry(Set<class_2960> reservedChannels) {
        this.reservedChannels = reservedChannels;
        this.codecs.put(Constants.CHANNEL_SYNC, UntypedPayload.codec(Constants.CHANNEL_SYNC));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P extends class_8710> void registerCodec(class_2960 id, class_9139<? super B, P> codec) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            if (this.reservedChannels.contains(id)) {
                throw new IllegalArgumentException("Reserved channel id " + String.valueOf(id));
            }
            this.codecs.put(id, codec);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerReceiver(class_2960 id, PacketReceiver<C, class_8710> receiver) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            if (!this.codecs.containsKey(id)) {
                throw new IllegalArgumentException("Unknown channel id " + String.valueOf(id));
            }
            this.receivers.put(id, receiver);
            for (AbstractPacketHandler<C, B> handler : this.handlers) {
                handler.onRegister(id);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean has(class_2960 id) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            boolean bl = this.receivers.containsKey(id);
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketReceiver<C, class_8710> get(class_2960 id) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            PacketReceiver<C, class_8710> packetReceiver = this.receivers.get(id);
            return packetReceiver;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public class_9139<class_2540, class_8710> getCodec(class_2960 id, class_2540 buf) {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            class_9139<?, ?> class_91392 = this.codecs.get(id);
            return class_91392;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<class_2960> getChannels() {
        ReentrantReadWriteLock.ReadLock lock = this.locks.readLock();
        lock.lock();
        try {
            HashSet<class_2960> hashSet = new HashSet<class_2960>(this.receivers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public void addHandler(AbstractPacketHandler<C, B> handler) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.handlers.add(handler);
        }
        finally {
            lock.unlock();
        }
    }

    public void removeHandler(AbstractPacketHandler<C, B> handler) {
        ReentrantReadWriteLock.WriteLock lock = this.locks.writeLock();
        lock.lock();
        try {
            this.handlers.remove(handler);
        }
        finally {
            lock.unlock();
        }
    }
}

