/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.fabric.common.provider;

import com.viaversion.fabric.common.platform.FabricViaAPI;
import com.viaversion.fabric.common.platform.FabricViaConfig;
import com.viaversion.fabric.common.platform.NativeVersionProvider;
import com.viaversion.fabric.common.util.FutureTaskId;
import com.viaversion.fabric.common.util.JLoggerToLog4j;
import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import com.viaversion.viaversion.api.configuration.ViaVersionConfig;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.platform.ViaPlatform;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ModMetadata;
import org.apache.logging.log4j.LogManager;

public abstract class AbstractFabricPlatform
implements ViaPlatform<UserConnection> {
    private final Logger logger = new JLoggerToLog4j(LogManager.getLogger((String)"ViaVersion"));
    private FabricViaConfig config;
    private File dataFolder;
    private final ViaAPI<UserConnection> api = new FabricViaAPI();

    public void init() {
        this.installNativeVersionProvider();
        Path configDir = FabricLoader.getInstance().getConfigDir().resolve("ViaFabric");
        this.dataFolder = configDir.toFile();
        this.config = new FabricViaConfig(configDir.resolve("viaversion.yml").toFile(), this.logger);
    }

    protected abstract void installNativeVersionProvider();

    protected abstract ExecutorService asyncService();

    protected abstract EventLoop eventLoop();

    protected FutureTaskId runEventLoop(Runnable runnable) {
        return new FutureTaskId((java.util.concurrent.Future<?>)this.eventLoop().submit(runnable).addListener(this.errorLogger()));
    }

    public FutureTaskId runAsync(Runnable runnable) {
        return new FutureTaskId((java.util.concurrent.Future<?>)((Object)CompletableFuture.runAsync(runnable, this.asyncService()).exceptionally(throwable -> {
            if (!(throwable instanceof CancellationException)) {
                throwable.printStackTrace();
            }
            return null;
        })));
    }

    public FutureTaskId runRepeatingAsync(Runnable runnable, long ticks) {
        return new FutureTaskId((java.util.concurrent.Future<?>)this.eventLoop().scheduleAtFixedRate(() -> this.runAsync(runnable), 0L, ticks * 50L, TimeUnit.MILLISECONDS).addListener(this.errorLogger()));
    }

    public FutureTaskId runSync(Runnable runnable, long ticks) {
        return new FutureTaskId((java.util.concurrent.Future<?>)this.eventLoop().schedule(() -> this.runSync(runnable), ticks * 50L, TimeUnit.MILLISECONDS).addListener(this.errorLogger()));
    }

    public FutureTaskId runRepeatingSync(Runnable runnable, long ticks) {
        return new FutureTaskId((java.util.concurrent.Future<?>)this.eventLoop().scheduleAtFixedRate(() -> this.runSync(runnable), 0L, ticks * 50L, TimeUnit.MILLISECONDS).addListener(this.errorLogger()));
    }

    protected <T extends Future<?>> GenericFutureListener<T> errorLogger() {
        return future -> {
            if (!future.isCancelled() && future.cause() != null) {
                future.cause().printStackTrace();
            }
        };
    }

    public boolean isProxy() {
        return FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT;
    }

    public void onReload() {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public ViaVersionConfig getConf() {
        return this.config;
    }

    public ViaAPI<UserConnection> getApi() {
        return this.api;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public String getPluginVersion() {
        return FabricLoader.getInstance().getModContainer("viaversion").map(ModContainer::getMetadata).map(ModMetadata::getVersion).map(Version::getFriendlyString).orElse("UNKNOWN");
    }

    public String getPlatformName() {
        return "ViaFabric";
    }

    public String getPlatformVersion() {
        return ((ModContainer)FabricLoader.getInstance().getModContainer("viafabric").get()).getMetadata().getVersion().getFriendlyString();
    }

    public boolean isPluginEnabled() {
        return true;
    }

    public JsonObject getDump() {
        JsonObject platformSpecific = new JsonObject();
        JsonArray mods = new JsonArray();
        FabricLoader.getInstance().getAllMods().stream().map(mod -> {
            JsonObject jsonMod = new JsonObject();
            jsonMod.addProperty("id", mod.getMetadata().getId());
            jsonMod.addProperty("name", mod.getMetadata().getName());
            jsonMod.addProperty("version", mod.getMetadata().getVersion().getFriendlyString());
            JsonArray authors = new JsonArray();
            mod.getMetadata().getAuthors().stream().map(it -> {
                JsonObject info = new JsonObject();
                JsonObject contact = new JsonObject();
                it.getContact().asMap().entrySet().forEach(c -> contact.addProperty((String)c.getKey(), (String)c.getValue()));
                if (contact.size() != 0) {
                    info.add("contact", (JsonElement)contact);
                }
                info.addProperty("name", it.getName());
                return info;
            }).forEach(arg_0 -> ((JsonArray)authors).add(arg_0));
            jsonMod.add("authors", (JsonElement)authors);
            return jsonMod;
        }).forEach(arg_0 -> ((JsonArray)mods).add(arg_0));
        platformSpecific.add("mods", (JsonElement)mods);
        NativeVersionProvider ver = (NativeVersionProvider)Via.getManager().getProviders().get(NativeVersionProvider.class);
        if (ver != null) {
            platformSpecific.addProperty("native version", (Number)ver.getNativeServerProtocolVersion().getVersion());
        }
        return platformSpecific;
    }

    public final boolean hasPlugin(String name) {
        return FabricLoader.getInstance().isModLoaded(name);
    }
}

