/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.client.gui.screen.collapsible;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.scroll.ScrollingContainer;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.config.entry.EntryStackProvider;
import me.shedaniel.rei.api.client.gui.widgets.CloseableScissors;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.registry.entry.CollapsibleEntryRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.client.config.collapsible.CollapsibleConfigManager;
import me.shedaniel.rei.impl.client.gui.ScreenOverlayImpl;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.CollapsibleEntryWidget;
import me.shedaniel.rei.impl.client.gui.screen.collapsible.selection.CustomCollapsibleEntrySelectionScreen;
import me.shedaniel.rei.impl.client.gui.screen.generic.OptionEntriesScreen;
import me.shedaniel.rei.impl.client.gui.widget.UpdatedListWidget;
import me.shedaniel.rei.impl.common.entry.type.EntryRegistryImpl;
import me.shedaniel.rei.impl.common.entry.type.collapsed.CollapsibleEntryRegistryImpl;
import me.shedaniel.rei.impl.common.util.HashedEntryStackWrapper;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Matrix4f;

public class CollapsibleEntriesScreen
extends class_437 {
    private final Runnable onClose;
    private final CollapsibleConfigManager.CollapsibleConfigObject configObject;
    private final List<CollapsibleEntryWidget> widgets = new ArrayList<CollapsibleEntryWidget>();
    private ListWidget listWidget;
    private boolean dirty = true;

    public CollapsibleEntriesScreen(Runnable onClose, CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        super((class_2561)class_2561.method_43471((String)"text.rei.collapsible.entries.title"));
        this.onClose = onClose;
        this.configObject = configObject;
        this.prepareWidgets(configObject);
    }

    public void prepareWidgets(CollapsibleConfigManager.CollapsibleConfigObject configObject) {
        this.widgets.clear();
        for (CollapsibleConfigManager.CustomGroup customEntry : configObject.customGroups) {
            this.widgets.add(new CollapsibleEntryWidget(true, customEntry.id, (class_2561)class_2561.method_43470((String)customEntry.name), CollectionUtils.filterAndMap(customEntry.stacks, EntryStackProvider::isValid, EntryStackProvider::provide), configObject, () -> {
                this.prepareWidgets(configObject);
                this.dirty = true;
            }));
        }
        CollapsibleEntryRegistryImpl collapsibleRegistry = (CollapsibleEntryRegistryImpl)CollapsibleEntryRegistry.getInstance();
        ListMultimap entries = Multimaps.newListMultimap(new HashMap(), ArrayList::new);
        for (HashedEntryStackWrapper hashedEntryStackWrapper : ((EntryRegistryImpl)EntryRegistry.getInstance()).getFilteredList().getList()) {
            for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
                if (!entry.getMatcher().matches(hashedEntryStackWrapper.unwrap(), hashedEntryStackWrapper.hashExact())) continue;
                entries.put((Object)entry.getId(), hashedEntryStackWrapper.unwrap());
            }
        }
        for (CollapsibleEntryRegistryImpl.Entry entry : collapsibleRegistry.getEntries()) {
            this.widgets.add(new CollapsibleEntryWidget(false, entry.getId(), entry.getName(), entries.get((Object)entry.getId()), configObject, () -> {
                this.prepareWidgets(configObject);
                this.dirty = true;
            }));
        }
    }

    public void method_25426() {
        super.method_25426();
        class_5250 backText = class_2561.method_43470((String)"\u21a9 ").method_10852((class_2561)class_2561.method_43471((String)"gui.back"));
        this.method_37063((class_364)new class_4185(this, 4, 4, this.field_22793.method_27525((class_5348)backText) + 10, 20, (class_2561)backText, button -> this.method_25419(), Supplier::get){});
        class_5250 addText = class_2561.method_43470((String)" + ");
        this.method_37063((class_364)new class_4185(this, this.field_22789 - 4 - 20, 4, 20, 20, (class_2561)addText, $ -> CollapsibleEntriesScreen.setupCustom(class_2960.method_60654((String)("custom:" + String.valueOf(UUID.randomUUID()))), "", new ArrayList(), this.configObject, () -> {
            this.prepareWidgets(this.configObject);
            this.dirty = true;
        }), Supplier::get){});
        this.listWidget = new ListWidget(this.field_22789, this.field_22790, 30);
        this.method_25396().add(this.listWidget);
        this.dirty = true;
    }

    public static void setupCustom(final class_2960 id, final String name, final List<EntryStack<?>> stacks, final CollapsibleConfigManager.CollapsibleConfigObject configObject, final Runnable markDirty) {
        class_310.method_1551().method_1507((class_437)new OptionEntriesScreen((class_2561)class_2561.method_43471((String)"text.rei.collapsible.entries.custom.title"), class_310.method_1551().field_1755){
            private OptionEntriesScreen.TextFieldListEntry entry;

            @Override
            public void addEntries(Consumer<OptionEntriesScreen.ListEntry> entryConsumer) {
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)class_2561.method_43471((String)"text.rei.collapsible.entries.custom.id").method_27692(class_124.field_1080).method_10852((class_2561)class_2561.method_43470((String)(" " + String.valueOf(id))).method_27692(class_124.field_1063)));
                this.addEmpty(entryConsumer, 10);
                this.addText(entryConsumer, (class_5348)class_2561.method_43471((String)"text.rei.collapsible.entries.custom.name").method_27692(class_124.field_1080));
                this.entry = new OptionEntriesScreen.TextFieldListEntry(this.field_22789 - 36, widget -> {
                    widget.method_1880(40);
                    if (this.entry != null) {
                        widget.method_1852(this.entry.getWidget().method_1882());
                    } else {
                        widget.method_1852(name);
                    }
                });
                entryConsumer.accept(this.entry);
                this.addEmpty(entryConsumer, 10);
                entryConsumer.accept(new OptionEntriesScreen.ButtonListEntry(this.field_22789 - 36, $ -> class_2561.method_43471((String)"text.rei.collapsible.entries.custom.select"), ($, button) -> {
                    CustomCollapsibleEntrySelectionScreen screen = new CustomCollapsibleEntrySelectionScreen(stacks);
                    screen.parent = this.field_22787.field_1755;
                    this.field_22787.method_1507((class_437)screen);
                }));
            }

            @Override
            public void save() {
                configObject.customGroups.removeIf(customGroup -> customGroup.id.equals((Object)id));
                configObject.customGroups.add(new CollapsibleConfigManager.CustomGroup(id, this.entry.getWidget().method_1882(), CollectionUtils.map(stacks, EntryStackProvider::ofStack)));
                markDirty.run();
            }
        });
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        if (this.dirty) {
            this.listWidget.clear();
            for (CollapsibleEntryWidget widget : this.widgets) {
                this.listWidget.add(widget);
            }
            this.dirty = false;
        }
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.listWidget.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_27535(this.field_22793, this.field_22785, this.field_22789 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2, 12, -1);
        if (ConfigObject.getInstance().doDebugRenderTimeRequired()) {
            class_5250 debugText = class_2561.method_43470((String)String.format("%s fps", this.field_22787.field_1770.split(" ")[0]));
            int stringWidth = this.field_22793.method_27525((class_5348)debugText);
            int n = this.field_22787.field_1755.field_22789 - stringWidth - 2;
            int n2 = this.field_22787.field_1755.field_22789;
            Objects.requireNonNull(this.field_22793);
            graphics.method_25296(n, 32, n2, 32 + 9 + 2, -16777216, -16777216);
            graphics.method_51448().method_22903();
            Matrix4f matrix = graphics.method_51448().method_23760().method_23761();
            this.field_22793.method_22942(debugText.method_30937(), (float)(this.field_22787.field_1755.field_22789 - stringWidth), 34.0f, -1, false, matrix, (class_4597)graphics.method_51450(), class_327.class_6415.field_33993, 0, 0xF000F0);
            graphics.method_51452();
            graphics.method_51448().method_22909();
        }
    }

    public void method_25420(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25420(graphics, mouseX, mouseY, delta);
        UpdatedListWidget.renderAs(this.field_22787, this.field_22789, this.field_22790, this.listWidget.top, this.field_22790, graphics, delta);
    }

    public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
        return this.listWidget.method_25401(mouseX, mouseY, amountX, amountY) || super.method_25401(mouseX, mouseY, amountX, amountY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        return this.listWidget.method_25402(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return this.listWidget.method_25403(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public void method_25419() {
        this.onClose.run();
    }

    private static class ListWidget
    extends Widget {
        private static final int PADDING = 6;
        private final int width;
        private final int height;
        private final int top;
        private final ScrollingContainer scroller = new ScrollingContainer(){

            public Rectangle getBounds() {
                return new Rectangle(0, top, width, height - top);
            }

            public int getMaxScrollHeight() {
                return this.getMaxScrollDist();
            }
        };
        private final List<CollapsibleEntryWidget>[] columns;
        private final List<CollapsibleEntryWidget> children = new ArrayList<CollapsibleEntryWidget>();

        public ListWidget(int width, int height, int top) {
            this.width = width;
            this.height = height;
            this.top = top;
            this.columns = new List[Math.max(1, (width - 12 - 6) / 136)];
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i] = new ArrayList<CollapsibleEntryWidget>();
            }
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            this.scroller.updatePosition(delta);
            try (CloseableScissors scissors = ListWidget.scissor(graphics, new Rectangle(0, this.top, this.width - 6, this.height - this.top));){
                int entryWidth = (this.width - 12 - 6 - 6) / this.columns.length - 6;
                for (int i = 0; i < this.columns.length; ++i) {
                    int x = 12 + i * (entryWidth + 6);
                    int y = this.top + 6 - this.scroller.scrollAmountInt();
                    for (CollapsibleEntryWidget widget : this.columns[i]) {
                        widget.setPosition(x, y);
                        widget.setWidth(entryWidth);
                        widget.method_25394(graphics, mouseX, mouseY, delta);
                        y += widget.getHeight() + 6;
                    }
                }
            }
            this.scroller.renderScrollBar(graphics);
            ScreenOverlayImpl.getInstance().lateRender(graphics, mouseX, mouseY, delta);
        }

        private int getMaxScrollDist() {
            return Arrays.stream(this.columns).mapToInt(ListWidget::getHeightOf).max().orElse(0) + 12;
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
            for (CollapsibleEntryWidget widget : this.children) {
                if (!widget.method_25401(mouseX, mouseY, amountX, amountY)) continue;
                return true;
            }
            if (mouseY > (double)this.top && amountY != 0.0) {
                this.scroller.offset(ClothConfigInitializer.getScrollStep() * -amountY, true);
                return true;
            }
            return false;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return this.scroller.updateDraggingState(mouseX, mouseY, button) || super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return this.scroller.mouseDragged(mouseX, mouseY, button, deltaX, deltaY) || super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        public void clear() {
            this.children.clear();
            for (List<CollapsibleEntryWidget> column : this.columns) {
                column.clear();
            }
        }

        public void add(CollapsibleEntryWidget widget) {
            Arrays.stream(this.columns).min(Comparator.comparingInt(ListWidget::getHeightOf)).ifPresent(widgets -> widgets.add(widget));
            this.children.add(widget);
        }

        private static int getHeightOf(List<CollapsibleEntryWidget> widgets) {
            int height = 0;
            for (CollapsibleEntryWidget w : widgets) {
                height += w.getHeight() + 6;
            }
            return Math.max(0, height - 6);
        }
    }
}

