/*
 * Decompiled with CFR 0.152.
 */
package io.github.satxm.mcwifipnp;

import com.dosse.upnp.UPnP;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import io.github.satxm.mcwifipnp.MCWiFiPnP;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1934;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_3093;
import net.minecraft.class_310;
import net.minecraft.class_3321;
import net.minecraft.class_3324;
import net.minecraft.class_3327;
import net.minecraft.class_3330;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MCWiFiPnPUnit {
    private static final Map<MinecraftServer, Config> configMap = Collections.synchronizedMap(new WeakHashMap());
    private static final Gson gson = new GsonBuilder().create();
    private static final Logger LOGGER = LogManager.getLogger(MCWiFiPnP.class);

    public static Config getConfig(MinecraftServer server) {
        return Objects.requireNonNull(configMap.get(server), "no config for server???");
    }

    public static void OpenToLan() {
        class_310 client = class_310.method_1551();
        class_1132 server = client.method_1576();
        class_3324 playerList = server.method_3760();
        Config cfg = MCWiFiPnPUnit.getConfig((MinecraftServer)server);
        server.method_3834(cfg.motd);
        class_5250 component = server.method_3763(class_1934.method_8385((String)cfg.GameMode), cfg.AllowCommands, cfg.port) ? class_3093.method_46869((int)cfg.port) : class_2561.method_43471((String)"commands.publish.failed");
        client.field_1705.method_1743().method_1812((class_2561)component);
        MCWiFiPnP.setMaxPlayers(server, cfg.maxPlayers);
        server.method_3864(cfg.OnlineMode);
        server.method_3815(cfg.PvP);
        server.method_3731(cfg.Whitelist);
        playerList.method_14557(cfg.Whitelist);
        playerList.method_14603().method_14633((class_3330)new class_3327(server.method_43824(), 4, playerList.method_14609(server.method_43824())));
        playerList.method_14607(cfg.AllPlayersCheats);
        new Thread(() -> {
            MCWiFiPnPUnit.UseUPnP(cfg, client);
            MCWiFiPnPUnit.CopyToClipboard(cfg, client);
        }, "MCWiFiPnP").start();
    }

    public static void UseUPnP(Config cfg, class_310 client) {
        if (cfg.UseUPnP) {
            if (UPnP.isUPnPAvailable()) {
                if (UPnP.isMappedTCP(cfg.port)) {
                    client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.failed.mapped", (Object[])new Object[]{cfg.port}));
                } else if (UPnP.openPortTCP(cfg.port, cfg.motd)) {
                    client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.success", (Object[])new Object[]{cfg.port}));
                    LOGGER.info("Started forwarded port " + cfg.port + ".");
                } else {
                    client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.failed", (Object[])new Object[]{cfg.port}));
                }
            } else {
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.failed.disabled", (Object[])new Object[]{cfg.port}));
            }
        }
    }

    public static void CopyToClipboard(Config cfg, class_310 client) {
        if (cfg.CopyToClipboard) {
            ArrayList<class_2561> IPComponentList = new ArrayList<class_2561>();
            ArrayList<String> IPList = new ArrayList<String>();
            for (int i = 0; i < MCWiFiPnPUnit.IPAddressList().size(); ++i) {
                Map<String, String> NewMap = MCWiFiPnPUnit.IPAddressList().get(i);
                if (NewMap.get("Type") == "IPv4") {
                    IPComponentList.add(MCWiFiPnPUnit.IPComponent(class_2561.method_43471((String)NewMap.get("Local")).getString() + " " + NewMap.get("Type"), NewMap.get("IP") + ":" + cfg.port));
                } else {
                    IPComponentList.add(MCWiFiPnPUnit.IPComponent(class_2561.method_43471((String)NewMap.get("Local")).getString() + " " + NewMap.get("Type"), "[" + NewMap.get("IP") + "]:" + cfg.port));
                }
                IPList.add(NewMap.get("IP"));
            }
            if (!MCWiFiPnPUnit.GetGlobalIPv4().isEmpty() && !IPList.contains(MCWiFiPnPUnit.GetGlobalIPv4().get("IP"))) {
                IPComponentList.add(MCWiFiPnPUnit.IPComponent(class_2561.method_43471((String)MCWiFiPnPUnit.GetGlobalIPv4().get("Local")).getString() + " " + MCWiFiPnPUnit.GetGlobalIPv4().get("Type"), MCWiFiPnPUnit.GetGlobalIPv4().get("IP") + ":" + cfg.port));
                IPList.add(MCWiFiPnPUnit.GetGlobalIPv4().get("IP"));
            }
            if (!MCWiFiPnPUnit.GetGlobalIPv6().isEmpty() && !IPList.contains(MCWiFiPnPUnit.GetGlobalIPv6().get("IP"))) {
                IPComponentList.add(MCWiFiPnPUnit.IPComponent(class_2561.method_43471((String)MCWiFiPnPUnit.GetGlobalIPv6().get("Local")).getString() + " " + MCWiFiPnPUnit.GetGlobalIPv6().get("Type"), "[" + MCWiFiPnPUnit.GetGlobalIPv6().get("IP") + "]:" + cfg.port));
                IPList.add(MCWiFiPnPUnit.GetGlobalIPv4().get("IP"));
            }
            if (cfg.UseUPnP && UPnP.getExternalIP() != null && !IPList.contains(MCWiFiPnPUnit.GetGlobalIPv6().get("IP"))) {
                IPComponentList.add(MCWiFiPnPUnit.IPComponent("UPnP IPv4", UPnP.getExternalIP() + ":" + cfg.port));
                IPList.add(UPnP.getExternalIP());
            }
            if (IPList.isEmpty()) {
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"mcwifipnp.upnp.cantgetip"));
            } else {
                class_5250 component = null;
                for (int i = 0; i < IPComponentList.size(); ++i) {
                    if (component == null) {
                        component = ((class_2561)IPComponentList.get(i)).method_27661();
                        continue;
                    }
                    component.method_10852((class_2561)IPComponentList.get(i));
                }
                client.field_1705.method_1743().method_1812((class_2561)class_2561.method_43469((String)"mcwifipnp.upnp.clipboard", (Object[])new Object[]{component}));
            }
        }
    }

    public static void ReadingConfig(MinecraftServer server) {
        Config cfg;
        Path location = server.method_27050(class_5218.field_24188).resolve("mcwifipnp.json");
        try {
            cfg = (Config)gson.fromJson(new String(Files.readAllBytes(location), "utf-8"), Config.class);
            cfg.location = location;
        }
        catch (JsonParseException | IOException e) {
            try {
                Files.deleteIfExists(location);
            }
            catch (IOException ie) {
                LOGGER.warn("Unable to read config file!", (Throwable)ie);
            }
            cfg = new Config();
            cfg.location = location;
            cfg.needsDefaults = true;
        }
        configMap.put(server, cfg);
    }

    public static void CloseUPnPPort(MinecraftServer server) {
        Config cfg = configMap.get(server);
        if (server.method_3860() && cfg.UseUPnP) {
            UPnP.closePortTCP(cfg.port);
            LOGGER.info("Stopped forwarded port " + cfg.port + ".");
        }
    }

    static void saveConfig(Config cfg) {
        if (!cfg.needsDefaults) {
            try {
                Files.write(cfg.location, MCWiFiPnPUnit.toPrettyFormat(cfg).getBytes("utf-8"), StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to write config file!", (Throwable)e);
            }
        }
    }

    private static String toPrettyFormat(Object src) {
        String json = gson.toJson(src);
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return gson.toJson((JsonElement)jsonObject);
    }

    private static class_2561 IPComponent(String Type2, String IP) {
        return class_2564.method_10885((class_2561)class_2561.method_43470((String)Type2).method_27694(style -> style.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_21462, IP)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click").method_27693("\n").method_27693(IP))).method_10975(IP)));
    }

    public static Map<String, String> GetGlobalIPv4() {
        String ipv4 = null;
        try {
            String str;
            URL url = new URL("https://api-ipv4.ip.sb/ip");
            URLConnection URLconnection = url.openConnection();
            InputStreamReader isr = new InputStreamReader(URLconnection.getInputStream());
            BufferedReader bufr = new BufferedReader(isr);
            while ((str = bufr.readLine()) != null) {
                ipv4 = str;
            }
            bufr.close();
        }
        catch (Exception url) {
            // empty catch block
        }
        HashMap<String, String> Gl4Map = new HashMap<String, String>();
        if (ipv4 != null) {
            Gl4Map.put("Type", "IPv4");
            Gl4Map.put("Local", "mcwifipnp.gui.Global");
            Gl4Map.put("IP", ipv4);
        }
        return Gl4Map;
    }

    public static Map<String, String> GetGlobalIPv6() {
        String ipv6 = null;
        try {
            String str;
            URL url = new URL("https://api-ipv6.ip.sb/ip");
            URLConnection URLconnection = url.openConnection();
            InputStreamReader isr = new InputStreamReader(URLconnection.getInputStream());
            BufferedReader bufr = new BufferedReader(isr);
            while ((str = bufr.readLine()) != null) {
                ipv6 = str;
            }
            bufr.close();
        }
        catch (Exception url) {
            // empty catch block
        }
        HashMap<String, String> Gl6Map = new HashMap<String, String>();
        if (ipv6 != null) {
            Gl6Map.put("Type", "IPv6");
            Gl6Map.put("Local", "mcwifipnp.gui.Global");
            Gl6Map.put("IP", ipv6);
        }
        return Gl6Map;
    }

    public static ArrayList<Map<String, String>> IPAddressList() {
        ArrayList<Map<String, String>> out = new ArrayList<Map<String, String>>();
        try {
            Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
            while (ifaces.hasMoreElements()) {
                try {
                    Enumeration<InetAddress> addrs;
                    NetworkInterface iface = ifaces.nextElement();
                    if (!iface.isUp() || iface.isLoopback() || iface.isVirtual() || iface.isPointToPoint() || iface.getDisplayName().contains("Virtual") || iface.getDisplayName().contains("VMware") || iface.getDisplayName().contains("VirtualBox") || iface.getDisplayName().contains("Bluetooth") || iface.getDisplayName().contains("Hyper-V") || (addrs = iface.getInetAddresses()) == null) continue;
                    while (addrs.hasMoreElements()) {
                        HashMap<String, String> NetMap = new HashMap<String, String>();
                        InetAddress addr = addrs.nextElement();
                        if (addr instanceof Inet4Address) {
                            NetMap.put("Type", "IPv4");
                        }
                        if (addr instanceof Inet6Address) {
                            NetMap.put("Type", "IPv6");
                        }
                        if (addr.isLinkLocalAddress()) continue;
                        if (addr.isSiteLocalAddress()) {
                            NetMap.put("Local", "mcwifipnp.gui.Local");
                        } else {
                            NetMap.put("Local", "mcwifipnp.gui.Global");
                        }
                        NetMap.put("IP", addr.getHostAddress());
                        out.add(NetMap);
                    }
                }
                catch (Throwable throwable) {
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    protected static boolean convertOldUsers(MinecraftServer server) {
        int i;
        boolean bl = false;
        for (i = 0; !bl && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the user banlist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl = class_3321.method_14547((MinecraftServer)server);
        }
        boolean bl2 = false;
        for (i = 0; !bl2 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the ip banlist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl2 = class_3321.method_14545((MinecraftServer)server);
        }
        boolean bl3 = false;
        for (i = 0; !bl3 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the op list, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl3 = class_3321.method_14539((MinecraftServer)server);
        }
        boolean bl4 = false;
        for (i = 0; !bl4 && i <= 2; ++i) {
            if (i > 0) {
                LOGGER.warn("Encountered a problem while converting the whitelist, retrying in a few seconds");
                MCWiFiPnPUnit.waitForRetry();
            }
            bl4 = class_3321.method_14533((MinecraftServer)server);
        }
        return bl || bl2 || bl3 || bl4;
    }

    private static void waitForRetry() {
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public static class Config {
        public int port = 25565;
        public int maxPlayers = 8;
        public String GameMode = "survival";
        public String motd = class_2561.method_43471((String)"lanServer.title").getString();
        public boolean AllPlayersCheats = false;
        public boolean Whitelist = false;
        public boolean UseUPnP = true;
        public boolean AllowCommands = false;
        public boolean OnlineMode = true;
        public boolean PvP = true;
        public boolean CopyToClipboard = true;
        public transient Path location;
        public transient boolean needsDefaults = false;
    }
}

