/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigListWidget
extends class_4265<Entry> {
    private final ConfigScreen owner;
    @Nullable
    private final Runnable diskWriter;
    private int topOffset;
    private int bottomOffset;
    public boolean enableSearchBox = true;
    @Nullable
    private class_342 searchBox;
    @Nullable
    public String filter = null;
    public String @Nullable [] splitFilter = null;

    public ConfigListWidget(ConfigScreen owner, class_310 client, int width, int height, int top, int bottom, int itemHeight, @Nullable Runnable diskWriter) {
        super(client, width, height, top, itemHeight - 4);
        this.owner = owner;
        this.diskWriter = diskWriter;
        this.resize(top, bottom);
    }

    public ConfigListWidget(ConfigScreen owner, class_310 client, int width, int height, int top, int bottom, int itemHeight) {
        this(owner, client, width, height, top, bottom, itemHeight, null);
    }

    public int method_25322() {
        return Math.min(this.field_22758 - 20, 450);
    }

    protected int method_25329() {
        return this.field_22740.method_22683().method_4486() - 5;
    }

    public void tick() {
        this.method_25396().forEach(Entry::tick);
    }

    public boolean save(boolean ignoreErrors) {
        List<ConfigValue> values = this.method_25396().stream().filter(e -> e instanceof ConfigValue).map(e -> (ConfigValue)((Object)e)).toList();
        if (values.stream().allMatch(ConfigValue::isValueValid)) {
            values.forEach(ConfigValue::save);
            if (this.diskWriter != null) {
                this.diskWriter.run();
            }
            return true;
        }
        if (!ignoreErrors) {
            this.field_22740.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47587, (class_2561)class_2561.method_43471((String)"config.waila.invalid_input.title"), (class_2561)class_2561.method_43471((String)"config.waila.invalid_input.desc")));
        }
        return ignoreErrors;
    }

    public class_342 getSearchBox() {
        Preconditions.checkState((boolean)this.enableSearchBox);
        return Objects.requireNonNull(this.searchBox);
    }

    public void init() {
        List<Entry> dirtyChildren = List.copyOf(this.method_25396());
        for (Entry child : dirtyChildren) {
            child.clear(this);
        }
        List<Entry> rootChildren = List.copyOf(this.method_25396());
        int index = 0;
        for (Entry child : rootChildren) {
            index += child.init(this, index);
        }
        for (Entry child : this.method_25396()) {
            child.method_25395(null);
        }
        if (this.enableSearchBox && this.searchBox == null) {
            this.searchBox = new class_342(this.field_22740.field_1772, 0, 0, 160, 18, (class_2561)class_2561.method_43473());
            this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"config.waila.search_prompt"));
            this.searchBox.method_1863(filter -> {
                boolean isBlank = filter.isBlank();
                if (isBlank && this.filter == null || filter.equals(this.filter)) {
                    return;
                }
                this.method_25396().clear();
                if (isBlank) {
                    this.filter = null;
                    this.splitFilter = null;
                    this.method_25396().addAll(rootChildren);
                } else {
                    this.filter = filter;
                    this.splitFilter = filter.split("\\s");
                    this.method_25396().addAll(rootChildren.stream().filter(it -> it.match(this.splitFilter)).toList());
                }
                this.init();
            });
        }
        this.resize(this.topOffset, this.owner.field_22790 + this.bottomOffset);
        this.method_25307(this.method_25341());
    }

    public void add(Entry entry) {
        this.add(this.method_25396().size(), entry);
    }

    public void add(int index, Entry entry) {
        this.method_25396().add(index, entry);
    }

    public ConfigListWidget with(Entry entry) {
        return this.with(this.method_25396().size(), entry);
    }

    public ConfigListWidget with(int index, Entry entry) {
        this.add(index, entry);
        return this;
    }

    public void resize(int top, int bottom) {
        this.topOffset = top;
        this.bottomOffset = bottom - this.owner.field_22790;
        this.method_55445(this.owner.field_22789, this.owner.field_22790 - (this.topOffset - this.bottomOffset));
        if (this.searchBox != null) {
            this.searchBox.method_48229(this.method_25342() + this.method_25322() - 160, (top - 18) / 2);
        }
    }

    public static abstract class Entry
    extends class_4265.class_4266<Entry> {
        protected final class_310 client = class_310.method_1551();
        @Nullable
        protected List<? extends class_364> children;
        @Nullable
        protected List<? extends class_6379> narratables;
        protected ConfigListWidget list;
        protected int index;
        @Nullable
        public CategoryEntry category;
        public int categoryDepth;

        public void tick() {
        }

        public final int init(ConfigListWidget list, int index) {
            Preconditions.checkState((list.method_25396().get(index) == this ? 1 : 0) != 0);
            this.list = list;
            this.index = index;
            return this.init();
        }

        public int init() {
            return 1;
        }

        public void clear(ConfigListWidget list) {
        }

        protected void gatherChildren(ImmutableList.Builder<class_364> children) {
        }

        protected void gatherNarratables(ImmutableList.Builder<class_6379> narratables) {
        }

        protected abstract void buildSearchKey(StringBuilder var1);

        public final boolean match(String[] filter) {
            StringBuilder sb = new StringBuilder();
            this.buildSearchKey(sb);
            for (String s : filter) {
                if (!StringUtils.containsIgnoreCase((CharSequence)sb.toString(), (CharSequence)s)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            if (this.children == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherChildren((ImmutableList.Builder<class_364>)builder);
                this.children = builder.build();
            }
            return this.children;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            if (this.narratables == null) {
                ImmutableList.Builder builder = ImmutableList.builder();
                this.gatherNarratables((ImmutableList.Builder<class_6379>)builder);
                this.narratables = builder.build();
            }
            return this.narratables;
        }

        public final void method_25343(@NotNull class_332 ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
            if (this.category != null) {
                for (int i = 0; i < this.categoryDepth; ++i) {
                    int lineX1 = rowLeft + 5 + i * 16;
                    int lineX2 = lineX1 + 2;
                    int lineY1 = rowTop - height / 2 - 4;
                    int lineY2 = lineY1 + height + 4;
                    if (i == this.categoryDepth - 1 && index - this.category.index == 1) {
                        lineY1 += 8;
                    }
                    ctx.method_25294(lineX1, lineY1, lineX2, lineY2, 0x22FAFAFA);
                }
                int offset = this.categoryDepth * 16;
                rowLeft += offset;
                width -= offset;
            }
            this.drawEntry(ctx, index, rowTop, rowLeft, width, height, mouseX, mouseY, hovered, deltaTime);
        }

        protected abstract void drawEntry(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);
    }
}

