/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2473;
import net.minecraft.class_2513;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_7115;
import org.jetbrains.annotations.Nullable;

public enum PlantProvider implements IBlockComponentProvider
{
    INSTANCE;


    private static void addMaturityTooltip(ITooltip tooltip, float growthValue) {
        if ((growthValue *= 100.0f) < 100.0f) {
            tooltip.addLine(new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.crop_growth"), (class_2561)class_2561.method_43470((String)String.format("%.0f%%", Float.valueOf(growthValue)))));
        } else {
            tooltip.addLine(new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.crop_growth"), (class_2561)class_2561.method_43471((String)"tooltip.waila.crop_mature")));
        }
    }

    private static void addGrowableTooltip(ITooltip tooltip, String translationKey, boolean growable) {
        tooltip.addLine(new PairComponent((class_2561)class_2561.method_43471((String)translationKey), (class_2561)(growable ? class_2561.method_43471((String)"tooltip.waila.true") : class_2561.method_43471((String)"tooltip.waila.false"))));
    }

    private static void addCropGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        int lightLevel = accessor.getWorld().method_22335(accessor.getPosition(), 0);
        PlantProvider.addGrowableTooltip(tooltip, "tooltip.waila.crop_growable", lightLevel >= 9);
    }

    private static void addTreeGrowableTooltip(ITooltip tooltip, IBlockAccessor accessor) {
        boolean growable;
        int lightLevel = accessor.getWorld().method_22335(accessor.getPosition(), 0);
        boolean bl = growable = lightLevel >= 9;
        if (accessor.getBlock() instanceof class_7115 && ((Boolean)accessor.getBlockState().method_11654((class_2769)class_7115.field_37591)).booleanValue()) {
            growable = false;
        }
        PlantProvider.addGrowableTooltip(tooltip, "tooltip.waila.tree_growable", growable);
    }

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        if (accessor.getBlock() == class_2246.field_10293) {
            return new ItemComponent((class_1935)class_1802.field_8861);
        }
        if (accessor.getBlock() == class_2246.field_10341) {
            return new ItemComponent((class_1935)class_1802.field_8186);
        }
        return null;
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PLANT_CROP_PROGRESS)) {
            class_2248 class_22482 = accessor.getBlock();
            if (class_22482 instanceof class_2302) {
                class_2302 crop = (class_2302)class_22482;
                PlantProvider.addMaturityTooltip(tooltip, (float)crop.method_9829(accessor.getBlockState()) / (float)crop.method_9827());
            } else if (accessor.getBlock() == class_2246.field_46287 || accessor.getBlock() == class_2246.field_46286) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().method_11654((class_2769)class_2741.field_12550)).intValue() / 7.0f);
            } else if (accessor.getBlock() == class_2246.field_10302) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().method_11654((class_2769)class_2741.field_12556)).intValue() / 2.0f);
            } else if (accessor.getBlock() == class_2246.field_16999) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().method_11654((class_2769)class_2741.field_12497)).intValue() / 3.0f);
            } else if (accessor.getBlock() == class_2246.field_9974) {
                PlantProvider.addMaturityTooltip(tooltip, (float)((Integer)accessor.getBlockState().method_11654((class_2769)class_2741.field_12497)).intValue() / 3.0f);
            }
        }
        if (config.getBoolean(Options.PLANT_CROP_GROWABLE) && (accessor.getBlock() instanceof class_2302 || accessor.getBlock() instanceof class_2513) && IModInfo.get(accessor.getBlock()).getId().equals("minecraft")) {
            PlantProvider.addCropGrowableTooltip(tooltip, accessor);
        }
        if (config.getBoolean(Options.PLANT_TREE_GROWABLE) && accessor.getBlock() instanceof class_2473 && IModInfo.get(accessor.getBlock()).getId().equals("minecraft")) {
            PlantProvider.addTreeGrowableTooltip(tooltip, accessor);
        }
    }
}

