/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.manager;

import dev.tr7zw.itemswapper.ItemSwapperBase;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.client.ContainerProvider;
import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemGroup;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.util.ColorUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;

public class ItemGroupManager {
    private final ConfigManager configManager = ConfigManager.getInstance();
    private Map<class_2960, ItemGroup> groupMapping = new HashMap<class_2960, ItemGroup>();
    private Map<class_1792, List<ItemGroup>> paletteMapping = new HashMap<class_1792, List<ItemGroup>>();
    private Map<class_2960, ItemList> listKeyMapping = new HashMap<class_2960, ItemList>();
    private Map<class_1792, ItemList> listMapping = new HashMap<class_1792, ItemList>();
    private Map<class_1792, ItemGroup> lastPicked = new HashMap<class_1792, ItemGroup>();
    private static final NoPage NO_PAGE = new NoPage();

    public void reset() {
        this.listKeyMapping.clear();
        this.listMapping.clear();
        this.groupMapping.clear();
        this.paletteMapping.clear();
    }

    public void registerItemGroup(ItemGroup group) {
        if (group.getId() == null) {
            ItemSwapperBase.LOGGER.warn("Tried to register an ItemGroup without any id!");
            return;
        }
        this.groupMapping.put(group.getId(), group);
        for (class_1792 item : group.getOpenOnlyItems()) {
            this.addOpener(group, item);
        }
        if (group.autoLinkDisabled()) {
            return;
        }
        for (ItemEntry item : group.getItems()) {
            if (group.getIgnoreItems().contains(item.getItem())) continue;
            this.addOpener(group, item.getItem());
        }
    }

    private void addOpener(ItemGroup group, class_1792 item) {
        List list = this.paletteMapping.computeIfAbsent(item, k -> new ArrayList());
        if (list.contains(group)) {
            return;
        }
        list.add(group);
        list.sort((a, b) -> Integer.compare(a.getPriority(), b.getPriority()));
    }

    public Page getNextPage(ItemGroup current, ItemEntry clicked, int slot) {
        ItemGroup group;
        ContainerProvider provider;
        ItemGroup group2;
        if (clicked.getLink() != null) {
            group2 = this.groupMapping.get(clicked.getLink());
            if (group2 != null) {
                return new ItemGroupPage(group2);
            }
            ItemList list = this.listKeyMapping.get(clicked.getLink());
            if (list != null) {
                return new ListPage(list);
            }
        }
        if (current != null && current.getForcedLink() != null && (group2 = this.groupMapping.get(current.getForcedLink())) != null) {
            return new ItemGroupPage(group2);
        }
        if (current == null && slot != -1 && !ConfigManager.getInstance().getConfig().disableShulkers && (provider = ItemSwapperSharedMod.instance.getClientProviderManager().getContainerProvider(clicked.getItem())) != null) {
            return new ContainerPage(slot);
        }
        List<ItemGroup> list = this.paletteMapping.get(clicked.getItem());
        if (list != null && !list.isEmpty()) {
            int cur = 0;
            if (current != null && (cur = list.indexOf(current) + 1) == 0) {
                return new ItemGroupPage(list.get(0));
            }
            if (cur >= list.size()) {
                cur = 0;
            }
            if (current == null || list.get(cur) != current) {
                return new ItemGroupPage(list.get(cur));
            }
        }
        if (this.listMapping.containsKey(clicked.getItem())) {
            return new ListPage(this.listMapping.get(clicked.getItem()));
        }
        if (current != null && current.getFallbackLink() != null && (group = this.groupMapping.get(current.getFallbackLink())) != null) {
            return new ItemGroupPage(group);
        }
        return NO_PAGE;
    }

    public void setLastPickedItem(class_1792 item, ItemGroup group) {
        this.lastPicked.put(item, group);
    }

    public ItemGroup getLastPickedItemGroup(class_1792 item) {
        return this.lastPicked.get(item);
    }

    public ItemGroup getItemPage(class_1792 item) {
        List<ItemGroup> list = this.paletteMapping.get(item);
        if (list == null) {
            return null;
        }
        return list.get(0);
    }

    public void registerListCollection(ItemList items) {
        if (!items.isDisableAutoLink()) {
            for (class_1792 i : items.getItems()) {
                if (i == class_1802.field_8162 || items.getIgnoreItems().contains(i)) continue;
                this.listMapping.put(i, items);
            }
            for (class_1792 i : items.getOpenOnlyItems()) {
                this.listMapping.put(i, items);
            }
        }
        this.listKeyMapping.put(items.getId(), items);
    }

    public ItemList getList(class_1792 item) {
        if (this.listMapping.containsKey(item)) {
            return this.listMapping.get(item);
        }
        return null;
    }

    public Page getPage(class_2960 location) {
        if (this.groupMapping.containsKey(location)) {
            return new ItemGroupPage(this.groupMapping.get(location));
        }
        if (this.listKeyMapping.containsKey(location)) {
            return new ListPage(this.listKeyMapping.get(location));
        }
        return NO_PAGE;
    }

    public boolean isResourcepackSelected() {
        return !this.paletteMapping.isEmpty() || !this.listMapping.isEmpty();
    }

    public record ItemGroupPage(ItemGroup group) implements Page
    {
    }

    public record ListPage(ItemList items) implements Page
    {
    }

    public record ContainerPage(int containerSlotId) implements Page
    {
    }

    public record NoPage() implements Page
    {
    }

    public record InventoryPage() implements Page
    {
    }

    public record TexturePage(ColorUtil.UnpackedColor[] color, ColorUtil.UnpackedColor sideBase) implements Page
    {
    }

    public static sealed interface Page
    permits NoPage, ItemGroupPage, ListPage, TexturePage, InventoryPage, ContainerPage {
    }
}

