/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.config.ConfigManager;
import dev.tr7zw.itemswapper.manager.ClientProviderManager;
import dev.tr7zw.itemswapper.manager.ItemGroupManager;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemList;
import dev.tr7zw.itemswapper.overlay.ItemSwapperUIAbstractInput;
import dev.tr7zw.itemswapper.overlay.RenderContext;
import dev.tr7zw.itemswapper.util.ComponentProvider;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.itemswapper.util.NMSHelper;
import dev.tr7zw.itemswapper.util.NetworkUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_757;

public class ItemListOverlay
extends ItemSwapperUIAbstractInput {
    private static final class_2960 SELECTION_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/selection.png");
    private static final class_2960 BOTTOM_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/list_bottom_slot.png");
    private static final class_2960 MIDDLE_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/list_middle_slot.png");
    private static final class_2960 TOP_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/list_top_slot.png");
    private static final class_2960 SINGLE_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/list_single_slot.png");
    private static final class_2960 MIDDLE_TOP_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/list_middle_continue_top_slot.png");
    private static final class_2960 MIDDLE_BOTTOM_LOCATION = NMSHelper.getResourceLocation("itemswapper", "textures/gui/list_middle_continue_bottom_slot.png");
    private static final double entrySize = 33.0;
    private static final int yOffset = 75;
    private static final int slotSize = 18;
    private final ItemSwapperClientAPI clientAPI = ItemSwapperClientAPI.getInstance();
    private final ClientProviderManager providerManager = ItemSwapperSharedMod.instance.getClientProviderManager();
    private ItemList itemSelection;
    private List<AvailableSlot> entries = new ArrayList<AvailableSlot>();
    private int selectedEntry = 0;
    private double selectY = 0.0;

    public ItemListOverlay(ItemList itemSelection) {
        super((class_2561)ComponentProvider.empty());
        this.field_22787 = class_310.method_1551();
        this.itemSelection = itemSelection;
        this.refreshList();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float f) {
        int start;
        RenderContext renderContext = new RenderContext(graphics);
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(class_757::method_34542);
        ArrayList<Runnable> itemRenderList = new ArrayList<Runnable>();
        ArrayList<Runnable> lateRenderList = new ArrayList<Runnable>();
        int limit = Math.max(5, (this.field_22787.method_22683().method_4502() - 75) / 18 / 2);
        int originX = this.field_22787.method_22683().method_4486() / 2 - 90;
        int originY = this.field_22787.method_22683().method_4502() - 75 + Math.max(0, this.selectedEntry - limit / 2) * 18;
        for (int i = start = Math.max(0, this.selectedEntry - limit / 2); i < this.entries.size() && i < start + limit; ++i) {
            boolean endTop = i == this.entries.size() - 1;
            boolean endBottom = i == 0;
            boolean midBottom = i == start;
            boolean midTop = i == start + limit - 1;
            class_2960 background = MIDDLE_LOCATION;
            if (endTop && endBottom) {
                background = SINGLE_LOCATION;
            } else if (endBottom) {
                background = BOTTOM_LOCATION;
            } else if (endTop) {
                background = TOP_LOCATION;
            } else if (midTop) {
                background = MIDDLE_TOP_LOCATION;
            } else if (midBottom) {
                background = MIDDLE_BOTTOM_LOCATION;
            }
            this.renderEntry(renderContext, background, i, originX, originY - 18 * i, itemRenderList, lateRenderList);
        }
        itemRenderList.forEach(Runnable::run);
        lateRenderList.forEach(Runnable::run);
    }

    @Override
    public void handleInput(double x, double y) {
        this.selectY -= y;
        this.selectY = class_3532.method_15350((double)this.selectY, (double)0.0, (double)((double)this.entries.size() * 33.0 - 1.0));
        this.refreshList();
    }

    @Override
    public void onScroll(double signum) {
        this.selectY += signum * 33.0;
        this.selectY = class_3532.method_15350((double)this.selectY, (double)0.0, (double)((double)this.entries.size() * 33.0 - 1.0));
        this.refreshList();
    }

    private void refreshList() {
        this.entries.clear();
        this.entries.add(new AvailableSlot(-1, this.field_22787.field_1724.method_31548().field_7545, this.field_22787.field_1724.method_31548().method_7391()));
        for (class_1792 item : this.itemSelection.getItems()) {
            List<AvailableSlot> ids = this.providerManager.findSlotsMatchingItem(item, false, ConfigManager.getInstance().getConfig().ignoreHotbar);
            for (AvailableSlot id : ids) {
                if (this.entries.contains(id)) continue;
                this.entries.add(id);
            }
        }
        this.selectY = class_3532.method_15350((double)this.selectY, (double)0.0, (double)((double)this.entries.size() * 33.0 - 1.0));
        this.selectedEntry = (int)(this.selectY / 33.0);
    }

    @Override
    public void onSecondaryClick() {
        ItemGroupManager.Page linkedPage;
        if (this.itemSelection.getLink() != null && (linkedPage = ItemSwapperSharedMod.instance.getItemGroupManager().getPage(this.itemSelection.getLink())) != null && linkedPage instanceof ItemGroupManager.ListPage) {
            ItemGroupManager.ListPage listPage = (ItemGroupManager.ListPage)linkedPage;
            this.itemSelection = listPage.items();
            this.selectY = 0.0;
            this.refreshList();
        }
    }

    @Override
    public boolean lockMouse() {
        return !ConfigManager.getInstance().getConfig().unlockListMouse;
    }

    @Override
    public boolean onPrimaryClick() {
        if (this.selectedEntry != 0) {
            AvailableSlot slot = this.entries.get(this.selectedEntry);
            ItemSwapperClientAPI.OnSwap event = this.clientAPI.prepareItemSwapEvent.callEvent(new ItemSwapperClientAPI.OnSwap(slot, new AtomicBoolean()));
            if (event.canceled().get()) {
                return true;
            }
            if (slot.inventory() == -1) {
                int hudSlot = ItemUtil.inventorySlotToHudSlot(slot.slot());
                this.field_22787.field_1761.method_2906(this.field_22787.field_1724.field_7498.field_7763, hudSlot, this.field_22787.field_1724.method_31548().field_7545, class_1713.field_7791, (class_1657)this.field_22787.field_1724);
            } else {
                NetworkUtil.swapItem(slot.inventory(), slot.slot());
            }
            this.clientAPI.itemSwapSentEvent.callEvent(new ItemSwapperClientAPI.SwapSent(slot));
        }
        return false;
    }

    private void renderEntry(RenderContext graphics, class_2960 background, int id, int x, int y, List<Runnable> itemRenderList, List<Runnable> lateRenderList) {
        graphics.blit(background, x, y, 0.0f, 0.0f, 24, 24, 24, 24);
        AvailableSlot slot = this.entries.get(id);
        if (this.selectedEntry == id) {
            lateRenderList.add(() -> {
                graphics.pose().method_22903();
                graphics.pose().method_46416(0.0f, 0.0f, 300.0f);
                graphics.blit(SELECTION_LOCATION, x, y, 0.0f, 0.0f, 24, 24, 24, 24);
                graphics.pose().method_22909();
            });
        }
        lateRenderList.add(() -> {
            graphics.pose().method_22903();
            graphics.pose().method_46416(0.0f, 0.0f, 2000.0f);
            this.renderSlot(graphics, x + 4, y + 4, (class_1657)this.field_22787.field_1724, slot.item(), 1);
            graphics.pose().method_22909();
            class_2561 name = ItemUtil.getDisplayname(slot.item());
            if (this.selectedEntry != id && name instanceof class_5250) {
                class_5250 mutName = (class_5250)name;
                mutName.method_27692(class_124.field_1080);
            }
            graphics.drawString(this.field_22787.field_1772, name, x + 27, y + 9, -1);
        });
    }

    private void renderSlot(RenderContext graphics, int x, int y, class_1657 arg, class_1799 arg2, int k) {
        if (!arg2.method_7960()) {
            graphics.renderItem(arg, arg2, x, y, k);
            RenderSystem.setShader(class_757::method_34540);
            graphics.renderItemDecorations(this.field_22787.field_1772, arg2, x, y);
        }
    }
}

