/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.manager.itemgroups.Icon;
import dev.tr7zw.itemswapper.manager.itemgroups.Shortcut;
import dev.tr7zw.itemswapper.overlay.RenderContext;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.ItemGridWidget;
import dev.tr7zw.itemswapper.overlay.logic.WidgetArea;
import dev.tr7zw.itemswapper.util.RenderHelper;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_5348;

public class ShortcutListWidget
extends ItemGridWidget {
    private final class_2960 parentId;
    private final List<Shortcut> list;

    public ShortcutListWidget(class_2960 parentId, List<Shortcut> list, int x, int y) {
        super(x, y);
        this.parentId = parentId;
        this.list = list.stream().filter(Shortcut::isVisible).toList();
        WidgetUtil.setupSlots(this.widgetArea, this.slots, 1, this.list.size(), false, null);
    }

    @Override
    public List<GuiSlot> getSlots() {
        return this.slots;
    }

    @Override
    public WidgetArea getWidgetArea() {
        return this.widgetArea;
    }

    @Override
    protected void renderSlot(RenderContext graphics, int x, int y, List<Runnable> itemRenderList, GuiSlot guiSlot, boolean overwriteAvailable) {
        Icon icon = this.list.get(guiSlot.id()).getIcon();
        if (icon instanceof Icon.ItemIcon) {
            Icon.ItemIcon item = (Icon.ItemIcon)icon;
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, item.item(), 1, RenderHelper.SlotEffect.NONE, 1));
        } else if (icon instanceof Icon.LinkIcon) {
            Icon.LinkIcon item = (Icon.LinkIcon)icon;
            boolean grayedOut = this.parentId != null && this.parentId.equals((Object)item.nextId());
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, item.item(), 1, grayedOut ? RenderHelper.SlotEffect.GRAY : RenderHelper.SlotEffect.NONE, 1));
        } else if (icon instanceof Icon.TextureIcon) {
            Icon.TextureIcon texture = (Icon.TextureIcon)icon;
            graphics.pose().method_46416(0.0f, 0.0f, 2000.0f);
            graphics.blit(texture.texture(), x - 1, y, 0.0f, 0.0f, 24, 24, 24, 24);
        }
    }

    @Override
    public void renderSelectedSlotName(GuiSlot selected, int yOffset, int maxWidth, boolean overwrideAvailable, RenderContext graphics) {
        Icon icon = this.list.get(selected.id()).getIcon();
        if (icon instanceof Icon.ItemIcon) {
            Icon.ItemIcon item = (Icon.ItemIcon)icon;
            RenderHelper.renderSelectedItemName(RenderHelper.getName(item), item.item(), false, yOffset, maxWidth, graphics);
        } else if (icon instanceof Icon.LinkIcon) {
            Icon.LinkIcon link = (Icon.LinkIcon)icon;
            RenderHelper.renderSelectedItemName(RenderHelper.getName(link), link.item(), false, yOffset, maxWidth, graphics);
        } else if (icon instanceof Icon.TextureIcon) {
            Icon.TextureIcon texture = (Icon.TextureIcon)icon;
            RenderHelper.renderSelectedEntryName(texture.name(), false, yOffset, maxWidth, graphics);
        }
    }

    @Override
    public void onSecondaryClick(SwitchItemOverlay overlay, GuiSlot slot, int xOffset, int yOffset) {
        Shortcut shortcut = this.list.get(slot.id());
        if (shortcut.acceptSecondaryClick()) {
            shortcut.invoke(overlay, Shortcut.ActionType.SECONDARY_CLICK, xOffset, yOffset);
        }
    }

    @Override
    public boolean onPrimaryClick(SwitchItemOverlay overlay, GuiSlot slot, int xOffset, int yOffset) {
        Shortcut shortcut = this.list.get(slot.id());
        if (shortcut.acceptPrimaryClick()) {
            return shortcut.invoke(overlay, Shortcut.ActionType.PRIMARY_CLICK, xOffset, yOffset);
        }
        return true;
    }

    @Override
    public void renderSelectedTooltip(SwitchItemOverlay overlay, RenderContext graphics, GuiSlot selected, double x, double y) {
        Shortcut shortcut = this.list.get(selected.id());
        if (shortcut.getHoverText() != null) {
            graphics.pose().method_22903();
            graphics.pose().method_46416(0.0f, 0.0f, 3000.0f);
            graphics.renderTooltip(this.minecraft.field_1772, this.minecraft.field_1772.method_1728((class_5348)shortcut.getHoverText(), 170), (int)x, (int)y);
            graphics.pose().method_22909();
        }
    }

    @Override
    public String getSelector(GuiSlot slot) {
        return this.list.get(slot.id()).getSelector();
    }
}

