/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.util;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ColorUtil {
    private static final float COLOR_NORMAL = (float)Math.sqrt(195075.0);

    public static double colorDistance(UnpackedColor c1, UnpackedColor c2) {
        if (c1.a == 0 && c2.a == 0) {
            return 0.0;
        }
        double deltaR = c2.r - c1.r;
        double deltaG = c2.g - c1.g;
        double deltaB = c2.b - c1.b;
        return Math.sqrt(deltaR * deltaR + deltaG * deltaG + deltaB * deltaB) / (double)COLOR_NORMAL;
    }

    public static UnpackedColor calculateAverageColor(UnpackedColor[] colors) {
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int totalAlpha = 0;
        for (UnpackedColor color : colors) {
            totalRed += color.r;
            totalGreen += color.g;
            totalBlue += color.b;
            totalAlpha += color.a;
        }
        return new UnpackedColor(totalAlpha / colors.length, totalRed / colors.length, totalGreen / colors.length, totalBlue / colors.length);
    }

    public static UnpackedColor calculateAverageColor(List<UnpackedColor> colors) {
        int totalRed = 0;
        int totalGreen = 0;
        int totalBlue = 0;
        int totalAlpha = 0;
        for (UnpackedColor color : colors) {
            totalRed += color.r;
            totalGreen += color.g;
            totalBlue += color.b;
            totalAlpha += color.a;
        }
        return new UnpackedColor(totalAlpha / colors.size(), totalRed / colors.size(), totalGreen / colors.size(), totalBlue / colors.size());
    }

    public static List<UnpackedColor> createTetradPalette(UnpackedColor color) {
        Color color4;
        Color color3;
        Color color2;
        Color color1;
        ArrayList<UnpackedColor> palette = new ArrayList<UnpackedColor>();
        float[] hsv = new float[3];
        Color.RGBtoHSB(color.r, color.g, color.b, hsv);
        float offset1 = hsv[0];
        if ((double)hsv[1] < 0.1 || (double)hsv[2] < 0.2) {
            offset1 = hsv[2];
        }
        float offset2 = (offset1 + 0.083333336f) % 1.0f;
        float offset3 = (offset1 + 0.5f) % 1.0f;
        float offset4 = (offset2 + 0.5f) % 1.0f;
        if ((double)hsv[1] < 0.1 || (double)hsv[2] < 0.2) {
            color1 = Color.getHSBColor(hsv[0], hsv[1], offset1);
            color2 = Color.getHSBColor(hsv[0], hsv[1], offset2);
            color3 = Color.getHSBColor(hsv[0], hsv[1], offset3);
            color4 = Color.getHSBColor(hsv[0], hsv[1], offset4);
        } else {
            color1 = Color.getHSBColor(offset1, hsv[1], hsv[2]);
            color2 = Color.getHSBColor(offset2, hsv[1], hsv[2]);
            color3 = Color.getHSBColor(offset3, hsv[1], hsv[2]);
            color4 = Color.getHSBColor(offset4, hsv[1], hsv[2]);
        }
        palette.add(new UnpackedColor(color1));
        palette.add(new UnpackedColor(color2));
        palette.add(new UnpackedColor(color3));
        palette.add(new UnpackedColor(color4));
        return palette;
    }

    public static UnpackedColor[] primaryColorDetection(int[] colors, float closenessThreshold) {
        if (colors == null || colors.length == 0) {
            return new UnpackedColor[0];
        }
        HashMap colorGroups = new HashMap();
        for (int mojangColor : colors) {
            UnpackedColor color = new UnpackedColor(mojangColor);
            boolean foundGroup = false;
            for (UnpackedColor groupColor : colorGroups.keySet()) {
                if (!(ColorUtil.colorDistance(color, groupColor) < (double)closenessThreshold)) continue;
                ((List)colorGroups.get(groupColor)).add(color);
                foundGroup = true;
                break;
            }
            if (foundGroup) continue;
            ArrayList<UnpackedColor> newGroup = new ArrayList<UnpackedColor>();
            newGroup.add(color);
            colorGroups.put(color, newGroup);
        }
        ArrayList blobs = new ArrayList(colorGroups.values());
        blobs.sort((a, b) -> Integer.compare(b.size(), a.size()));
        return new UnpackedColor[]{ColorUtil.calculateAverageColor((List)blobs.get(0))};
    }

    public static UnpackedColor[] blobDetection(int[] colors, float closenessThreshold) {
        if (colors == null || colors.length == 0) {
            return new UnpackedColor[0];
        }
        HashMap colorGroups = new HashMap();
        for (int mojangColor : colors) {
            UnpackedColor color = new UnpackedColor(mojangColor);
            boolean foundGroup = false;
            for (UnpackedColor groupColor : colorGroups.keySet()) {
                if (!(ColorUtil.colorDistance(color, groupColor) < (double)closenessThreshold)) continue;
                ((List)colorGroups.get(groupColor)).add(color);
                foundGroup = true;
                break;
            }
            if (foundGroup) continue;
            ArrayList<UnpackedColor> newGroup = new ArrayList<UnpackedColor>();
            newGroup.add(color);
            colorGroups.put(color, newGroup);
        }
        UnpackedColor[] result = new UnpackedColor[colorGroups.size()];
        int index = 0;
        for (List group : colorGroups.values()) {
            result[index] = ColorUtil.calculateAverageColor(group);
            ++index;
        }
        return result;
    }

    public static UnpackedColor[] calculateColorClumps(int[] colors, float closenessTreshold) {
        ArrayList<UnpackedColor> colorArrays = new ArrayList<UnpackedColor>();
        for (int color : colors) {
            UnpackedColor pixel = new UnpackedColor(color);
            boolean colorExists = false;
            for (int i = 0; i < colorArrays.size(); ++i) {
                UnpackedColor current = (UnpackedColor)colorArrays.get(i);
                if (!(ColorUtil.colorDistance(pixel, current) < (double)closenessTreshold)) continue;
                colorExists = true;
                current = new UnpackedColor(current.a + pixel.a >> 1, current.r + pixel.r >> 1, current.g + pixel.g >> 1, current.b + pixel.b >> 1);
                colorArrays.set(i, current);
                break;
            }
            if (colorExists) continue;
            colorArrays.add(new UnpackedColor(color));
        }
        return colorArrays.toArray(new UnpackedColor[0]);
    }

    public record UnpackedColor(int a, int r, int g, int b) {
        public UnpackedColor(int color) {
            this(color >>> 24, color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF);
        }

        public UnpackedColor(Color color) {
            this(color.getAlpha(), color.getRed(), color.getGreen(), color.getBlue());
        }

        public int toInt() {
            return this.a << 24 | this.r | this.g << 8 | this.b << 16;
        }
    }
}

