/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.config;

import io.github.sjouwer.pickblockpro.config.tools.Axe;
import io.github.sjouwer.pickblockpro.config.tools.Bow;
import io.github.sjouwer.pickblockpro.config.tools.Brush;
import io.github.sjouwer.pickblockpro.config.tools.Crossbow;
import io.github.sjouwer.pickblockpro.config.tools.FishingRod;
import io.github.sjouwer.pickblockpro.config.tools.Hoe;
import io.github.sjouwer.pickblockpro.config.tools.Mace;
import io.github.sjouwer.pickblockpro.config.tools.Pickaxe;
import io.github.sjouwer.pickblockpro.config.tools.Shears;
import io.github.sjouwer.pickblockpro.config.tools.Shovel;
import io.github.sjouwer.pickblockpro.config.tools.Sword;
import io.github.sjouwer.pickblockpro.config.tools.Trident;
import io.github.sjouwer.pickblockpro.picker.ToolPicker;
import io.github.sjouwer.pickblockpro.picker.WeaponPicker;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;

@Config(name="pickblockpro/config")
public class ModConfig
implements ConfigData {
    @ConfigEntry.Category(value="blockPickerSettings")
    @ConfigEntry.Gui.TransitiveObject
    private BlockPicker blockPicker = new BlockPicker();
    @ConfigEntry.Category(value="idPickerSettings")
    @ConfigEntry.Gui.TransitiveObject
    private IdPicker idPicker = new IdPicker();
    @ConfigEntry.Category(value="toolPickerSettings")
    @ConfigEntry.Gui.TransitiveObject
    private ToolPicker toolPicker = new ToolPicker();
    @ConfigEntry.Category(value="inventorySettings")
    @ConfigEntry.Gui.TransitiveObject
    private Inventory inventory = new Inventory();

    public double blockBlockPickRange(class_1657 player) {
        boolean isCreative = player.method_7337();
        if (!isCreative && this.blockPicker.useInteractionRange || isCreative && this.blockPicker.useCreativeInteractionRange) {
            return player.method_55754();
        }
        return isCreative ? this.blockPicker.creativeRange : this.blockPicker.range;
    }

    public double entityBlockPickRange(class_1657 player) {
        boolean isCreative = player.method_7337();
        if (!isCreative && this.blockPicker.useInteractionRange || isCreative && this.blockPicker.useCreativeInteractionRange) {
            return player.method_55755();
        }
        return isCreative ? this.blockPicker.creativeRange : this.blockPicker.range;
    }

    public boolean blockPickBlocks() {
        return this.blockPicker.pickBlocks;
    }

    public boolean blockPickEntities() {
        return this.blockPicker.pickEntities;
    }

    public boolean blockPickFluids() {
        return this.blockPicker.pickFluids;
    }

    public boolean blockPickLight() {
        return this.blockPicker.pickLight;
    }

    public boolean overrideLitematica() {
        return this.blockPicker.overrideLitematica;
    }

    public List<String> blockStateTagBlacklist() {
        return Arrays.asList(this.blockPicker.blockStateTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> blockEntityTagBlacklist() {
        return Arrays.asList(this.blockPicker.blockEntityTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> entityTagBlacklist() {
        return Arrays.asList(this.blockPicker.entityTagBlacklist.split("\\s*,\\s*"));
    }

    public double blockIdPickRange(class_1657 player) {
        if (this.idPicker.useInteractionRange) {
            return player.method_55754();
        }
        return this.idPicker.range;
    }

    public double entityIdPickRange(class_1657 player) {
        if (this.idPicker.useInteractionRange) {
            return player.method_55755();
        }
        return this.idPicker.range;
    }

    public boolean idPickBlocks() {
        return this.idPicker.pickBlocks;
    }

    public boolean idPickEntities() {
        return this.idPicker.pickEntities;
    }

    public boolean idPickFluids() {
        return this.idPicker.pickFluids;
    }

    public boolean addNamespace() {
        return this.idPicker.addNamespace;
    }

    public boolean addProperties() {
        return this.idPicker.addProperties;
    }

    public boolean copyToClipboard() {
        return this.idPicker.copyToClipboard;
    }

    public boolean tagPickerEnabled() {
        return this.idPicker.enableTagPicker;
    }

    public boolean prettyTagEnabled() {
        return this.idPicker.enablePrettyTags;
    }

    public boolean hotbarPickerEnabled() {
        return this.idPicker.enableHotbarPicker;
    }

    public boolean convertItemToBlock() {
        return this.idPicker.convertItemToBlock;
    }

    public List<String> blockStateTagIdBlacklist() {
        return Arrays.asList(this.idPicker.blockStateTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> blockEntityTagIdBlacklist() {
        return Arrays.asList(this.idPicker.blockEntityTagBlacklist.split("\\s*,\\s*"));
    }

    public List<String> entityTagIdBlacklist() {
        return Arrays.asList(this.idPicker.entityTagBlacklist.split("\\s*,\\s*"));
    }

    public double blockToolPickRange(class_1657 player) {
        if (this.toolPicker.useInteractionRange) {
            return player.method_55754();
        }
        return this.toolPicker.range;
    }

    public double entityToolPickRange(class_1657 player) {
        if (this.toolPicker.useInteractionRange) {
            return player.method_55755();
        }
        return this.toolPicker.range;
    }

    public int durabilityThreshold() {
        return this.toolPicker.durabilityThreshold;
    }

    public boolean toolPickFluids() {
        return this.toolPicker.pickFluids;
    }

    public boolean preferSilkTouch() {
        return this.toolPicker.tools.preferSilkTouch;
    }

    public boolean preferEfficiency() {
        return this.toolPicker.tools.preferEfficiency;
    }

    public boolean preferSwordForBamboo() {
        return this.toolPicker.tools.preferSwordForBamboo;
    }

    public boolean enchantTools() {
        return this.toolPicker.tools.enchantTools;
    }

    public boolean allowIncompatibleToolEnchantments() {
        return this.toolPicker.tools.allowIncompatibleEnchantments;
    }

    public boolean addToolsToOpUtilities() {
        return this.toolPicker.tools.addToOpUtilities;
    }

    public class_1799 getToolItemStack(ToolPicker.Tools tool) {
        return switch (tool) {
            default -> throw new MatchException(null, null);
            case ToolPicker.Tools.PICKAXE -> this.toolPicker.tools.pickaxe.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.AXE -> this.toolPicker.tools.axe.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.SHOVEL -> this.toolPicker.tools.shovel.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.HOE -> this.toolPicker.tools.hoe.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.SHEARS -> this.toolPicker.tools.shears.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.FISHING_ROD -> this.toolPicker.tools.fishingRod.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.BRUSH -> this.toolPicker.tools.brush.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.SWORD -> this.toolPicker.weapons.sword.getItemStack(this.enchantTools(), this.allowIncompatibleToolEnchantments());
            case ToolPicker.Tools.BUCKET -> class_1802.field_8550.method_7854();
        };
    }

    public List<class_1299<?>> getBowPreferenceList() {
        String[] idList = this.toolPicker.weapons.preferredForBow.split("\\s*,\\s*");
        return Arrays.stream(idList).map(class_1299::method_5898).flatMap(Optional::stream).toList();
    }

    public List<class_1299<?>> getTridentPreferenceList() {
        String[] idList = this.toolPicker.weapons.preferredForTrident.split("\\s*,\\s*");
        return Arrays.stream(idList).map(class_1299::method_5898).flatMap(Optional::stream).toList();
    }

    public boolean enchantWeapons() {
        return this.toolPicker.weapons.enchantWeapons;
    }

    public boolean allowIncompatibleWeaponEnchantments() {
        return this.toolPicker.weapons.allowIncompatibleEnchantments;
    }

    public boolean addWeaponsToOpUtilities() {
        return this.toolPicker.weapons.addToOpUtilities;
    }

    public class_1799 getWeaponItemStack(WeaponPicker.Weapons weapon) {
        return this.getWeaponItemStack(weapon, null);
    }

    public class_1799 getWeaponItemStack(WeaponPicker.Weapons weapon, class_1299<?> entity) {
        return switch (weapon) {
            default -> throw new MatchException(null, null);
            case WeaponPicker.Weapons.SWORD -> this.toolPicker.weapons.sword.getItemStack(this.enchantWeapons(), this.allowIncompatibleWeaponEnchantments(), entity);
            case WeaponPicker.Weapons.AXE -> this.toolPicker.tools.axe.getItemStack(this.enchantWeapons(), this.allowIncompatibleWeaponEnchantments(), entity);
            case WeaponPicker.Weapons.BOW -> this.toolPicker.weapons.bow.getItemStack(this.enchantWeapons(), this.allowIncompatibleWeaponEnchantments(), entity);
            case WeaponPicker.Weapons.CROSSBOW -> this.toolPicker.weapons.crossbow.getItemStack(this.enchantWeapons(), this.allowIncompatibleWeaponEnchantments(), entity);
            case WeaponPicker.Weapons.TRIDENT -> this.toolPicker.weapons.trident.getItemStack(this.enchantWeapons(), this.allowIncompatibleWeaponEnchantments(), entity);
            case WeaponPicker.Weapons.MACE -> this.toolPicker.weapons.mace.getItemStack(this.enchantWeapons(), this.allowIncompatibleWeaponEnchantments(), entity);
        };
    }

    public boolean searchContainers() {
        return this.inventory.searchThroughContainers;
    }

    public boolean stayInSameSlot() {
        return this.inventory.stayInSameSlot;
    }

    public boolean isSlotLocked(int slot) {
        return switch (slot) {
            case 0 -> this.inventory.lockedSlots.slot1;
            case 1 -> this.inventory.lockedSlots.slot2;
            case 2 -> this.inventory.lockedSlots.slot3;
            case 3 -> this.inventory.lockedSlots.slot4;
            case 4 -> this.inventory.lockedSlots.slot5;
            case 5 -> this.inventory.lockedSlots.slot6;
            case 6 -> this.inventory.lockedSlots.slot7;
            case 7 -> this.inventory.lockedSlots.slot8;
            case 8 -> this.inventory.lockedSlots.slot9;
            default -> false;
        };
    }

    static class BlockPicker {
        @ConfigEntry.Gui.Tooltip
        private double range = 100.0;
        @ConfigEntry.Gui.Tooltip
        private boolean useInteractionRange = false;
        @ConfigEntry.Gui.Tooltip
        private double creativeRange = 100.0;
        @ConfigEntry.Gui.Tooltip
        private boolean useCreativeInteractionRange = false;
        @ConfigEntry.Gui.Tooltip
        private boolean pickBlocks = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickEntities = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickFluids = false;
        @ConfigEntry.Gui.Tooltip
        private boolean pickLight = true;
        @ConfigEntry.Gui.Tooltip
        private boolean overrideLitematica = true;
        @ConfigEntry.Gui.Tooltip
        private String blockStateTagBlacklist = "waterlogged";
        @ConfigEntry.Gui.Tooltip
        private String blockEntityTagBlacklist = "";
        @ConfigEntry.Gui.Tooltip
        private String entityTagBlacklist = "UUID, Pos, TileX, TileY, TileZ, Facing, facing, Rotation, Leash";

        BlockPicker() {
        }
    }

    static class IdPicker {
        @ConfigEntry.Gui.Tooltip
        private double range = 100.0;
        @ConfigEntry.Gui.Tooltip
        private boolean useInteractionRange = false;
        @ConfigEntry.Gui.Tooltip
        private boolean pickBlocks = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickEntities = true;
        @ConfigEntry.Gui.Tooltip
        private boolean pickFluids = false;
        @ConfigEntry.Gui.Tooltip
        private boolean addNamespace = false;
        @ConfigEntry.Gui.Tooltip
        private boolean addProperties = true;
        @ConfigEntry.Gui.Tooltip
        private boolean copyToClipboard = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enableHotbarPicker = true;
        @ConfigEntry.Gui.Tooltip
        private boolean convertItemToBlock = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enableTagPicker = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enablePrettyTags = true;
        @ConfigEntry.Gui.Tooltip
        private String blockStateTagBlacklist = "";
        @ConfigEntry.Gui.Tooltip
        private String blockEntityTagBlacklist = "";
        @ConfigEntry.Gui.Tooltip
        private String entityTagBlacklist = "";

        IdPicker() {
        }
    }

    static class ToolPicker {
        @ConfigEntry.Gui.Tooltip
        private double range = 100.0;
        @ConfigEntry.Gui.Tooltip
        private boolean useInteractionRange = false;
        @ConfigEntry.Gui.Tooltip
        private int durabilityThreshold = 20;
        @ConfigEntry.Gui.Tooltip
        private boolean pickFluids = false;
        @ConfigEntry.Gui.CollapsibleObject
        private ToolSettings tools = new ToolSettings();
        @ConfigEntry.Gui.CollapsibleObject
        private WeaponSettings weapons = new WeaponSettings();

        ToolPicker() {
        }
    }

    static class Inventory {
        @ConfigEntry.Gui.Tooltip
        private boolean searchThroughContainers = true;
        @ConfigEntry.Gui.Tooltip
        private boolean stayInSameSlot = false;
        @ConfigEntry.Gui.CollapsibleObject(startExpanded=true)
        @ConfigEntry.Gui.Tooltip
        private LockedSlots lockedSlots = new LockedSlots();

        Inventory() {
        }
    }

    static class ToolSettings {
        @ConfigEntry.Gui.Tooltip
        private boolean preferSilkTouch = true;
        @ConfigEntry.Gui.Tooltip
        private boolean preferEfficiency = false;
        @ConfigEntry.Gui.Tooltip
        private boolean preferSwordForBamboo = true;
        @ConfigEntry.Gui.Tooltip
        private boolean enchantTools = true;
        @ConfigEntry.Gui.Tooltip
        private boolean allowIncompatibleEnchantments = false;
        @ConfigEntry.Gui.Tooltip
        private boolean addToOpUtilities = true;
        @ConfigEntry.Gui.CollapsibleObject
        private Pickaxe pickaxe = new Pickaxe();
        @ConfigEntry.Gui.CollapsibleObject
        private Axe axe = new Axe();
        @ConfigEntry.Gui.CollapsibleObject
        private Shovel shovel = new Shovel();
        @ConfigEntry.Gui.CollapsibleObject
        private Hoe hoe = new Hoe();
        @ConfigEntry.Gui.CollapsibleObject
        private Shears shears = new Shears();
        @ConfigEntry.Gui.CollapsibleObject
        private Brush brush = new Brush();
        @ConfigEntry.Gui.CollapsibleObject
        private FishingRod fishingRod = new FishingRod();

        ToolSettings() {
        }
    }

    static class WeaponSettings {
        @ConfigEntry.Gui.Tooltip
        private String preferredForBow = "creeper, ghast, phantom, skeleton";
        @ConfigEntry.Gui.Tooltip
        private String preferredForTrident = "elder_guardian, guardian";
        @ConfigEntry.Gui.Tooltip
        private boolean enchantWeapons = true;
        @ConfigEntry.Gui.Tooltip
        private boolean allowIncompatibleEnchantments = false;
        @ConfigEntry.Gui.Tooltip
        private boolean addToOpUtilities = true;
        @ConfigEntry.Gui.CollapsibleObject
        private Sword sword = new Sword();
        @ConfigEntry.Gui.CollapsibleObject
        private Bow bow = new Bow();
        @ConfigEntry.Gui.CollapsibleObject
        private Crossbow crossbow = new Crossbow();
        @ConfigEntry.Gui.CollapsibleObject
        private Trident trident = new Trident();
        @ConfigEntry.Gui.CollapsibleObject
        private Mace mace = new Mace();

        WeaponSettings() {
        }
    }

    static class LockedSlots {
        private boolean slot1 = false;
        private boolean slot2 = false;
        private boolean slot3 = false;
        private boolean slot4 = false;
        private boolean slot5 = false;
        private boolean slot6 = false;
        private boolean slot7 = false;
        private boolean slot8 = false;
        private boolean slot9 = false;

        LockedSlots() {
        }
    }
}

