/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.config;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.FileHandler;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2291;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7887;
import net.minecraft.class_7923;

public class PickBlockOverrides {
    private static final HashMap<class_2248, class_1799> blockOverrides = new HashMap();
    private static final HashMap<class_1299<?>, class_1799> entityOverrides = new HashMap();
    private static final Gson gson = new Gson();
    private static int errors = 0;

    private PickBlockOverrides() {
    }

    public static class_1799 getBlockOverride(class_2248 block) {
        if (blockOverrides.containsKey(block)) {
            return blockOverrides.get(block).method_7972();
        }
        return null;
    }

    public static class_1799 getEntityOverride(class_1299<?> entity) {
        if (entityOverrides.containsKey(entity)) {
            return entityOverrides.get(entity).method_7972();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean parseOverrides() {
        File file = FileHandler.getOverridesFile();
        if (!file.exists()) {
            PickBlockPro.LOGGER.warn("Failed to load \"" + file.getName() + "\" because it doesn't exist (anymore)");
            return false;
        }
        try (FileReader reader = new FileReader(file);){
            JsonElement rootElement = JsonParser.parseReader((Reader)reader);
            if (!rootElement.isJsonObject()) {
                PickBlockPro.LOGGER.warn("\"" + file.getName() + "\" doesn't appear to be an actual json and could not be loaded");
                boolean bl = false;
                return bl;
            }
            class_2291 itemReader = new class_2291(class_7887.method_46817());
            HashMap objectMap = new HashMap();
            rootElement.getAsJsonObject().entrySet().forEach(s -> objectMap.put((String)s.getKey(), (JsonElement)s.getValue()));
            JsonElement blockOverridesElement = (JsonElement)objectMap.get("Block to ItemStack");
            if (blockOverridesElement != null) {
                PickBlockOverrides.parseBlockOverrides(blockOverridesElement, itemReader);
            } else {
                InfoProvider.sendMessage((class_2561)class_2561.method_43470((String)"No Block Overrides found"));
            }
            JsonElement entityOverridesElement = (JsonElement)objectMap.get("Entity to ItemStack");
            if (entityOverridesElement != null) {
                PickBlockOverrides.parseEntityOverrides(entityOverridesElement, itemReader);
            } else {
                InfoProvider.sendMessage((class_2561)class_2561.method_43470((String)"No Entity Overrides found"));
            }
            boolean bl = true;
            return bl;
        }
        catch (JsonSyntaxException e) {
            PickBlockPro.LOGGER.warn("\"" + file.getName() + "\" is not properly formatted and could not be loaded: " + e.getCause().getMessage());
            return false;
        }
        catch (IOException e) {
            PickBlockPro.LOGGER.error("Failed to load \"" + file.getName() + "\"");
            e.printStackTrace();
        }
        return false;
    }

    private static void parseBlockOverrides(JsonElement blockOverridesElement, class_2291 itemReader) {
        blockOverrides.clear();
        errors = 0;
        LinkedHashMap overrideMap = (LinkedHashMap)gson.fromJson(blockOverridesElement, new TypeToken<LinkedHashMap<String, String>>(){}.getType());
        for (Map.Entry entry : overrideMap.entrySet()) {
            class_2248 block = PickBlockOverrides.idToBlock((String)entry.getKey());
            class_1799 stack = PickBlockOverrides.idToItemStack((String)entry.getValue(), itemReader);
            if (block == null || stack.method_7960()) continue;
            blockOverrides.put(block, stack);
        }
        PickBlockOverrides.sendResultMessage("block", blockOverrides.size(), errors);
    }

    private static void parseEntityOverrides(JsonElement entityOverridesElement, class_2291 itemReader) {
        entityOverrides.clear();
        errors = 0;
        LinkedHashMap overrideMap = (LinkedHashMap)gson.fromJson(entityOverridesElement, new TypeToken<LinkedHashMap<String, String>>(){}.getType());
        for (Map.Entry entry : overrideMap.entrySet()) {
            class_1299<?> entity = PickBlockOverrides.idToEntity((String)entry.getKey());
            class_1799 stack = PickBlockOverrides.idToItemStack((String)entry.getValue(), itemReader);
            if (entity == null || stack.method_7960()) continue;
            entityOverrides.put(entity, stack);
        }
        PickBlockOverrides.sendResultMessage("entity", entityOverrides.size(), errors);
    }

    private static void sendResultMessage(String type, int overrides, int errors) {
        class_5250 message = class_2561.method_43470((String)"Loaded ").method_27692(class_124.field_1077);
        message.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(overrides)).method_27692(class_124.field_1068));
        message.method_10852((class_2561)class_2561.method_43470((String)(" " + type + (overrides == 1 ? " override" : " overrides") + " and encountered ")).method_27692(class_124.field_1077));
        message.method_10852((class_2561)class_2561.method_43470((String)String.valueOf(errors)).method_27692(class_124.field_1068));
        message.method_10852((class_2561)class_2561.method_43470((String)(" error" + (errors == 1 ? "" : "s"))).method_27692(class_124.field_1077));
        InfoProvider.sendMessage((class_2561)message);
    }

    private static class_2248 idToBlock(String id) {
        class_2960 identifier = PickBlockOverrides.stringToId(id);
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(identifier);
        if (block.equals(class_2246.field_10124)) {
            InfoProvider.sendWarning(class_2561.method_43470((String)("Failed to parse Block ID: " + id)));
            ++errors;
            return null;
        }
        return block;
    }

    private static class_1299<?> idToEntity(String id) {
        Optional entity = class_1299.method_5898((String)id);
        if (entity.isPresent()) {
            return (class_1299)entity.get();
        }
        InfoProvider.sendWarning(class_2561.method_43470((String)("Failed to parse Entity ID: " + id)));
        ++errors;
        return null;
    }

    private static class_1799 idToItemStack(String id, class_2291 itemReader) {
        try {
            class_2291.class_7215 itemResult = itemReader.method_9789(new StringReader(id));
            class_1799 stack = new class_1799(itemResult.comp_628());
            stack.method_59692(itemResult.comp_2439());
            return stack;
        }
        catch (CommandSyntaxException e) {
            InfoProvider.sendWarning(class_2561.method_43470((String)("Failed to parse item: " + id)));
            InfoProvider.sendError(class_2561.method_43470((String)e.getMessage()));
            ++errors;
            return class_1799.field_8037;
        }
    }

    private static class_2960 stringToId(String id) {
        class_2960 identifier = class_2960.method_12829((String)id);
        if (identifier == null) {
            return class_2960.method_60654((String)"minecraft:air");
        }
        return identifier;
    }
}

