/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.util;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2631;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5146;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_9275;
import net.minecraft.class_9276;
import net.minecraft.class_9279;
import net.minecraft.class_9288;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9336;

public class DataComponentUtil {
    private static final ModConfig config = PickBlockPro.getConfig();
    private static final String ID_KEY = "id";
    private static final String COUNT_KEY = "count";
    private static final String LEVEL_KEY = "level";

    private DataComponentUtil() {
    }

    public static void setEntityData(class_1799 stack, class_1297 entity, boolean addLore) {
        class_2487 entityCompound = DataComponentUtil.getEntityNbt(entity);
        config.entityTagBlacklist().forEach(arg_0 -> ((class_2487)entityCompound).method_10551(arg_0));
        if (entityCompound.method_33133()) {
            return;
        }
        stack.method_57379(class_9334.field_49609, (Object)class_9279.method_57456((class_2487)entityCompound));
        if (addLore) {
            DataComponentUtil.addLore(stack, "+Entity Data");
        }
    }

    public static class_2487 getEntityNbt(class_1297 entity) {
        class_5146 saddleable;
        class_2487 entityCompound = entity.method_5647(new class_2487());
        if (entity instanceof class_5146 && (saddleable = (class_5146)entity).method_6725()) {
            class_2487 saddleCompound = new class_2487();
            saddleCompound.method_10582(ID_KEY, class_1802.field_8175.toString());
            saddleCompound.method_10569(COUNT_KEY, 1);
            entityCompound.method_10566("SaddleItem", (class_2520)saddleCompound);
        }
        class_2960 identifier = class_1299.method_5890((class_1299)entity.method_5864());
        entityCompound.method_10582(ID_KEY, identifier.toString());
        return entityCompound;
    }

    public static void setBlockEntityData(class_1799 stack, class_2586 blockEntity, class_5455 registryManager, boolean addLore) {
        boolean dataAdded = false;
        class_2487 blockEntityCompound = blockEntity.method_59535((class_7225.class_7874)registryManager);
        blockEntity.method_57569(blockEntityCompound);
        config.blockEntityTagBlacklist().forEach(arg_0 -> ((class_2487)blockEntityCompound).method_10551(arg_0));
        if (blockEntity instanceof class_2631) {
            blockEntityCompound.method_10551("x");
            blockEntityCompound.method_10551("y");
            blockEntityCompound.method_10551("z");
        }
        if (!blockEntityCompound.method_33133()) {
            class_1747.method_57338((class_1799)stack, (class_2591)blockEntity.method_11017(), (class_2487)blockEntityCompound);
            dataAdded = true;
        }
        class_9323 components = blockEntity.method_57590();
        class_9326 changes = DataComponentUtil.removeBlacklistedComponents(components, config.blockEntityTagBlacklist());
        if (components.method_57835() != changes.method_57847()) {
            stack.method_57365(components);
            stack.method_59692(changes);
            dataAdded = true;
        }
        if (addLore && dataAdded) {
            DataComponentUtil.addLore(stack, "+BlockEntity Data");
        }
    }

    private static class_9326 removeBlacklistedComponents(class_9323 components, List<String> blacklist) {
        List<class_9331> componentsToDelete = components.method_57833().filter(c -> DataComponentUtil.isBlacklisted(c, blacklist)).map(class_9336::comp_2443).toList();
        class_9326.class_9327 changes = class_9326.method_57841();
        componentsToDelete.forEach(arg_0 -> ((class_9326.class_9327)changes).method_57853(arg_0));
        return changes.method_57852();
    }

    private static boolean isBlacklisted(class_9336<?> component, List<String> blacklist) {
        String typeName = component.comp_2443().toString();
        if (typeName.contains(":")) {
            typeName = typeName.substring(typeName.indexOf(":") + 1);
        }
        return blacklist.contains(typeName);
    }

    public static void setBlockStateData(class_1799 stack, class_2680 blockState, boolean addLore) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (class_2769 property : blockState.method_28501()) {
            String key = property.method_11899();
            if (config.blockStateTagBlacklist().contains(key)) continue;
            String value = blockState.method_11654(property).toString().toLowerCase();
            properties.put(key, value);
        }
        if (properties.isEmpty()) {
            return;
        }
        stack.method_57379(class_9334.field_49623, (Object)new class_9275(properties));
        if (addLore) {
            DataComponentUtil.addLore(stack, "+BlockState Data");
        }
    }

    public static void addLore(class_1799 stack, String loreLine) {
        class_9290 lore = (class_9290)stack.method_57825(class_9334.field_49632, (Object)class_9290.field_49340);
        stack.method_57379(class_9334.field_49632, (Object)lore.method_57499((class_2561)class_2561.method_43470((String)loreLine)));
    }

    public static void setLightLevel(class_1799 light, int level) {
        class_9275 state = (class_9275)light.method_57825(class_9334.field_49623, (Object)class_9275.field_49284);
        HashMap<String, String> properties = new HashMap<String, String>(state.comp_2381());
        properties.put(LEVEL_KEY, Integer.toString(level));
        light.method_57379(class_9334.field_49623, (Object)new class_9275(properties));
    }

    public static void cycleLightLevel(class_1799 light) {
        class_9275 state = (class_9275)light.method_57825(class_9334.field_49623, (Object)class_9275.field_49284);
        HashMap<String, String> properties = new HashMap<String, String>(state.comp_2381());
        if (properties.containsKey(LEVEL_KEY)) {
            int lightLvl = Integer.parseInt((String)properties.get(LEVEL_KEY));
            String newLightLvl = lightLvl == 15 ? "0" : String.valueOf(lightLvl + 1);
            properties.replace(LEVEL_KEY, newLightLvl);
        } else {
            properties.put(LEVEL_KEY, "0");
        }
        light.method_57379(class_9334.field_49623, (Object)new class_9275(properties));
    }

    public static void setSkullOwner(class_1799 skull, class_1657 player) {
        class_9296 profile = new class_9296(player.method_7334());
        skull.method_57379(class_9334.field_49617, (Object)profile);
    }

    public static int getAmountStored(class_1799 storage, class_1792 item) {
        int[] amount = new int[]{0};
        if (storage.method_57826(class_9334.field_49622)) {
            class_9288 container = (class_9288)storage.method_57824(class_9334.field_49622);
            container.method_57489().forEach(stack -> {
                if (stack.method_7909().equals(item)) {
                    amount[0] = amount[0] + stack.method_7947();
                }
            });
        }
        if (storage.method_57826(class_9334.field_49650)) {
            class_9276 bundleContents = (class_9276)storage.method_57824(class_9334.field_49650);
            bundleContents.method_59707().forEach(stack -> {
                if (stack.method_7909().equals(item)) {
                    amount[0] = amount[0] + stack.method_7947();
                }
            });
        }
        return amount[0];
    }
}

