/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.owo.config.ui;

import io.wispforest.owo.Owo;
import io.wispforest.owo.config.ConfigWrapper;
import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.ExcludeFromScreen;
import io.wispforest.owo.config.annotation.Expanded;
import io.wispforest.owo.config.annotation.RestartRequired;
import io.wispforest.owo.config.annotation.SectionHeader;
import io.wispforest.owo.config.ui.OptionComponentFactory;
import io.wispforest.owo.config.ui.RestartRequiredScreen;
import io.wispforest.owo.config.ui.component.ConfigEnumButton;
import io.wispforest.owo.config.ui.component.ConfigSlider;
import io.wispforest.owo.config.ui.component.ConfigTextBox;
import io.wispforest.owo.config.ui.component.ConfigToggleButton;
import io.wispforest.owo.config.ui.component.OptionValueProvider;
import io.wispforest.owo.config.ui.component.SearchAnchorComponent;
import io.wispforest.owo.ui.base.BaseComponent;
import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextBoxComponent;
import io.wispforest.owo.ui.container.CollapsibleContainer;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.container.ScrollContainer;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.CursorStyle;
import io.wispforest.owo.ui.core.Easing;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.OwoUIDrawContext;
import io.wispforest.owo.ui.core.ParentComponent;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.parsing.UIParsing;
import io.wispforest.owo.ui.util.UISounds;
import io.wispforest.owo.util.NumberReflection;
import io.wispforest.owo.util.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;

public class ConfigScreen
extends BaseUIModelScreen<FlowLayout> {
    public static final class_2960 DEFAULT_MODEL_ID = class_2960.method_60655((String)"owo", (String)"config");
    private static final Map<String, Function<class_437, ? extends ConfigScreen>> CONFIG_SCREEN_PROVIDERS = new HashMap<String, Function<class_437, ? extends ConfigScreen>>();
    private static final Map<Predicate<Option<?>>, OptionComponentFactory<?>> DEFAULT_FACTORIES = new HashMap();
    protected final Map<Predicate<Option<?>>, OptionComponentFactory<?>> extraFactories = new HashMap();
    protected final class_437 parent;
    protected final ConfigWrapper<?> config;
    protected final Map<Option, OptionValueProvider> options = new HashMap<Option, OptionValueProvider>();
    protected String lastSearchFieldText = "";
    @Nullable
    protected SearchMatches currentMatches = null;
    protected int currentMatchIndex = 0;

    protected ConfigScreen(class_2960 modelId, ConfigWrapper<?> config, @Nullable class_437 parent) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset(modelId));
        this.parent = parent;
        this.config = config;
    }

    public static ConfigScreen create(ConfigWrapper<?> config, @Nullable class_437 parent) {
        return new ConfigScreen(DEFAULT_MODEL_ID, config, parent);
    }

    public static ConfigScreen createWithCustomModel(class_2960 modelId, ConfigWrapper<?> config, @Nullable class_437 parent) {
        return new ConfigScreen(modelId, config, parent);
    }

    public static <S extends ConfigScreen> void registerProvider(String modId, Function<class_437, S> supplier) {
        if (CONFIG_SCREEN_PROVIDERS.put(modId, supplier) != null) {
            throw new IllegalArgumentException("Tried to register config screen provider for mod id " + modId + " twice");
        }
    }

    @Nullable
    public static Function<class_437, ? extends ConfigScreen> getProvider(String modId) {
        return CONFIG_SCREEN_PROVIDERS.get(modId);
    }

    public static void forEachProvider(BiConsumer<String, Function<class_437, ? extends ConfigScreen>> action) {
        CONFIG_SCREEN_PROVIDERS.forEach(action);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        this.options.clear();
        rootComponent.childById(LabelComponent.class, "title").text((class_2561)class_2561.method_43471((String)("text.config." + this.config.name() + ".title")));
        if (this.field_22787.field_1687 == null) {
            rootComponent.surface(Surface.OPTIONS_BACKGROUND);
        }
        rootComponent.childById(ButtonComponent.class, "done-button").onPress(button -> this.method_25419());
        rootComponent.childById(ButtonComponent.class, "reload-button").onPress(button -> {
            this.config.load();
            this.uiAdapter = null;
            this.method_41843();
        });
        FlowLayout optionPanel = rootComponent.childById(FlowLayout.class, "option-panel");
        LinkedHashMap<Component, class_2561> sections = new LinkedHashMap<Component, class_2561>();
        HashMap<Option.Key, FlowLayout> containers = new HashMap<Option.Key, FlowLayout>();
        containers.put(Option.Key.ROOT, optionPanel);
        rootComponent.childById(TextBoxComponent.class, "search-field").configure(searchField -> {
            LabelComponent matchIndicator = rootComponent.childById(LabelComponent.class, "search-match-indicator");
            ScrollContainer optionScroll = rootComponent.childById(ScrollContainer.class, "option-panel-scroll");
            String searchHint = class_1074.method_4662((String)"text.owo.config.search", (Object[])new Object[0]);
            searchField.method_1887(searchHint);
            searchField.onChanged().subscribe(s -> {
                searchField.method_1887(s.isEmpty() ? searchHint : "");
                if (!s.equals(this.lastSearchFieldText)) {
                    searchField.method_1868(0xE0E0E0);
                    matchIndicator.text((class_2561)class_2561.method_43473());
                }
            });
            searchField.keyPress().subscribe((keyCode, scanCode, modifiers) -> {
                if (keyCode != 257 && keyCode != 335) {
                    return false;
                }
                String query = searchField.method_1882().toLowerCase(Locale.ROOT);
                if (query.isBlank()) {
                    return false;
                }
                if (this.currentMatches != null && this.currentMatches.query.equals(query)) {
                    this.currentMatchIndex = this.currentMatches.matches().isEmpty() ? -1 : (this.currentMatchIndex + 1) % this.currentMatches.matches.size();
                } else {
                    String[] splitQuery = query.split(" ");
                    this.currentMatchIndex = 0;
                    this.currentMatches = new SearchMatches(query, this.collectSearchAnchors(optionScroll).stream().filter(anchor -> Arrays.stream(splitQuery).allMatch(anchor.currentSearchText()::contains)).toList());
                }
                if (this.currentMatches.matches.isEmpty()) {
                    matchIndicator.text((class_2561)class_2561.method_43471((String)"text.owo.config.search.no_matches"));
                    searchField.method_1868(15408438);
                } else {
                    matchIndicator.text((class_2561)class_2561.method_43469((String)"text.owo.config.search.matches", (Object[])new Object[]{this.currentMatchIndex + 1, this.currentMatches.matches.size()}));
                    searchField.method_1868(2686911);
                    SearchAnchorComponent selectedMatch = this.currentMatches.matches.get(this.currentMatchIndex);
                    ParentComponent anchorFrame = selectedMatch.anchorFrame();
                    ArrayDeque<Option.Key> pathToRoot = new ArrayDeque<Option.Key>();
                    Option.Key key = selectedMatch.key();
                    while (!key.isRoot()) {
                        pathToRoot.push(key);
                        key = key.parent();
                    }
                    while (!pathToRoot.isEmpty()) {
                        CollapsibleContainer collapsible;
                        Object patt0$temp = containers.get(pathToRoot.pop());
                        if (!(patt0$temp instanceof CollapsibleContainer) || (collapsible = (CollapsibleContainer)patt0$temp).expanded()) continue;
                        collapsible.toggleExpansion();
                    }
                    if (anchorFrame instanceof FlowLayout) {
                        FlowLayout flow = (FlowLayout)anchorFrame;
                        flow.child(0, selectedMatch.configure(new SearchHighlighterComponent()));
                    }
                    if (anchorFrame.y() < optionScroll.y() || anchorFrame.y() + anchorFrame.height() > optionScroll.y() + optionScroll.height()) {
                        optionScroll.scrollTo(selectedMatch.anchorFrame());
                    }
                }
                return true;
            });
        });
        this.config.forEachOption(option -> {
            if (option.backingField().hasAnnotation(ExcludeFromScreen.class)) {
                return;
            }
            Option.Key parentKey = option.key().parent();
            if (!parentKey.isRoot() && this.config.fieldForKey(parentKey).isAnnotationPresent(ExcludeFromScreen.class)) {
                return;
            }
            OptionComponentFactory factory = this.factoryForOption((Option<?>)option);
            if (factory == null) {
                Owo.LOGGER.warn("Could not create UI component for config option {}", option);
                return;
            }
            OptionComponentFactory.Result<?, ?> result = factory.make(this.model, option);
            this.options.put((Option)option, (OptionValueProvider)result.optionProvider());
            boolean expanded = !parentKey.isRoot() && this.config.fieldForKey(parentKey).isAnnotationPresent(Expanded.class);
            FlowLayout container = containers.getOrDefault(parentKey, Containers.collapsible(Sizing.fill(100), Sizing.content(), (class_2561)class_2561.method_43471((String)("text.config." + this.config.name() + ".category." + parentKey.asString())), expanded).configure(nestedContainer -> {
                String categoryKey = "text.config." + this.config.name() + ".category." + parentKey.asString();
                if (class_1074.method_4663((String)(categoryKey + ".tooltip"))) {
                    nestedContainer.titleLayout().tooltip((class_2561)class_2561.method_43471((String)(categoryKey + ".tooltip")));
                }
                nestedContainer.titleLayout().child(new SearchAnchorComponent(nestedContainer.titleLayout(), option.key(), () -> class_1074.method_4662((String)categoryKey, (Object[])new Object[0])).highlightConfigurator(highlight -> highlight.positioning(Positioning.absolute(-5, -5)).verticalSizing(Sizing.fixed(19))));
            }));
            if (!containers.containsKey(parentKey) && containers.containsKey(parentKey.parent())) {
                if (this.config.fieldForKey(parentKey).isAnnotationPresent(SectionHeader.class)) {
                    this.appendSection(sections, this.config.fieldForKey(parentKey), (FlowLayout)containers.get(parentKey.parent()));
                }
                containers.put(parentKey, container);
                ((FlowLayout)containers.get(parentKey.parent())).child(container);
            }
            if (option.detached()) {
                result.baseComponent().tooltip(this.field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)"text.owo.config.managed_by_server"), Integer.MAX_VALUE).stream().map(class_5684::method_32662).toList());
            } else {
                ArrayList<class_5481> tooltipText = new ArrayList<class_5481>();
                String tooltipTranslationKey = option.translationKey() + ".tooltip";
                if (class_1074.method_4663((String)tooltipTranslationKey)) {
                    tooltipText.addAll(this.field_22787.field_1772.method_1728((class_5348)class_2561.method_43471((String)tooltipTranslationKey), Integer.MAX_VALUE));
                }
                if (option.backingField().hasAnnotation(RestartRequired.class)) {
                    tooltipText.add(class_2561.method_43471((String)"text.owo.config.applies_after_restart").method_30937());
                }
                if (!tooltipText.isEmpty()) {
                    result.baseComponent().tooltip(tooltipText.stream().map(class_5684::method_32662).toList());
                }
            }
            if (option.backingField().hasAnnotation(SectionHeader.class)) {
                this.appendSection(sections, option.backingField().field(), container);
            }
            container.child((Component)result.baseComponent());
        });
        if (!sections.isEmpty()) {
            FlowLayout panelContainer = rootComponent.childById(FlowLayout.class, "option-panel-container");
            ScrollContainer panelScroll = rootComponent.childById(ScrollContainer.class, "option-panel-scroll");
            panelScroll.margins(Insets.right(10));
            FlowLayout buttonPanel = this.model.expandTemplate(FlowLayout.class, "section-buttons", Map.of());
            sections.forEach((component, text) -> {
                class_5250 hoveredText = text.method_27661().method_27692(class_124.field_1054);
                LabelComponent label = Components.label(text);
                label.cursorStyle(CursorStyle.HAND).margins(Insets.of(2));
                label.mouseEnter().subscribe(() -> label.text((class_2561)hoveredText));
                label.mouseLeave().subscribe(() -> label.text((class_2561)text));
                label.mouseDown().subscribe((mouseX, mouseY, button) -> {
                    panelScroll.scrollTo((Component)component);
                    UISounds.playInteractionSound();
                    return true;
                });
                buttonPanel.child(label);
            });
            LabelComponent closeButton = Components.label((class_2561)class_2561.method_43470((String)"<").method_27692(class_124.field_1067));
            closeButton.tooltip((class_2561)class_2561.method_43471((String)"text.owo.config.sections_tooltip"));
            closeButton.positioning(Positioning.relative(100, 50)).cursorStyle(CursorStyle.HAND).margins(Insets.right(2));
            panelContainer.child(closeButton);
            panelContainer.mouseDown().subscribe((mouseX, mouseY, button) -> {
                if (mouseX < (double)(panelContainer.width() - 10)) {
                    return false;
                }
                if (buttonPanel.horizontalSizing().animation() == null) {
                    buttonPanel.horizontalSizing().animate(350, Easing.CUBIC, Sizing.content());
                }
                buttonPanel.horizontalSizing().animation().reverse();
                closeButton.text((class_2561)class_2561.method_43470((String)(closeButton.text().getString().equals(">") ? "<" : ">")).method_27692(class_124.field_1067));
                UISounds.playInteractionSound();
                return true;
            });
            rootComponent.childById(FlowLayout.class, "main-panel").child(buttonPanel);
        }
    }

    protected void appendSection(Map<Component, class_2561> sections, Field field, FlowLayout container) {
        String translationKey = "text.config." + this.config.name() + ".section." + field.getAnnotation(SectionHeader.class).value();
        FlowLayout header = this.model.expandTemplate(FlowLayout.class, "section-header", Map.of());
        header.childById(LabelComponent.class, "header").configure(label -> {
            label.text((class_2561)class_2561.method_43471((String)translationKey).method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}));
            header.child(new SearchAnchorComponent(header, Option.Key.ROOT, () -> label.text().getString()));
        });
        sections.put(header, (class_2561)class_2561.method_43471((String)translationKey));
        container.child(header);
    }

    protected List<SearchAnchorComponent> collectSearchAnchors(ParentComponent root) {
        ArrayList<SearchAnchorComponent> discovered = new ArrayList<SearchAnchorComponent>();
        ArrayDeque<Component> candidates = new ArrayDeque<Component>(root.children());
        while (!candidates.isEmpty()) {
            Component candidate = candidates.poll();
            if (candidate instanceof CollapsibleContainer) {
                CollapsibleContainer collapsible = (CollapsibleContainer)candidate;
                candidates.addAll(collapsible.children());
                if (collapsible.expanded()) continue;
                candidates.addAll(collapsible.collapsibleChildren());
                continue;
            }
            if (candidate instanceof ParentComponent) {
                ParentComponent parentComponent = (ParentComponent)candidate;
                candidates.addAll(parentComponent.children());
                continue;
            }
            if (!(candidate instanceof SearchAnchorComponent)) continue;
            SearchAnchorComponent anchor = (SearchAnchorComponent)candidate;
            discovered.add(anchor);
        }
        return discovered;
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 70 && (modifiers & 2) != 0) {
            ((FlowLayout)this.uiAdapter.rootComponent).focusHandler().focus(((FlowLayout)this.uiAdapter.rootComponent).childById(Component.class, "search-field"), Component.FocusSource.MOUSE_CLICK);
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        MutableBoolean shouldRestart = new MutableBoolean();
        this.options.forEach((option, component) -> {
            if (!option.backingField().hasAnnotation(RestartRequired.class)) {
                return;
            }
            if (Objects.equals(option.value(), component.parsedValue())) {
                return;
            }
            shouldRestart.setTrue();
        });
        this.field_22787.method_1507((class_437)(shouldRestart.booleanValue() ? new RestartRequiredScreen(this.parent) : this.parent));
    }

    @Override
    public void method_25432() {
        this.options.forEach((option, component) -> {
            if (!component.isValid()) {
                return;
            }
            option.set(component.parsedValue());
        });
        super.method_25432();
    }

    @Nullable
    protected OptionComponentFactory factoryForOption(Option<?> option) {
        for (Predicate<Option<?>> predicate : this.extraFactories.keySet()) {
            if (!predicate.test(option)) continue;
            return this.extraFactories.get(predicate);
        }
        for (Predicate<Option<?>> predicate : DEFAULT_FACTORIES.keySet()) {
            if (!predicate.test(option)) continue;
            return DEFAULT_FACTORIES.get(predicate);
        }
        return null;
    }

    private static boolean isStringOrNumberList(Field field) {
        if (field.getType() != List.class) {
            return false;
        }
        Class<?> listType = ReflectionUtils.getTypeArgument(field.getGenericType(), 0);
        if (listType == null) {
            return false;
        }
        return String.class == listType || NumberReflection.isNumberType(listType);
    }

    static {
        DEFAULT_FACTORIES.put(option -> NumberReflection.isNumberType(option.clazz()), OptionComponentFactory.NUMBER);
        DEFAULT_FACTORIES.put(option -> option.clazz() == String.class, OptionComponentFactory.STRING);
        DEFAULT_FACTORIES.put(option -> option.clazz() == Boolean.class || option.clazz() == Boolean.TYPE, OptionComponentFactory.BOOLEAN);
        DEFAULT_FACTORIES.put(option -> option.clazz() == class_2960.class, OptionComponentFactory.IDENTIFIER);
        DEFAULT_FACTORIES.put(option -> option.clazz() == Color.class, OptionComponentFactory.COLOR);
        DEFAULT_FACTORIES.put(option -> ConfigScreen.isStringOrNumberList(option.backingField().field()), OptionComponentFactory.LIST);
        DEFAULT_FACTORIES.put(option -> option.clazz().isEnum(), OptionComponentFactory.ENUM);
        UIParsing.registerFactory("config-slider", element -> new ConfigSlider());
        UIParsing.registerFactory("config-toggle-button", element -> new ConfigToggleButton());
        UIParsing.registerFactory("config-enum-button", element -> new ConfigEnumButton());
        UIParsing.registerFactory("config-text-box", element -> new ConfigTextBox());
    }

    private record SearchMatches(String query, List<SearchAnchorComponent> matches) {
    }

    public static class SearchHighlighterComponent
    extends BaseComponent {
        private final Color startColor = Color.ofArgb(9280480);
        private final Color endColor = Color.ofArgb(1284348896);
        private float age = 0.0f;

        public SearchHighlighterComponent() {
            this.positioning(Positioning.absolute(0, 0));
            this.sizing(Sizing.fill(100), Sizing.fill(100));
        }

        @Override
        public void draw(OwoUIDrawContext context, int mouseX, int mouseY, float partialTicks, float delta) {
            int mainColor = this.startColor.interpolate(this.endColor, (float)Math.sin((double)(this.age / 25.0f) * Math.PI)).argb();
            int segmentWidth = (int)((float)this.width * 0.3f);
            int baseX = (int)((float)(this.x - segmentWidth) + Easing.CUBIC.apply(this.age / 25.0f) * (float)(this.width + segmentWidth * 2));
            context.drawGradientRect(baseX - segmentWidth, this.y, segmentWidth, this.height, 0, mainColor, mainColor, 0);
            context.drawGradientRect(baseX, this.y, segmentWidth, this.height, mainColor, 0, 0, mainColor);
        }

        @Override
        public void update(float delta, int mouseX, int mouseY) {
            float f;
            super.update(delta, mouseX, mouseY);
            this.age += delta;
            if (f > 25.0f) {
                this.parent.queue(() -> this.parent.removeChild(this));
            }
        }
    }
}

