/*
 * Decompiled with CFR 0.152.
 */
package interactic;

import interactic.ItemFilterItem;
import interactic.ItemFilterScreenHandler;
import interactic.util.InteracticConfig;
import interactic.util.InteracticNetworking;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_7701;
import net.minecraft.class_7923;

public class InteracticInit
implements ModInitializer {
    public static final String MOD_ID = "interactic";
    private static class_1792 ITEM_FILTER = null;
    private static final InteracticConfig CONFIG = InteracticConfig.createAndLoad();
    private static float itemRotationSpeedMultiplier = 1.0f;
    public static final class_3917<ItemFilterScreenHandler> ITEM_FILTER_SCREEN_HANDLER = (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)InteracticInit.id("item_filter"), (Object)new class_3917(ItemFilterScreenHandler::new, class_7701.field_40183));

    public void onInitialize() {
        CONFIG.subscribeToClientOnlyMode(clientOnlyMode -> {
            if (!clientOnlyMode.booleanValue()) {
                return;
            }
            CONFIG.itemsActAsProjectiles(false);
            CONFIG.itemThrowing(false);
            CONFIG.itemFilterEnabled(false);
            CONFIG.autoPickup(true);
            CONFIG.rightClickPickup(false);
        });
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToItemsActAsProjectiles, CONFIG::itemsActAsProjectiles, false);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToItemThrowing, CONFIG::itemThrowing, false);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToItemFilterEnabled, CONFIG::itemFilterEnabled, false);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToAutoPickup, CONFIG::autoPickup, true);
        InteracticInit.enforceInClientOnlyMode(CONFIG::subscribeToRightClickPickup, CONFIG::rightClickPickup, false);
        if (FabricLoader.getInstance().isModLoaded("iris")) {
            itemRotationSpeedMultiplier = 0.5f;
        }
        if (CONFIG.itemFilterEnabled()) {
            ITEM_FILTER = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)InteracticInit.id("item_filter"), (Object)((Object)new ItemFilterItem()));
        }
        InteracticNetworking.init();
    }

    public static class_2960 id(String path) {
        return class_2960.method_60655((String)MOD_ID, (String)path);
    }

    public static class_1792 getItemFilter() {
        return ITEM_FILTER;
    }

    private static void enforceInClientOnlyMode(Consumer<Consumer<Boolean>> eventSource, Consumer<Boolean> setter, boolean defaultValue) {
        eventSource.accept(value -> {
            if (!CONFIG.clientOnlyMode()) {
                return;
            }
            if (value != defaultValue) {
                setter.accept(defaultValue);
            }
        });
    }

    public static float getItemRotationSpeedMultiplier() {
        return itemRotationSpeedMultiplier;
    }

    public static InteracticConfig getConfig() {
        return CONFIG;
    }
}

