/*
 * Decompiled with CFR 0.152.
 */
package interactic.mixin;

import interactic.InteracticInit;
import interactic.util.Helpers;
import interactic.util.InteracticItemExtensions;
import interactic.util.ItemDamageSource;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_9285;
import net.minecraft.class_9334;
import org.apache.commons.lang3.mutable.MutableDouble;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1542.class})
public abstract class ItemEntityMixin
extends class_1297
implements InteracticItemExtensions {
    @Shadow
    private int field_7204;
    @Unique
    private float rotation = -1.0f;
    @Unique
    private boolean wasThrown;
    @Unique
    private boolean wasFullPower;

    @Shadow
    public abstract class_1799 method_6983();

    @Shadow
    @Nullable
    public abstract class_1297 method_24921();

    private ItemEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Override
    public float getRotation() {
        return this.rotation;
    }

    @Override
    public void setRotation(float rotation) {
        this.rotation = rotation;
    }

    @Override
    public void markThrown() {
        this.wasThrown = true;
    }

    @Override
    public void markFullPower() {
        this.wasFullPower = true;
    }

    @Inject(method={"onPlayerCollision"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;getStack()Lnet/minecraft/item/ItemStack;", ordinal=0)}, cancellable=true)
    private void controlPickup(class_1657 player, CallbackInfo ci) {
        if (Helpers.canPlayerPickUpItem(player, (class_1542)this)) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void dealThrowingDamage(CallbackInfo ci) {
        List entities;
        if (!InteracticInit.getConfig().itemsActAsProjectiles()) {
            return;
        }
        if (this.field_7204 < 2) {
            return;
        }
        class_1937 world = this.method_37908();
        if (world.field_9236) {
            return;
        }
        if (this.method_24828()) {
            this.wasThrown = false;
        }
        if (!this.wasThrown) {
            return;
        }
        boolean hasDamageModifiers = ((class_9285)this.method_6983().method_57825(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393().stream().anyMatch(entry -> entry.comp_2395().comp_349() == class_5134.field_23721);
        if (!this.wasFullPower && !hasDamageModifiers) {
            return;
        }
        MutableDouble damage = new MutableDouble(2.0);
        if (hasDamageModifiers) {
            this.method_6983().method_57354(class_1304.field_6173, (attribEntry, modifier) -> {
                if (attribEntry.comp_349() != class_5134.field_23721 || modifier.comp_2450() != class_1322.class_1323.field_6328) {
                    return;
                }
                damage.add(modifier.comp_2449());
            });
        }
        if ((entities = world.method_18467(class_1309.class, this.method_5829().method_1014(0.15))).isEmpty()) {
            return;
        }
        class_1309 target = (class_1309)entities.get(0);
        ItemDamageSource damageSource = new ItemDamageSource((class_1542)this, this.method_24921());
        if (target.field_6235 != 0 || target.method_5679((class_1282)damageSource)) {
            return;
        }
        target.method_5643((class_1282)damageSource, damage.floatValue());
        this.method_6983().method_7956(1, (class_3218)world, null, item -> this.method_31472());
    }

    public float method_5871() {
        return 0.2f;
    }
}

