/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import eu.midnightdust.lib.util.PlatformFunctions;
import eu.midnightdust.midnightcontrols.ControlsMode;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.MidnightInput;
import eu.midnightdust.midnightcontrols.client.MidnightReacharound;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.ButtonCategory;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.gui.MidnightControlsHud;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.mixin.KeyBindingIDAccessor;
import eu.midnightdust.midnightcontrols.client.ring.ButtonBindingRingAction;
import eu.midnightdust.midnightcontrols.client.ring.MidnightRing;
import eu.midnightdust.midnightcontrols.client.touch.TouchInput;
import eu.midnightdust.midnightcontrols.client.util.RainbowColor;
import eu.midnightdust.midnightcontrols.packet.ControlsModePacket;
import eu.midnightdust.midnightcontrols.packet.FeaturePacket;
import eu.midnightdust.midnightcontrols.packet.HelloPacket;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_8710;
import org.aperlambda.lambdacommon.Identifier;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.glfw.GLFW;
import org.thinkingstudio.obsidianui.fabric.event.OpenScreenCallback;
import org.thinkingstudio.obsidianui.hud.Hud;
import org.thinkingstudio.obsidianui.hud.HudManager;

public class MidnightControlsClient
extends MidnightControls
implements ClientModInitializer {
    public static boolean lateInitDone = false;
    private static MidnightControlsClient INSTANCE;
    public static final class_304 BINDING_LOOK_UP;
    public static final class_304 BINDING_LOOK_RIGHT;
    public static final class_304 BINDING_LOOK_DOWN;
    public static final class_304 BINDING_LOOK_LEFT;
    public static final class_304 BINDING_RING;
    public static final class_2960 CONTROLLER_BUTTONS;
    public static final class_2960 CONTROLLER_EXPANDED;
    public static final class_2960 CONTROLLER_AXIS;
    public static final class_2960 CURSOR_TEXTURE;
    public static final File MAPPINGS_FILE;
    public final MidnightInput input = new MidnightInput();
    public final MidnightRing ring = new MidnightRing(this);
    public final MidnightReacharound reacharound = new MidnightReacharound();
    private MidnightControlsHud hud;
    private ControlsMode previousControlsMode;
    ButtonCategory category;

    public void onInitializeClient() {
        INSTANCE = this;
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_UP);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_RIGHT);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_DOWN);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_LOOK_LEFT);
        KeyBindingHelper.registerKeyBinding((class_304)BINDING_RING);
        this.ring.registerAction("buttonbinding", ButtonBindingRingAction.FACTORY);
        ClientPlayNetworking.registerGlobalReceiver((class_8710.class_9154)CONTROLS_MODE_CHANNEL, (payload, context) -> context.responseSender().sendPacket((class_8710)new ControlsModePacket(MidnightControlsConfig.controlsMode.getName())));
        ClientPlayNetworking.registerGlobalReceiver(FeaturePacket.PACKET_ID, (payload, context) -> {});
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> {
            String version = "";
            Optional container = FabricLoader.getInstance().getModContainer("midnightcontrols");
            if (container.isPresent()) {
                version = ((ModContainer)container.get()).getMetadata().getVersion().getFriendlyString();
            }
            String controlsMode = MidnightControlsConfig.controlsMode.getName();
            sender.sendPacket((class_8710)new HelloPacket(version, controlsMode));
            sender.sendPacket((class_8710)new ControlsModePacket(controlsMode));
        });
        ClientPlayConnectionEvents.DISCONNECT.register(this::onLeave);
        ClientTickEvents.START_CLIENT_TICK.register(this.reacharound::tick);
        ClientTickEvents.START_CLIENT_TICK.register(this::onTick);
        OpenScreenCallback.POST.register((client, screen) -> {
            if (screen == null && MidnightControlsConfig.controlsMode == ControlsMode.TOUCHSCREEN) {
                screen = new TouchscreenOverlay(this);
                screen.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
                client.field_1743 = false;
                client.field_1755 = screen;
            } else if (screen != null) {
                this.input.onScreenOpen(client, client.method_22683().method_4480(), client.method_22683().method_4507());
            }
        });
        final class_310 client2 = class_310.method_1551();
        int delay = 0;
        int period = 1;
        Timer timer = new Timer();
        timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                MidnightControlsClient.this.input.updateCamera(client2);
            }
        }, delay, (long)period);
        this.hud = new MidnightControlsHud(this);
        HudManager.register((Hud)this.hud);
        FabricLoader.getInstance().getModContainer("midnightcontrols").ifPresent(modContainer -> {
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"midnightcontrols", (String)"bedrock"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
            ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)"midnightcontrols", (String)"legacy"), (ModContainer)modContainer, (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        });
    }

    public void onMcInit(@NotNull class_310 client) {
        ButtonBinding.init(client.field_1690);
        MidnightControlsConfig.load();
        if (MidnightControlsConfig.configVersion < 2) {
            MidnightControlsConfig.mouseScreens.remove("me.jellysquid.mods.sodium.client.gui");
            MidnightControlsConfig.mouseScreens.remove("net.coderbot.iris.gui");
            MidnightControlsConfig.mouseScreens.remove("net.minecraft.class_5375");
            MidnightControlsConfig.mouseScreens.remove("net.minecraft.client.gui.screen.pack.PackScreen");
            MidnightControlsConfig.configVersion = 2;
            MidnightControlsConfig.write((String)"midnightcontrols");
        }
        this.hud.setVisible(MidnightControlsConfig.hudEnable);
        Controller.updateMappings();
        try {
            GLFW.glfwSetJoystickCallback((jid, event) -> {
                if (event == 262145) {
                    Controller controller = Controller.byId(jid);
                    client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.connected", (Object[])new Object[]{jid}), (class_2561)class_2561.method_43470((String)controller.getName())));
                } else if (event == 262146) {
                    client.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.disconnected", (Object[])new Object[]{jid}), null));
                }
                this.switchControlsMode();
            });
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        MidnightControlsCompat.init(this);
    }

    public void initKeybindings() {
        if (lateInitDone) {
            return;
        }
        if (KeyBindingIDAccessor.getKEYS_BY_ID() == null || KeyBindingIDAccessor.getKEYS_BY_ID().isEmpty()) {
            return;
        }
        if (PlatformFunctions.isModLoaded((String)"voxelmap") && !KeyBindingIDAccessor.getKEYS_BY_ID().containsKey("key.minimap.toggleingamewaypoints")) {
            return;
        }
        if (PlatformFunctions.isModLoaded((String)"wynntils") && KeyBindingIDAccessor.getKEYS_BY_ID().entrySet().stream().noneMatch(b -> Objects.equals(((class_304)b.getValue()).method_1423(), "Wynntils"))) {
            return;
        }
        for (int i = 0; i < KeyBindingIDAccessor.getKEYS_BY_ID().size(); ++i) {
            class_304 keyBinding = (class_304)((Map.Entry)KeyBindingIDAccessor.getKEYS_BY_ID().entrySet().stream().toList().get(i)).getValue();
            if (!MidnightControlsConfig.excludedKeybindings.stream().noneMatch(excluded -> keyBinding.method_1431().startsWith((String)excluded)) || keyBinding.method_1431().contains("midnightcontrols") || keyBinding.method_1431().contains("ok_zoomer") || keyBinding.method_1431().contains("okzoomer")) continue;
            this.category = null;
            InputManager.streamCategories().forEach(buttonCategory -> {
                if (buttonCategory.getIdentifier().equals((Object)new Identifier("minecraft", keyBinding.method_1423()))) {
                    this.category = buttonCategory;
                }
            });
            if (this.category == null) {
                this.category = new ButtonCategory(new Identifier("minecraft", keyBinding.method_1423()));
                InputManager.registerCategory(this.category);
            }
            ButtonBinding buttonBinding = new ButtonBinding.Builder(keyBinding.method_1431()).category(this.category).linkKeybind(keyBinding).register();
            if (!MidnightControlsConfig.debug) continue;
            this.logger.info(keyBinding.method_1431());
            this.logger.info((Object)buttonBinding);
        }
        InputManager.loadButtonBindings();
        lateInitDone = true;
    }

    public void onTick(@NotNull class_310 client) {
        this.initKeybindings();
        this.input.tick(client);
        if (MidnightControlsConfig.controlsMode == ControlsMode.CONTROLLER && (client.method_1569() || MidnightControlsConfig.unfocusedInput)) {
            this.input.tickController(client);
        }
        if (BINDING_RING.method_1436()) {
            this.ring.loadFromUnbound();
            client.method_1507((class_437)new RingScreen());
        }
        if (client.field_1687 != null && MidnightControlsConfig.enableHints && !MidnightControlsConfig.autoSwitchMode && MidnightControlsConfig.controlsMode == ControlsMode.DEFAULT && MidnightControlsConfig.getController().isGamepad()) {
            client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"midnightcontrols.controller.tutorial.title"), (class_2561)class_2561.method_43469((String)"midnightcontrols.controller.tutorial.description", (Object[])new Object[]{class_2561.method_43471((String)"options.title"), class_2561.method_43471((String)"controls.title"), class_2561.method_43471((String)"midnightcontrols.menu.title.controller")})));
            MidnightControlsConfig.enableHints = false;
            MidnightControlsConfig.save();
        }
        RainbowColor.tick();
        TouchInput.tick();
    }

    public void onLeave(class_634 handler, class_310 client) {
        MidnightControlsFeature.resetAllAllowed();
    }

    public void switchControlsMode() {
        if (MidnightControlsConfig.autoSwitchMode) {
            if (MidnightControlsConfig.getController().isGamepad()) {
                this.previousControlsMode = MidnightControlsConfig.controlsMode;
                MidnightControlsConfig.controlsMode = ControlsMode.CONTROLLER;
            } else {
                if (this.previousControlsMode == null) {
                    this.previousControlsMode = ControlsMode.DEFAULT;
                }
                MidnightControlsConfig.controlsMode = this.previousControlsMode;
            }
            ClientPlayNetworking.getSender().sendPacket((class_8710)new ControlsModePacket(MidnightControlsConfig.controlsMode.getName()));
        }
    }

    public void setHudEnabled(boolean enabled) {
        MidnightControlsConfig.hudEnable = enabled;
        this.hud.setVisible(enabled);
    }

    public static MidnightControlsClient get() {
        return INSTANCE;
    }

    static {
        BINDING_LOOK_UP = InputManager.makeKeyBinding(class_2960.method_60655((String)"midnightcontrols", (String)"look_up"), class_3675.class_307.field_1668, 328, "key.categories.movement");
        BINDING_LOOK_RIGHT = InputManager.makeKeyBinding(class_2960.method_60655((String)"midnightcontrols", (String)"look_right"), class_3675.class_307.field_1668, 326, "key.categories.movement");
        BINDING_LOOK_DOWN = InputManager.makeKeyBinding(class_2960.method_60655((String)"midnightcontrols", (String)"look_down"), class_3675.class_307.field_1668, 322, "key.categories.movement");
        BINDING_LOOK_LEFT = InputManager.makeKeyBinding(class_2960.method_60655((String)"midnightcontrols", (String)"look_left"), class_3675.class_307.field_1668, 324, "key.categories.movement");
        BINDING_RING = InputManager.makeKeyBinding(class_2960.method_60655((String)"midnightcontrols", (String)"ring"), class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "key.categories.misc");
        CONTROLLER_BUTTONS = class_2960.method_60655((String)"midnightcontrols", (String)"textures/gui/controller_buttons.png");
        CONTROLLER_EXPANDED = class_2960.method_60655((String)"midnightcontrols", (String)"textures/gui/controller_expanded.png");
        CONTROLLER_AXIS = class_2960.method_60655((String)"midnightcontrols", (String)"textures/gui/controller_axis.png");
        CURSOR_TEXTURE = class_2960.method_60655((String)"midnightcontrols", (String)"textures/gui/cursor.png");
        MAPPINGS_FILE = new File("config/gamecontrollercustommappings.txt");
    }
}

