/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client;

import com.google.common.collect.ImmutableSet;
import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import eu.midnightdust.midnightcontrols.client.compat.EmotecraftCompat;
import eu.midnightdust.midnightcontrols.client.compat.LibGuiCompat;
import eu.midnightdust.midnightcontrols.client.compat.MidnightControlsCompat;
import eu.midnightdust.midnightcontrols.client.compat.YACLCompat;
import eu.midnightdust.midnightcontrols.client.controller.ButtonBinding;
import eu.midnightdust.midnightcontrols.client.controller.Controller;
import eu.midnightdust.midnightcontrols.client.controller.InputManager;
import eu.midnightdust.midnightcontrols.client.enums.ButtonState;
import eu.midnightdust.midnightcontrols.client.enums.CameraMode;
import eu.midnightdust.midnightcontrols.client.gui.RingScreen;
import eu.midnightdust.midnightcontrols.client.gui.TouchscreenOverlay;
import eu.midnightdust.midnightcontrols.client.gui.widget.ControllerControlsWidget;
import eu.midnightdust.midnightcontrols.client.mixin.AdvancementsScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.CreativeInventoryScreenAccessor;
import eu.midnightdust.midnightcontrols.client.mixin.MouseAccessor;
import eu.midnightdust.midnightcontrols.client.ring.RingPage;
import eu.midnightdust.midnightcontrols.client.util.HandledScreenAccessor;
import eu.midnightdust.midnightcontrols.client.util.MathUtil;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1735;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_3979;
import net.minecraft.class_4069;
import net.minecraft.class_4264;
import net.minecraft.class_4267;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_454;
import net.minecraft.class_457;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_492;
import net.minecraft.class_500;
import net.minecraft.class_528;
import net.minecraft.class_7417;
import net.minecraft.class_746;
import org.aperlambda.lambdacommon.utils.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFWGamepadState;
import org.thinkingstudio.obsidianui.navigation.NavigationDirection;
import org.thinkingstudio.obsidianui.screen.SpruceScreen;
import org.thinkingstudio.obsidianui.widget.AbstractSprucePressableButtonWidget;
import org.thinkingstudio.obsidianui.widget.SpruceElement;
import org.thinkingstudio.obsidianui.widget.SpruceLabelWidget;
import org.thinkingstudio.obsidianui.widget.SpruceWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceEntryListWidget;
import org.thinkingstudio.obsidianui.widget.container.SpruceParentWidget;

public class MidnightInput {
    private static final Map<Integer, Integer> BUTTON_COOLDOWNS = new HashMap<Integer, Integer>();
    public int actionGuiCooldown = 0;
    public int joystickCooldown = 0;
    public boolean ignoreNextARelease = false;
    public boolean ignoreNextXRelease = false;
    private double targetYaw = 0.0;
    private double targetPitch = 0.0;
    private float prevXAxis = 0.0f;
    private float prevYAxis = 0.0f;
    private int targetMouseX = 0;
    private int targetMouseY = 0;
    private float mouseSpeedX = 0.0f;
    private float mouseSpeedY = 0.0f;
    public int inventoryInteractionCooldown = 0;
    public int screenCloseCooldown = 0;
    private ControllerControlsWidget controlsInput = null;
    MathUtil.PolarUtil polarLeft = new MathUtil.PolarUtil();
    MathUtil.PolarUtil polarRight = new MathUtil.PolarUtil();
    private double prevX = 0.0;
    private double prevY = 0.0;
    private double xValue;
    private int xState;

    public void tick(@NotNull class_310 client) {
        this.targetYaw = 0.0;
        this.targetPitch = 0.0;
        if (MidnightControlsClient.BINDING_LOOK_UP.method_1434()) {
            this.handleLook(client, 3, 0.8f, 2);
        } else if (MidnightControlsClient.BINDING_LOOK_DOWN.method_1434()) {
            this.handleLook(client, 3, 0.8f, 1);
        }
        if (MidnightControlsClient.BINDING_LOOK_LEFT.method_1434()) {
            this.handleLook(client, 2, 0.8f, 2);
        } else if (MidnightControlsClient.BINDING_LOOK_RIGHT.method_1434()) {
            this.handleLook(client, 2, 0.8f, 1);
        }
        InputManager.INPUT_MANAGER.tick(client);
    }

    public void tickController(@NotNull class_310 client) {
        boolean allowInput;
        BUTTON_COOLDOWNS.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).forEach(entry -> BUTTON_COOLDOWNS.put((Integer)entry.getKey(), (Integer)entry.getValue() - 1));
        if (this.actionGuiCooldown > 0) {
            --this.actionGuiCooldown;
        }
        if (this.screenCloseCooldown > 0) {
            --this.screenCloseCooldown;
        }
        if (this.joystickCooldown > 0) {
            --this.joystickCooldown;
        }
        InputManager.updateStates();
        Controller controller = MidnightControlsConfig.getController();
        if (controller.isConnected()) {
            GLFWGamepadState state = controller.getState();
            this.fetchButtonInput(client, state, false);
            this.fetchAxeInput(client, state, false);
        }
        MidnightControlsConfig.getSecondController().filter(Controller::isConnected).ifPresent(joycon -> {
            GLFWGamepadState state = joycon.getState();
            this.fetchButtonInput(client, state, true);
            this.fetchAxeInput(client, state, true);
        });
        boolean bl = allowInput = this.controlsInput == null || this.controlsInput.focusedBinding == null;
        if (allowInput) {
            InputManager.updateBindings(client);
        }
        if (this.controlsInput != null) {
            InputManager.STATES.forEach((num, button) -> {
                if (button.isPressed()) {
                    System.out.println(num);
                }
            });
        }
        if (this.controlsInput != null && InputManager.STATES.int2ObjectEntrySet().parallelStream().map(Map.Entry::getValue).allMatch(ButtonState::isUnpressed)) {
            System.out.println("finished");
            if (this.controlsInput.focusedBinding != null && !this.controlsInput.waiting) {
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.finishBindingEdit(buttons);
                this.controlsInput = null;
            }
        }
        if (this.inventoryInteractionCooldown > 0) {
            --this.inventoryInteractionCooldown;
        }
    }

    public void onPreRenderScreen(@NotNull class_310 client, @NotNull class_437 screen) {
        if (!MidnightInput.isScreenInteractive(screen)) {
            InputManager.INPUT_MANAGER.updateMousePosition(client);
        }
    }

    public void updateCamera(@NotNull class_310 client) {
        if (client.field_1755 != null && !(client.field_1755 instanceof TouchscreenOverlay)) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        if (this.targetYaw != 0.0 || this.targetPitch != 0.0) {
            float rotationYaw = (float)((double)client.field_1724.field_5982 + this.targetYaw * 0.175);
            float rotationPitch = (float)((double)client.field_1724.field_6004 + this.targetPitch * 0.175);
            client.field_1724.field_5982 = rotationYaw;
            client.field_1724.field_6004 = class_3532.method_15363((float)rotationPitch, (float)-90.0f, (float)90.0f);
            client.field_1724.method_36456(rotationYaw);
            client.field_1724.method_36457(class_3532.method_15363((float)rotationPitch, (float)-90.0f, (float)90.0f));
            if (client.field_1724.method_3144() && client.field_1724.method_5854() != null) {
                client.field_1724.method_5854().method_5644((class_1297)client.field_1724);
            }
            client.method_1577().method_4908(this.targetPitch, this.targetYaw);
            MidnightControlsCompat.HANDLERS.forEach(handler -> handler.handleCamera(client, this.targetYaw, this.targetPitch));
        }
    }

    public void onScreenOpen(@NotNull class_310 client, int windowWidth, int windowHeight) {
        if (client.field_1755 == null) {
            this.mouseSpeedY = 0.0f;
            this.mouseSpeedX = 0.0f;
            InputManager.INPUT_MANAGER.resetMousePosition(windowWidth, windowHeight);
        } else if (MidnightInput.isScreenInteractive(client.field_1755) && MidnightControlsConfig.virtualMouse) {
            ((MouseAccessor)client.field_1729).midnightcontrols$onCursorPos(client.method_22683().method_4490(), 0.0, 0.0);
            InputManager.INPUT_MANAGER.resetMouseTarget(client);
        }
        this.inventoryInteractionCooldown = 5;
    }

    public void beginControlsInput(ControllerControlsWidget widget) {
        this.controlsInput = widget;
        if (widget != null) {
            this.controlsInput.currentButtons.clear();
            this.controlsInput.waiting = true;
        }
    }

    private void fetchButtonInput(@NotNull class_310 client, @NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        ByteBuffer buffer = gamepadState.buttons();
        for (int i = 0; i < buffer.limit(); ++i) {
            int btn = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            boolean btnState = buffer.get() == 1;
            ButtonState state = ButtonState.NONE;
            ButtonState previousState = (ButtonState)((Object)InputManager.STATES.getOrDefault(btn, (Object)ButtonState.NONE));
            if (btnState != previousState.isPressed()) {
                state = btnState ? ButtonState.PRESS : ButtonState.RELEASE;
                this.handleButton(client, btn, btnState ? 0 : 1, btnState);
                if (btnState) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                }
            } else if (btnState) {
                state = ButtonState.REPEAT;
                if (BUTTON_COOLDOWNS.getOrDefault(btn, 0) == 0) {
                    BUTTON_COOLDOWNS.put(btn, 5);
                    this.handleButton(client, btn, 2, true);
                }
            }
            InputManager.STATES.put(btn, (Object)state);
        }
    }

    private void fetchAxeInput(@NotNull class_310 client, @NotNull GLFWGamepadState gamepadState, boolean leftJoycon) {
        FloatBuffer buffer = gamepadState.axes();
        this.polarLeft.calculate(buffer.get(0), buffer.get(1), 1.0f, MidnightControlsConfig.leftDeadZone);
        float leftX = this.polarLeft.polarX;
        float leftY = this.polarLeft.polarY;
        this.polarRight.calculate(buffer.get(2), buffer.get(3), 1.0f, MidnightControlsConfig.rightDeadZone);
        float rightX = this.polarRight.polarX;
        float rightY = this.polarRight.polarY;
        for (int i = 0; i < buffer.limit(); ++i) {
            int state;
            int axis = leftJoycon ? ButtonBinding.controller2Button(i) : i;
            float value = buffer.get();
            if (MidnightControlsConfig.analogMovement) {
                switch (i) {
                    case 0: {
                        value = leftX;
                        break;
                    }
                    case 1: {
                        value = leftY;
                    }
                }
            }
            switch (i) {
                case 2: {
                    value = rightX;
                    break;
                }
                case 3: {
                    value = rightY;
                }
            }
            float absValue = Math.abs(value);
            if (i == 1) {
                value *= -1.0f;
            }
            int n = (double)value > MidnightControlsConfig.rightDeadZone ? 1 : (state = (double)value < -MidnightControlsConfig.rightDeadZone ? 2 : 0);
            if (client.field_1755 instanceof RingScreen || MidnightControlsCompat.isEmotecraftPresent() && EmotecraftCompat.isEmotecraftScreen(client.field_1755)) continue;
            this.handleAxe(client, axis, value, absValue, state);
        }
        if (client.field_1755 instanceof RingScreen || MidnightControlsCompat.isEmotecraftPresent() && EmotecraftCompat.isEmotecraftScreen(client.field_1755)) {
            float x = leftX;
            float y = leftY;
            if (x == 0.0f && y == 0.0f) {
                x = rightX;
                y = rightY;
            }
            int index = -1;
            float border = 0.3f;
            if (x < -border) {
                index = 3;
                if (y < -border) {
                    index = 0;
                } else if (y > border) {
                    index = 5;
                }
            } else if (x > border) {
                index = 4;
                if (y < -border) {
                    index = 2;
                } else if (y > border) {
                    index = 7;
                }
            } else if (y < -border) {
                index = 1;
            } else if (y > border) {
                index = 6;
            }
            if (client.field_1755 instanceof RingScreen && index > -1) {
                RingPage.selected = index;
            }
            if (MidnightControlsCompat.isEmotecraftPresent() && EmotecraftCompat.isEmotecraftScreen(client.field_1755)) {
                EmotecraftCompat.handleEmoteSelector(index);
            }
        }
    }

    public void handleButton(@NotNull class_310 client, int button, int action, boolean state) {
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            if (action == 0 && !this.controlsInput.currentButtons.contains(button)) {
                this.controlsInput.currentButtons.add(button);
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.focusedBinding.setButton(buttons);
                this.controlsInput.waiting = false;
            }
            return;
        }
        if (client.field_1755 != null && (action == 0 || action == 2) && button == 3 && MidnightControlsConfig.arrowScreens.contains(client.field_1755.getClass().getCanonicalName())) {
            this.pressKeyboardKey(client, 257);
            this.screenCloseCooldown = 5;
        } else if (!(action != 0 && action != 2 || client.field_1755 == null || button != 11 && button != 13 && button != 14 && button != 12)) {
            if (this.actionGuiCooldown == 0) {
                switch (button) {
                    case 11: {
                        this.changeFocus(client.field_1755, NavigationDirection.UP);
                        break;
                    }
                    case 13: {
                        this.changeFocus(client.field_1755, NavigationDirection.DOWN);
                        break;
                    }
                    case 14: {
                        this.handleLeftRight(client.field_1755, false);
                        break;
                    }
                    case 12: {
                        this.handleLeftRight(client.field_1755, true);
                    }
                }
                if (MidnightControlsConfig.wasdScreens.contains(client.field_1755.getClass().getCanonicalName())) {
                    switch (button) {
                        case 11: {
                            this.pressKeyboardKey(client, 87);
                            break;
                        }
                        case 13: {
                            this.pressKeyboardKey(client, 83);
                            break;
                        }
                        case 14: {
                            this.pressKeyboardKey(client, 65);
                            break;
                        }
                        case 12: {
                            this.pressKeyboardKey(client, 68);
                        }
                    }
                }
            }
            return;
        }
        if (action == 1 && button == 0 && client.field_1755 != null && this.actionGuiCooldown == 0) {
            class_364 focused = client.field_1755.method_25399();
            if (focused != null && MidnightInput.isScreenInteractive(client.field_1755)) {
                if (this.handleAButton(client.field_1755, focused)) {
                    this.actionGuiCooldown = 5;
                    return;
                }
            } else if (FabricLoader.getInstance().isModLoaded("libgui")) {
                LibGuiCompat.handlePress(client.field_1755);
            }
        }
        if (button == 0 && client.field_1755 != null && !MidnightInput.isScreenInteractive(client.field_1755) && this.actionGuiCooldown == 0) {
            class_437 class_4372 = client.field_1755;
            if (class_4372 instanceof class_465 && ((HandledScreenAccessor)(handledScreen = (class_465)class_4372)).midnightcontrols$getSlotAt(client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480(), client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507()) != null) {
                return;
            }
            if (!this.ignoreNextARelease) {
                double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
                double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
                if (action == 0) {
                    class_437.method_25412(() -> {
                        ((MouseAccessor)client.field_1729).setLeftButtonClicked(false);
                        client.field_1755.method_25402(mouseX, mouseY, 0);
                    }, (String)"mouseClicked event handler", (String)client.field_1755.getClass().getCanonicalName());
                } else if (action == 1) {
                    class_437.method_25412(() -> {
                        ((MouseAccessor)client.field_1729).setLeftButtonClicked(false);
                        client.field_1755.method_25406(mouseX, mouseY, 0);
                    }, (String)"mouseReleased event handler", (String)client.field_1755.getClass().getCanonicalName());
                } else if (action == 2) {
                    class_437.method_25412(() -> {
                        client.field_1755.method_25398(true);
                        ((MouseAccessor)client.field_1729).setLeftButtonClicked(true);
                        ((MouseAccessor)client.field_1729).midnightcontrols$onCursorPos(client.method_22683().method_4490(), client.field_1729.method_1603(), client.field_1729.method_1604());
                        client.field_1755.method_25398(false);
                    }, (String)"mouseClicked event handler", (String)client.field_1755.getClass().getCanonicalName());
                }
                this.screenCloseCooldown = 5;
            } else {
                this.ignoreNextARelease = false;
            }
        } else if (button == 2 && client.field_1755 != null && !MidnightInput.isScreenInteractive(client.field_1755) && this.actionGuiCooldown == 0) {
            class_437 class_4373 = client.field_1755;
            if (class_4373 instanceof class_465 && ((HandledScreenAccessor)(handledScreen = (class_465)class_4373)).midnightcontrols$getSlotAt(client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480(), client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507()) != null) {
                return;
            }
            if (!this.ignoreNextXRelease) {
                double mouseX = client.field_1729.method_1603() * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480();
                double mouseY = client.field_1729.method_1604() * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507();
                if (action == 0) {
                    class_437.method_25412(() -> client.field_1755.method_25402(mouseX, mouseY, 1), (String)"mouseClicked event handler", (String)client.field_1755.getClass().getCanonicalName());
                } else if (action == 1) {
                    class_437.method_25412(() -> client.field_1755.method_25406(mouseX, mouseY, 1), (String)"mouseReleased event handler", (String)client.field_1755.getClass().getCanonicalName());
                }
                this.screenCloseCooldown = 5;
            } else {
                this.ignoreNextXRelease = false;
            }
        }
    }

    public void pressKeyboardKey(class_310 client, int key) {
        client.field_1774.method_1466(client.method_22683().method_4490(), key, 0, 1, 0);
    }

    public void pressKeyboardKey(class_437 screen, int key) {
        screen.method_25404(key, 0, 1);
    }

    public boolean tryGoBack(@NotNull class_437 screen) {
        ImmutableSet set = ImmutableSet.of((Object)"gui.back", (Object)"gui.done", (Object)"gui.cancel", (Object)"gui.toTitle", (Object)"gui.toMenu");
        return screen.method_25396().stream().filter(element -> element instanceof class_4264).map(element -> (class_4264)element).filter(element -> element.method_25369() != null && element.method_25369().method_10851() != null).anyMatch(element -> {
            class_7417 patt0$temp = element.method_25369().method_10851();
            if (patt0$temp instanceof class_2588) {
                class_2588 translatableText = (class_2588)patt0$temp;
                if (set.stream().anyMatch(key -> translatableText.method_11022().equals(key))) {
                    element.method_25306();
                    return true;
                }
            }
            return false;
        });
    }

    private double getDeadZoneValue(int axis) {
        return axis == 0 || axis == 1 ? MidnightControlsConfig.leftDeadZone : MidnightControlsConfig.rightDeadZone;
    }

    private void handleAxe(@NotNull class_310 client, int axis, float value, float absValue, int state) {
        boolean currentMinusState;
        int asButtonState;
        int n = value > 0.5f ? 1 : (asButtonState = value < -0.5f ? 2 : 0);
        if (axis == 4 || axis == 5 || axis == ButtonBinding.controller2Button(4) || axis == ButtonBinding.controller2Button(5)) {
            if (asButtonState == 2) {
                asButtonState = 0;
            } else if (MidnightControlsConfig.triggerFix) {
                value = 1.0f;
                absValue = 1.0f;
                state = 1;
                asButtonState = 1;
            }
        }
        boolean currentPlusState = (double)value > this.getDeadZoneValue(axis);
        boolean bl = currentMinusState = (double)value < -this.getDeadZoneValue(axis);
        if (axis == 4 || axis == 5) {
            currentMinusState = false;
        }
        if (!(MidnightControlsConfig.analogMovement || axis != 0 && axis != 1)) {
            currentPlusState = asButtonState == 1;
            currentMinusState = asButtonState == 2;
        }
        ButtonState previousPlusState = (ButtonState)((Object)InputManager.STATES.getOrDefault(ButtonBinding.axisAsButton(axis, true), (Object)ButtonState.NONE));
        ButtonState previousMinusState = (ButtonState)((Object)InputManager.STATES.getOrDefault(ButtonBinding.axisAsButton(axis, false), (Object)ButtonState.NONE));
        if (currentPlusState != previousPlusState.isPressed()) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, true), (Object)(currentPlusState ? ButtonState.PRESS : ButtonState.RELEASE));
            if (currentPlusState) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, true), 5);
            }
        } else if (currentPlusState) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, true), (Object)ButtonState.REPEAT);
            if (BUTTON_COOLDOWNS.getOrDefault(ButtonBinding.axisAsButton(axis, true), 0) == 0) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, true), 5);
            }
        }
        if (currentMinusState != previousMinusState.isPressed()) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, false), (Object)(currentMinusState ? ButtonState.PRESS : ButtonState.RELEASE));
            if (currentMinusState) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, false), 5);
            }
        } else if (currentMinusState) {
            InputManager.STATES.put(ButtonBinding.axisAsButton(axis, false), (Object)ButtonState.REPEAT);
            if (BUTTON_COOLDOWNS.getOrDefault(ButtonBinding.axisAsButton(axis, false), 0) == 0) {
                BUTTON_COOLDOWNS.put(ButtonBinding.axisAsButton(axis, false), 5);
            }
        }
        float axisValue = absValue;
        if (!MidnightControlsConfig.analogMovement) {
            double deadZone = this.getDeadZoneValue(axis);
            axisValue = (float)((double)absValue - deadZone);
            axisValue = (float)((double)axisValue / (1.0 - deadZone));
            axisValue = (float)((double)axisValue * deadZone);
        }
        axisValue = (float)Math.min((double)axisValue / MidnightControlsConfig.getAxisMaxValue(axis), 1.0);
        if (currentPlusState) {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, true), axisValue);
        } else {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, true), 0.0f);
        }
        if (currentMinusState) {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, false), axisValue);
        } else {
            InputManager.BUTTON_VALUES.put(ButtonBinding.axisAsButton(axis, false), 0.0f);
        }
        double deadZone = this.getDeadZoneValue(axis);
        if (this.controlsInput != null && this.controlsInput.focusedBinding != null) {
            if (asButtonState != 0 && !this.controlsInput.currentButtons.contains(ButtonBinding.axisAsButton(axis, asButtonState == 1))) {
                this.controlsInput.currentButtons.add(ButtonBinding.axisAsButton(axis, asButtonState == 1));
                int[] buttons = new int[this.controlsInput.currentButtons.size()];
                for (int i = 0; i < this.controlsInput.currentButtons.size(); ++i) {
                    buttons[i] = this.controlsInput.currentButtons.get(i);
                }
                this.controlsInput.focusedBinding.setButton(buttons);
                this.controlsInput.waiting = false;
            }
            return;
        }
        class_437 buttons = client.field_1755;
        if (buttons instanceof class_481) {
            class_481 creativeInventoryScreen = (class_481)buttons;
            if (axis == 3) {
                accessor = (CreativeInventoryScreenAccessor)creativeInventoryScreen;
                if (accessor.midnightcontrols$hasScrollbar() && (double)absValue >= deadZone) {
                    creativeInventoryScreen.method_25401(0.0, 0.0, 0.0, (double)(-value));
                }
                return;
            }
        } else {
            accessor = client.field_1755;
            if (accessor instanceof class_492) {
                class_492 merchantScreen = (class_492)accessor;
                if (axis == 3) {
                    if ((double)absValue >= deadZone) {
                        merchantScreen.method_25401(0.0, 0.0, 0.0, (double)(-(value * 1.5f)));
                    }
                    return;
                }
            } else {
                accessor = client.field_1755;
                if (accessor instanceof class_3979) {
                    class_3979 stonecutterScreen = (class_3979)accessor;
                    if (axis == 3) {
                        if ((double)absValue >= deadZone) {
                            stonecutterScreen.method_25401(0.0, 0.0, 0.0, (double)(-(value * 1.5f)));
                        }
                        return;
                    }
                } else {
                    accessor = client.field_1755;
                    if (accessor instanceof class_457) {
                        class_457 advancementsScreen = (class_457)accessor;
                        if (axis == 2 || axis == 3) {
                            accessor = (AdvancementsScreenAccessor)advancementsScreen;
                            if ((double)absValue >= deadZone) {
                                class_454 tab = accessor.getSelectedTab();
                                tab.method_2313(axis == 2 ? (double)(-value) * 5.0 : 0.0, axis == 3 ? (double)(-value) * 5.0 : 0.0);
                            }
                            return;
                        }
                    } else if (client.field_1755 != null) {
                        float finalValue = value;
                        if (axis == 3 && (double)absValue >= deadZone && client.field_1755.method_25396().stream().filter(element -> element instanceof SpruceEntryListWidget).map(element -> (SpruceEntryListWidget)element).filter(SpruceWidget::isFocusedOrHovered).noneMatch(element -> {
                            element.method_25401(0.0, 0.0, 0.0, (double)(-finalValue));
                            return true;
                        }) && client.field_1755.method_25396().stream().filter(element -> element instanceof class_350).map(element -> (class_350)element).filter(element -> element.method_37018().method_37028()).noneMatch(element -> {
                            element.method_25401(0.0, 0.0, 0.0, (double)(-finalValue));
                            return true;
                        })) {
                            client.field_1755.method_25401(0.0, 0.0, 0.0, (double)(-(value * 1.5f)));
                        } else if (MidnightInput.isScreenInteractive(client.field_1755) && (double)absValue >= deadZone) {
                            if (value > 0.0f && this.joystickCooldown == 0) {
                                switch (axis) {
                                    case 1: {
                                        this.changeFocus(client.field_1755, NavigationDirection.UP);
                                        break;
                                    }
                                    case 0: {
                                        this.handleLeftRight(client.field_1755, true);
                                    }
                                }
                                if (axis == 1 || axis == 0) {
                                    this.joystickCooldown = 4;
                                }
                            } else if (value < 0.0f && this.joystickCooldown == 0) {
                                switch (axis) {
                                    case 1: {
                                        this.changeFocus(client.field_1755, NavigationDirection.DOWN);
                                        break;
                                    }
                                    case 0: {
                                        this.handleLeftRight(client.field_1755, false);
                                    }
                                }
                                if (axis == 1 || axis == 0) {
                                    this.joystickCooldown = 4;
                                }
                            }
                            return;
                        }
                    }
                }
            }
        }
        absValue = (float)class_3532.method_15350((double)((double)absValue / MidnightControlsConfig.getAxisMaxValue(axis)), (double)0.0, (double)1.0);
        if (client.field_1755 == null) {
            this.handleLook(client, axis, absValue, state);
        } else {
            boolean allowMouseControl = true;
            if (this.actionGuiCooldown == 0 && MidnightControlsConfig.isMovementAxis(axis) && MidnightInput.isScreenInteractive(client.field_1755)) {
                if (MidnightControlsConfig.isForwardButton(axis, false, asButtonState)) {
                    allowMouseControl = this.changeFocus(client.field_1755, NavigationDirection.UP);
                } else if (MidnightControlsConfig.isBackButton(axis, false, asButtonState)) {
                    allowMouseControl = this.changeFocus(client.field_1755, NavigationDirection.DOWN);
                } else if (MidnightControlsConfig.isLeftButton(axis, false, asButtonState)) {
                    allowMouseControl = this.handleLeftRight(client.field_1755, false);
                } else if (MidnightControlsConfig.isRightButton(axis, false, asButtonState)) {
                    allowMouseControl = this.handleLeftRight(client.field_1755, true);
                }
            }
            float movementX = 0.0f;
            float movementY = 0.0f;
            if (MidnightControlsConfig.isBackButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementY = absValue;
            } else if (MidnightControlsConfig.isForwardButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementY = -absValue;
            } else if (MidnightControlsConfig.isLeftButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementX = -absValue;
            } else if (MidnightControlsConfig.isRightButton(axis, false, value > 0.0f ? 1 : 2)) {
                movementX = absValue;
            }
            if (client.field_1755 != null && allowMouseControl) {
                boolean moving;
                boolean bl2 = moving = movementY != 0.0f || movementX != 0.0f;
                if (moving) {
                    if ((double)Math.abs(this.prevXAxis) < deadZone && (double)Math.abs(this.prevYAxis) < deadZone) {
                        InputManager.INPUT_MANAGER.resetMouseTarget(client);
                    }
                    this.mouseSpeedX = movementX;
                    this.mouseSpeedY = movementY;
                } else {
                    this.mouseSpeedX = 0.0f;
                    this.mouseSpeedY = 0.0f;
                }
                if (Math.abs(this.mouseSpeedX) >= 0.05f || Math.abs(this.mouseSpeedY) >= 0.05f) {
                    InputManager.queueMoveMousePosition((double)this.mouseSpeedX * MidnightControlsConfig.mouseSpeed, (double)this.mouseSpeedY * MidnightControlsConfig.mouseSpeed);
                }
                this.moveMouseToClosestSlot(client, client.field_1755);
            }
            this.prevXAxis = movementX;
            this.prevYAxis = movementY;
        }
    }

    public boolean handleAButton(@NotNull class_437 screen, @NotNull class_364 focused) {
        if (focused instanceof class_4264) {
            class_4264 widget = (class_4264)focused;
            widget.method_25354(class_310.method_1551().method_1483());
            widget.method_25306();
            return true;
        }
        if (focused instanceof AbstractSprucePressableButtonWidget) {
            AbstractSprucePressableButtonWidget widget = (AbstractSprucePressableButtonWidget)focused;
            widget.playDownSound();
            widget.onPress();
            return true;
        }
        if (focused instanceof SpruceLabelWidget) {
            SpruceLabelWidget labelWidget = (SpruceLabelWidget)focused;
            labelWidget.onPress();
            return true;
        }
        if (focused instanceof class_528) {
            class_528 list = (class_528)focused;
            list.method_20159().ifPresent(class_528.class_4272::method_20164);
            return true;
        }
        if (focused instanceof class_4267) {
            class_4267 list = (class_4267)focused;
            class_4267.class_504 entry = (class_4267.class_504)list.method_25334();
            if (entry instanceof class_4267.class_4269 || entry instanceof class_4267.class_4270) {
                ((class_500)screen).method_2531(entry);
                ((class_500)screen).method_2536();
            }
        } else if (focused instanceof SpruceParentWidget) {
            SpruceWidget childFocused = ((SpruceParentWidget)focused).getFocused();
            if (childFocused != null) {
                return this.handleAButton(screen, (class_364)childFocused);
            }
        } else if (focused instanceof class_4069) {
            class_4069 widget = (class_4069)focused;
            class_364 childFocused = widget.method_25399();
            if (childFocused != null) {
                return this.handleAButton(screen, childFocused);
            }
        } else {
            if (FabricLoader.getInstance().isModLoaded("yet-another-config-lib") && YACLCompat.handleAButton(screen, focused)) {
                return true;
            }
            this.pressKeyboardKey(screen, 257);
        }
        return false;
    }

    private boolean handleLeftRight(@NotNull class_437 screen, boolean right) {
        if (screen instanceof SpruceScreen) {
            SpruceScreen spruceScreen = (SpruceScreen)screen;
            spruceScreen.onNavigation(right ? NavigationDirection.RIGHT : NavigationDirection.LEFT, false);
            this.actionGuiCooldown = 5;
            return false;
        }
        if (FabricLoader.getInstance().isModLoaded("yet-another-config-lib") && YACLCompat.handleLeftRight(screen, right)) {
            this.actionGuiCooldown = 5;
            return false;
        }
        class_364 focused = screen.method_25399();
        if (focused != null && this.handleRightLeftElement(focused, right)) {
            return this.changeFocus(screen, right ? NavigationDirection.RIGHT : NavigationDirection.LEFT);
        }
        return true;
    }

    private boolean handleRightLeftElement(@NotNull class_364 element, boolean right) {
        if (element instanceof SpruceElement) {
            SpruceElement spruceElement = (SpruceElement)element;
            if (spruceElement.requiresCursor()) {
                return true;
            }
            return !spruceElement.onNavigation(right ? NavigationDirection.RIGHT : NavigationDirection.LEFT, false);
        }
        if (element instanceof class_357) {
            class_357 slider = (class_357)element;
            if (slider.field_22763) {
                slider.method_25404(right ? 262 : 263, 0, 0);
                this.actionGuiCooldown = 2;
                return true;
            }
        } else {
            if (element instanceof class_4280) {
                return false;
            }
            if (element instanceof class_4069) {
                class_4069 entryList = (class_4069)element;
                class_364 focused = entryList.method_25399();
                if (focused == null) {
                    return true;
                }
                return this.handleRightLeftElement(focused, right);
            }
        }
        return true;
    }

    public void handleLook(@NotNull class_310 client, int axis, float value, int state) {
        if (client.field_1724 == null) {
            return;
        }
        if (MidnightControlsConfig.cameraMode == CameraMode.FLAT) {
            double powValue = Math.pow(value, 2.0);
            if (axis == 3) {
                if (state == 2) {
                    this.targetPitch = -MidnightControlsConfig.getRightYAxisSign() * (MidnightControlsConfig.yAxisRotationSpeed * powValue) * 0.11;
                } else if (state == 1) {
                    this.targetPitch = MidnightControlsConfig.getRightYAxisSign() * (MidnightControlsConfig.yAxisRotationSpeed * powValue) * 0.11;
                }
            }
            if (axis == 2) {
                if (state == 2) {
                    this.targetYaw = -MidnightControlsConfig.getRightXAxisSign() * (MidnightControlsConfig.rotationSpeed * powValue) * 0.11;
                } else if (state == 1) {
                    this.targetYaw = MidnightControlsConfig.getRightXAxisSign() * (MidnightControlsConfig.rotationSpeed * powValue) * 0.11;
                }
            }
            return;
        }
        if (axis == 2) {
            this.xValue = value;
            this.xState = state;
            return;
        }
        if (axis == 3 && client.field_1724 != null) {
            double yStep = MidnightControlsConfig.yAxisRotationSpeed / 100.0 * (double)0.6f + (double)0.2f;
            double xStep = MidnightControlsConfig.rotationSpeed / 100.0 * (double)0.6f + (double)0.2f;
            double cursorDeltaX = 2.0 * this.xValue - this.prevX;
            double cursorDeltaY = (double)(2.0f * value) - this.prevY;
            boolean slowdown = client.field_1690.method_31044().method_31034() && client.field_1724.method_31550();
            double x = cursorDeltaX * xStep * (slowdown ? xStep : 1.0);
            double y = cursorDeltaY * yStep * (slowdown ? yStep : 1.0);
            double powXValue = Math.pow(x, 2.0);
            double powYValue = Math.pow(y, 2.0);
            if (state == 2) {
                this.targetPitch = -MidnightControlsConfig.getRightYAxisSign() * (MidnightControlsConfig.yAxisRotationSpeed * powYValue) * 0.11;
            } else if (state == 1) {
                this.targetPitch = MidnightControlsConfig.getRightYAxisSign() * (MidnightControlsConfig.yAxisRotationSpeed * powYValue) * 0.11;
            }
            if (this.xState == 2) {
                this.targetYaw = -MidnightControlsConfig.getRightXAxisSign() * (MidnightControlsConfig.rotationSpeed * powXValue) * 0.11;
            } else if (this.xState == 1) {
                this.targetYaw = MidnightControlsConfig.getRightXAxisSign() * (MidnightControlsConfig.rotationSpeed * powXValue) * 0.11;
            }
            this.prevY = value;
            this.prevX = this.xValue;
        }
    }

    private boolean changeFocus(@NotNull class_437 screen, NavigationDirection direction) {
        if (!MidnightInput.isScreenInteractive(screen) && !screen.getClass().getCanonicalName().contains("me.jellysquid.mods.sodium.client.gui")) {
            return false;
        }
        try {
            if (screen instanceof SpruceScreen) {
                SpruceScreen spruceScreen = (SpruceScreen)screen;
                if (spruceScreen.onNavigation(direction, false)) {
                    this.actionGuiCooldown = 5;
                }
                return false;
            }
            switch (direction) {
                case UP: {
                    this.pressKeyboardKey(screen, 265);
                    break;
                }
                case DOWN: {
                    this.pressKeyboardKey(screen, 264);
                    break;
                }
                case LEFT: {
                    this.pressKeyboardKey(screen, 263);
                    break;
                }
                case RIGHT: {
                    this.pressKeyboardKey(screen, 262);
                }
            }
            this.actionGuiCooldown = 5;
            return false;
        }
        catch (Exception exception) {
            MidnightControls.get().warn("Unknown exception encountered while trying to change focus: " + String.valueOf(exception));
            return false;
        }
    }

    public static boolean isScreenInteractive(@NotNull class_437 screen) {
        return !(screen instanceof class_465) && !MidnightControlsConfig.joystickAsMouse && !MidnightControlsConfig.mouseScreens.stream().anyMatch(a -> screen.getClass().toString().contains((CharSequence)a)) && (!(screen instanceof SpruceScreen) || !((SpruceScreen)screen).requiresCursor()) && !MidnightControlsCompat.requireMouseOnScreen(screen);
    }

    private void moveMouseToClosestSlot(@NotNull class_310 client, @Nullable class_437 screen) {
        if (screen instanceof class_465) {
            class_465 inventoryScreen = (class_465)screen;
            HandledScreenAccessor accessor = (HandledScreenAccessor)inventoryScreen;
            int guiLeft = accessor.getX();
            int guiTop = accessor.getY();
            int mouseX = (int)((double)this.targetMouseX * (double)client.method_22683().method_4486() / (double)client.method_22683().method_4480());
            int mouseY = (int)((double)this.targetMouseY * (double)client.method_22683().method_4502() / (double)client.method_22683().method_4507());
            Optional<Pair> closestSlot = inventoryScreen.method_17577().field_7761.parallelStream().map(slot -> {
                int x = guiLeft + slot.field_7873 + 8;
                int y = guiTop + slot.field_7872 + 8;
                double distance = Math.sqrt(Math.pow(x - mouseX, 2.0) + Math.pow(y - mouseY, 2.0));
                return Pair.of((Object)slot, (Object)distance);
            }).filter(entry -> (Double)entry.value <= 14.0).min(Comparator.comparingDouble(p -> (Double)p.value));
            if (closestSlot.isPresent()) {
                class_1735 slot2 = (class_1735)closestSlot.get().key;
                if (slot2.method_7681() || !client.field_1724.method_31548().method_7391().method_7960()) {
                    int slotCenterXScaled = guiLeft + slot2.field_7873 + 8;
                    int slotCenterYScaled = guiTop + slot2.field_7872 + 8;
                    int slotCenterX = (int)((double)slotCenterXScaled / ((double)client.method_22683().method_4486() / (double)client.method_22683().method_4480()));
                    int slotCenterY = (int)((double)slotCenterYScaled / ((double)client.method_22683().method_4502() / (double)client.method_22683().method_4507()));
                    double deltaX = slotCenterX - this.targetMouseX;
                    double deltaY = slotCenterY - this.targetMouseY;
                    if (mouseX != slotCenterXScaled || mouseY != slotCenterYScaled) {
                        this.targetMouseX = (int)((double)this.targetMouseX + deltaX * 0.75);
                        this.targetMouseY = (int)((double)this.targetMouseY + deltaY * 0.75);
                    } else {
                        this.mouseSpeedX *= 0.3f;
                        this.mouseSpeedY *= 0.3f;
                    }
                    this.mouseSpeedX *= 0.75f;
                    this.mouseSpeedY *= 0.75f;
                } else {
                    this.mouseSpeedX *= 0.1f;
                    this.mouseSpeedY *= 0.1f;
                }
            } else {
                this.mouseSpeedX *= 0.3f;
                this.mouseSpeedY *= 0.3f;
            }
        } else {
            this.mouseSpeedX = 0.0f;
            this.mouseSpeedY = 0.0f;
        }
    }
}

