/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.client.controller;

import eu.midnightdust.midnightcontrols.MidnightControls;
import eu.midnightdust.midnightcontrols.client.MidnightControlsClient;
import eu.midnightdust.midnightcontrols.client.MidnightControlsConfig;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import org.aperlambda.lambdacommon.utils.Nameable;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWGamepadState;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public record Controller(int id) implements Nameable
{
    private static final Map<Integer, Controller> CONTROLLERS = new HashMap<Integer, Controller>();

    public String getGuid() {
        String guid = GLFW.glfwGetJoystickGUID((int)this.id);
        return guid == null ? "" : guid;
    }

    public boolean isConnected() {
        return GLFW.glfwJoystickPresent((int)this.id);
    }

    public boolean isGamepad() {
        return this.isConnected() && GLFW.glfwJoystickIsGamepad((int)this.id);
    }

    @NotNull
    public String getName() {
        String name = this.isGamepad() ? GLFW.glfwGetGamepadName((int)this.id) : GLFW.glfwGetJoystickName((int)this.id);
        return name == null ? String.valueOf(this.id()) : name;
    }

    public GLFWGamepadState getState() {
        GLFWGamepadState state = GLFWGamepadState.create();
        if (this.isGamepad()) {
            GLFW.glfwGetGamepadState((int)this.id, (GLFWGamepadState)state);
        }
        return state;
    }

    public static Controller byId(int id) {
        if (id > 15) {
            MidnightControlsClient.get().log("Controller '" + id + "' doesn't exist.");
            id = 15;
        }
        if (CONTROLLERS.containsKey(id)) {
            return CONTROLLERS.get(id);
        }
        Controller controller = new Controller(id);
        CONTROLLERS.put(id, controller);
        return controller;
    }

    public static Optional<Controller> byGuid(@NotNull String guid) {
        return CONTROLLERS.values().stream().filter(Controller::isConnected).filter(controller -> controller.getGuid().equals(guid)).max(Comparator.comparingInt(Controller::id));
    }

    private static ByteBuffer ioResourceToBuffer(String resource, int bufferSize) throws IOException {
        ByteBuffer buffer = null;
        Path path = Paths.get(resource, new String[0]);
        if (Files.isReadable(path)) {
            try (SeekableByteChannel fc = Files.newByteChannel(path, new OpenOption[0]);){
                buffer = BufferUtils.createByteBuffer((int)((int)fc.size() + 2));
                while (fc.read(buffer) != -1) {
                }
                buffer.put((byte)0);
            }
        }
        if (buffer != null) {
            buffer.flip();
        }
        return buffer;
    }

    public static void updateMappings() {
        CompletableFuture.supplyAsync(Controller::updateMappingsSync);
    }

    private static boolean updateMappingsSync() {
        try {
            ByteBuffer database;
            MidnightControlsClient.get().log("Updating controller mappings...");
            Optional<File> databaseFile = Controller.getDatabaseFile();
            if (databaseFile.isPresent() && (database = Controller.ioResourceToBuffer(databaseFile.get().getPath(), 1024)) != null) {
                GLFW.glfwUpdateGamepadMappings((ByteBuffer)database);
            }
            if (!MidnightControlsClient.MAPPINGS_FILE.exists()) {
                return false;
            }
            ByteBuffer buffer = Controller.ioResourceToBuffer(MidnightControlsClient.MAPPINGS_FILE.getPath(), 1024);
            if (buffer != null) {
                GLFW.glfwUpdateGamepadMappings((ByteBuffer)buffer);
            }
        }
        catch (IOException e) {
            e.fillInStackTrace();
        }
        try (MemoryStack memoryStack2 = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack2.mallocPointer(1);
            int i = GLFW.glfwGetError((PointerBuffer)pointerBuffer);
            if (i != 0) {
                long l = pointerBuffer.get();
                String string = l == 0L ? "" : MemoryUtil.memUTF8((long)l);
                class_310 client = class_310.method_1551();
                if (client != null) {
                    client.method_1566().method_1999((class_368)class_370.method_29047((class_310)client, (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"midnightcontrols.controller.mappings.error"), (class_2561)class_2561.method_43470((String)string)));
                }
                MidnightControls.get().log(class_1074.method_4662((String)"midnightcontrols.controller.mappings.error", (Object[])new Object[0]) + string);
            }
        }
        catch (Throwable memoryStack2) {
            // empty catch block
        }
        if (MidnightControlsConfig.debug) {
            for (int i = 0; i <= 15; ++i) {
                Controller controller = Controller.byId(i);
                if (!controller.isConnected()) continue;
                MidnightControls.get().log(String.format("Controller #%d name: \"%s\"\n GUID: %s\n Gamepad: %s", controller.id, controller.getName(), controller.getGuid(), controller.isGamepad()));
            }
        }
        return true;
    }

    private static Optional<File> getDatabaseFile() {
        File databaseFile = new File("config/gamecontrollerdatabase.txt");
        try {
            int bytesRead;
            BufferedInputStream in = new BufferedInputStream(new URL("https://raw.githubusercontent.com/gabomdq/SDL_GameControllerDB/master/gamecontrollerdb.txt").openStream());
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(databaseFile));
            byte[] dataBuffer = new byte[1024];
            while ((bytesRead = in.read(dataBuffer, 0, 1024)) != -1) {
                out.write(dataBuffer, 0, bytesRead);
            }
            out.close();
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return Optional.of(databaseFile);
    }
}

