/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraftforge.fml.loading.ClasspathLocatorUtils;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.AbstractJarFileModLocator;
import org.slf4j.Logger;

public class ClasspathLocator
extends AbstractJarFileModLocator {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<Path> legacyClasspath = AbstractJarFileModLocator.getLegacyClasspath();
    private boolean enabled = false;

    public String name() {
        return "userdev classpath";
    }

    @Override
    public Stream<Path> scanCandidates() {
        if (!this.enabled) {
            return Stream.of(new Path[0]);
        }
        try {
            ArrayList<Path> claimed = new ArrayList<Path>(this.legacyClasspath);
            Stream.Builder paths = Stream.builder();
            this.findPaths(claimed, "META-INF/mods.toml").forEach(paths::add);
            this.findPaths(claimed, "META-INF/MANIFEST.MF").forEach(paths::add);
            return paths.build();
        }
        catch (IOException e) {
            LOGGER.error(LogMarkers.SCAN, "Error trying to find resources", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List<Path> findPaths(List<Path> claimed, String resource) throws IOException {
        ArrayList<Path> ret = new ArrayList<Path>();
        Enumeration<URL> resources = ClassLoader.getSystemClassLoader().getResources(resource);
        while (resources.hasMoreElements()) {
            URL url = resources.nextElement();
            Path path = ClasspathLocatorUtils.findJarPathFor(resource, resource, url);
            if (claimed.stream().anyMatch(path::equals) || !Files.exists(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) continue;
            ret.add(path);
        }
        return ret;
    }

    public void initArguments(Map<String, ?> arguments) {
        String launchTarget = (String)arguments.get("launchTarget");
        this.enabled = launchTarget != null && launchTarget.contains("dev");
    }

    private Path findJarPathFor(String resourceName, String jarName, URL resource) {
        try {
            Path path;
            URI uri = resource.toURI();
            if (uri.getScheme().equals("jar") && uri.getRawSchemeSpecificPart().contains("!/")) {
                int lastExcl = uri.getRawSchemeSpecificPart().lastIndexOf("!/");
                path = Paths.get(new URI(uri.getRawSchemeSpecificPart().substring(0, lastExcl)));
            } else {
                path = Paths.get(new URI("file://" + uri.getRawSchemeSpecificPart().substring(0, uri.getRawSchemeSpecificPart().length() - resourceName.length())));
            }
            return path;
        }
        catch (NullPointerException | URISyntaxException e) {
            LOGGER.error(LogMarkers.SCAN, "Failed to find JAR for class {} - {}", (Object)resourceName, (Object)jarName);
            throw new RuntimeException("Unable to locate " + resourceName + " - " + jarName, e);
        }
    }
}

