/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.Lists;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntry;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.ForgeHooks;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;

public class LootPool {
    final LootPoolEntryContainer[] f_79023_;
    final LootItemCondition[] f_79024_;
    private final Predicate<LootContext> f_79025_;
    final LootItemFunction[] f_79026_;
    private final BiFunction<ItemStack, LootContext, ItemStack> f_79027_;
    NumberProvider f_79028_;
    NumberProvider f_79029_;
    private boolean isFrozen = false;
    @Nullable
    private final String name;

    LootPool(LootPoolEntryContainer[] pEntries, LootItemCondition[] pConditions, LootItemFunction[] pFunctions, NumberProvider pRolls, NumberProvider pBonusRolls, @Nullable String name) {
        this.name = name;
        this.f_79023_ = pEntries;
        this.f_79024_ = pConditions;
        this.f_79025_ = LootItemConditions.m_81834_((Predicate[])pConditions);
        this.f_79026_ = pFunctions;
        this.f_79027_ = LootItemFunctions.m_80770_((BiFunction[])pFunctions);
        this.f_79028_ = pRolls;
        this.f_79029_ = pBonusRolls;
    }

    private void m_79058_(Consumer<ItemStack> p_79059_, LootContext p_79060_) {
        RandomSource randomsource = p_79060_.m_230907_();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        for (LootPoolEntryContainer lootpoolentrycontainer : this.f_79023_) {
            lootpoolentrycontainer.m_6562_(p_79060_, p_79048_ -> {
                int k = p_79048_.m_7067_(p_79060_.m_78945_());
                if (k > 0) {
                    list.add(p_79048_);
                    mutableint.add(k);
                }
            });
        }
        int i = list.size();
        if (mutableint.intValue() != 0 && i != 0) {
            if (i == 1) {
                ((LootPoolEntry)list.get(0)).m_6941_(p_79059_, p_79060_);
            } else {
                int j = randomsource.m_188503_(mutableint.intValue());
                for (LootPoolEntry lootpoolentry : list) {
                    if ((j -= lootpoolentry.m_7067_(p_79060_.m_78945_())) >= 0) continue;
                    lootpoolentry.m_6941_(p_79059_, p_79060_);
                    return;
                }
            }
        }
    }

    public void m_79053_(Consumer<ItemStack> p_79054_, LootContext p_79055_) {
        if (this.f_79025_.test(p_79055_)) {
            Consumer consumer = LootItemFunction.m_80724_(this.f_79027_, p_79054_, (LootContext)p_79055_);
            int i = this.f_79028_.m_142683_(p_79055_) + Mth.m_14143_((float)(this.f_79029_.m_142688_(p_79055_) * p_79055_.m_78945_()));
            for (int j = 0; j < i; ++j) {
                this.m_79058_(consumer, p_79055_);
            }
        }
    }

    public void m_79051_(ValidationContext p_79052_) {
        for (int i = 0; i < this.f_79024_.length; ++i) {
            this.f_79024_[i].m_6169_(p_79052_.m_79365_(".condition[" + i + "]"));
        }
        for (int j = 0; j < this.f_79026_.length; ++j) {
            this.f_79026_[j].m_6169_(p_79052_.m_79365_(".functions[" + j + "]"));
        }
        for (int k = 0; k < this.f_79023_.length; ++k) {
            this.f_79023_[k].m_6165_(p_79052_.m_79365_(".entries[" + k + "]"));
        }
        this.f_79028_.m_6169_(p_79052_.m_79365_(".rolls"));
        this.f_79029_.m_6169_(p_79052_.m_79365_(".bonusRolls"));
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    private void checkFrozen() {
        if (this.isFrozen()) {
            throw new RuntimeException("Attempted to modify LootPool after being frozen!");
        }
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public NumberProvider getRolls() {
        return this.f_79028_;
    }

    public NumberProvider getBonusRolls() {
        return this.f_79029_;
    }

    public void setRolls(NumberProvider v) {
        this.checkFrozen();
        this.f_79028_ = v;
    }

    public void setBonusRolls(NumberProvider v) {
        this.checkFrozen();
        this.f_79029_ = v;
    }

    public static Builder m_79043_() {
        return new Builder();
    }

    public static class Builder
    implements FunctionUserBuilder<Builder>,
    ConditionUserBuilder<Builder> {
        private final List<LootPoolEntryContainer> f_79067_ = Lists.newArrayList();
        private final List<LootItemCondition> f_79068_ = Lists.newArrayList();
        private final List<LootItemFunction> f_79069_ = Lists.newArrayList();
        private NumberProvider f_79070_ = ConstantValue.m_165692_((float)1.0f);
        private NumberProvider f_79071_ = ConstantValue.m_165692_((float)0.0f);
        private String name;

        public Builder m_165133_(NumberProvider p_165134_) {
            this.f_79070_ = p_165134_;
            return this;
        }

        public Builder m_79073_() {
            return this;
        }

        public Builder m_165135_(NumberProvider p_165136_) {
            this.f_79071_ = p_165136_;
            return this;
        }

        public Builder m_79076_(LootPoolEntryContainer.Builder<?> p_79077_) {
            this.f_79067_.add(p_79077_.m_7512_());
            return this;
        }

        public Builder m_79080_(LootItemCondition.Builder p_79081_) {
            this.f_79068_.add(p_79081_.m_6409_());
            return this;
        }

        public Builder m_79078_(LootItemFunction.Builder p_79079_) {
            this.f_79069_.add(p_79079_.m_7453_());
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public LootPool m_79082_() {
            if (this.f_79070_ == null) {
                throw new IllegalArgumentException("Rolls not set");
            }
            return new LootPool(this.f_79067_.toArray(new LootPoolEntryContainer[0]), this.f_79068_.toArray(new LootItemCondition[0]), this.f_79069_.toArray(new LootItemFunction[0]), this.f_79070_, this.f_79071_, this.name);
        }
    }

    public static class Serializer
    implements JsonDeserializer<LootPool>,
    JsonSerializer<LootPool> {
        public LootPool deserialize(JsonElement p_79090_, Type p_79091_, JsonDeserializationContext p_79092_) throws JsonParseException {
            JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)p_79090_, (String)"loot pool");
            LootPoolEntryContainer[] alootpoolentrycontainer = (LootPoolEntryContainer[])GsonHelper.m_13836_((JsonObject)jsonobject, (String)"entries", (JsonDeserializationContext)p_79092_, LootPoolEntryContainer[].class);
            LootItemCondition[] alootitemcondition = (LootItemCondition[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"conditions", (Object)new LootItemCondition[0], (JsonDeserializationContext)p_79092_, LootItemCondition[].class);
            LootItemFunction[] alootitemfunction = (LootItemFunction[])GsonHelper.m_13845_((JsonObject)jsonobject, (String)"functions", (Object)new LootItemFunction[0], (JsonDeserializationContext)p_79092_, LootItemFunction[].class);
            NumberProvider numberprovider = (NumberProvider)GsonHelper.m_13836_((JsonObject)jsonobject, (String)"rolls", (JsonDeserializationContext)p_79092_, NumberProvider.class);
            NumberProvider numberprovider1 = (NumberProvider)GsonHelper.m_13845_((JsonObject)jsonobject, (String)"bonus_rolls", (Object)ConstantValue.m_165692_((float)0.0f), (JsonDeserializationContext)p_79092_, NumberProvider.class);
            return new LootPool(alootpoolentrycontainer, alootitemcondition, alootitemfunction, numberprovider, numberprovider1, ForgeHooks.readPoolName((JsonObject)jsonobject));
        }

        public JsonElement serialize(LootPool p_79094_, Type p_79095_, JsonSerializationContext p_79096_) {
            JsonObject jsonobject = new JsonObject();
            if (p_79094_.name != null && !p_79094_.name.startsWith("custom#")) {
                jsonobject.add("name", p_79096_.serialize((Object)p_79094_.name));
            }
            jsonobject.add("rolls", p_79096_.serialize((Object)p_79094_.f_79028_));
            jsonobject.add("bonus_rolls", p_79096_.serialize((Object)p_79094_.f_79029_));
            jsonobject.add("entries", p_79096_.serialize((Object)p_79094_.f_79023_));
            if (!ArrayUtils.isEmpty((Object[])p_79094_.f_79024_)) {
                jsonobject.add("conditions", p_79096_.serialize((Object)p_79094_.f_79024_));
            }
            if (!ArrayUtils.isEmpty((Object[])p_79094_.f_79026_)) {
                jsonobject.add("functions", p_79096_.serialize((Object)p_79094_.f_79026_));
            }
            return jsonobject;
        }
    }
}

