/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.google.common.collect.Sets;
import com.supermartijn642.fusion.extensions.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PathPackResources.class})
public class ForgePathPackResourcesMixin
implements PackResourcesExtension {
    @Final
    @Shadow(remap=false)
    private static Logger LOGGER;
    @Final
    @Shadow(remap=false)
    private Path source;
    @Unique
    private String overridesFolderName;

    @Override
    public void setFusionOverridesFolder(@NotNull String folder) {
        this.overridesFolderName = folder;
    }

    @Shadow(remap=false)
    private static String[] getPathFromLocation(PackType type, ResourceLocation location) {
        throw new AssertionError();
    }

    @Shadow(remap=false)
    private Path resolve(String ... paths) {
        throw new AssertionError();
    }

    @Inject(method={"getResource(Lnet/minecraft/server/packs/PackType;Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/server/packs/resources/IoSupplier;"}, at={@At(value="HEAD")}, cancellable=true)
    private void getResource(PackType type, ResourceLocation location, CallbackInfoReturnable<IoSupplier<InputStream>> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        String[] pathParts = ForgePathPackResourcesMixin.getPathFromLocation(location.m_135815_().startsWith("lang/") ? PackType.CLIENT_RESOURCES : type, location);
        String[] overridePathParts = new String[pathParts.length + 1];
        overridePathParts[0] = this.overridesFolderName;
        System.arraycopy(pathParts, 0, overridePathParts, 1, pathParts.length);
        Path path = this.resolve(overridePathParts);
        if (Files.exists(path, new LinkOption[0])) {
            ci.setReturnValue((Object)IoSupplier.m_246697_((Path)path));
        }
    }

    @Inject(method={"getNamespaces"}, at={@At(value="RETURN")}, cancellable=true)
    private void getNamespaces(PackType type, CallbackInfoReturnable<Set<String>> ci) {
        if (this.overridesFolderName == null) {
            return;
        }
        HashSet namespaces = Sets.newHashSet((Iterable)((Iterable)ci.getReturnValue()));
        Path typeFolder = this.resolve(this.overridesFolderName, type.m_10305_());
        try (Stream<Path> walker2 = Files.walk(typeFolder, 1, new FileVisitOption[0]);){
            walker2.filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).map(typeFolder::relativize).filter(p -> p.getNameCount() > 0).map(p -> p.toString().replaceAll("/$", "")).filter(s -> !s.isEmpty()).forEach(namespaces::add);
        }
        catch (NoSuchFileException walker2) {
        }
        catch (IOException e) {
            LOGGER.error("Failed to walk path {}", (Object)typeFolder, (Object)e);
        }
        ci.setReturnValue((Object)namespaces);
    }

    @ModifyVariable(method={"listResources"}, at=@At(value="HEAD"), ordinal=0)
    private PackResources.ResourceOutput modifyListResources(PackResources.ResourceOutput output, PackType type, String namespace, String path) {
        if (this.overridesFolderName == null) {
            return output;
        }
        HashSet overriddenLocations = new HashSet();
        FileUtil.m_245538_((String)path).get().ifLeft(list -> {
            Path namespaceFolder = this.resolve(this.overridesFolderName, type.m_10305_(), namespace).toAbsolutePath();
            net.minecraft.server.packs.PathPackResources.m_246914_((String)namespace, (Path)namespaceFolder, (List)list, (location, streamSupplier) -> {
                overriddenLocations.add(location);
                output.accept(location, streamSupplier);
            });
        }).ifRight(partialResult -> LOGGER.error("Invalid path {}: {}", (Object)path, (Object)partialResult.message()));
        return (location, streamSupplier) -> {
            if (!overriddenLocations.contains(location)) {
                output.accept(location, streamSupplier);
            }
        };
    }
}

