/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.BossMonsters;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.BossMonsters.AI.SimpleAnimationGoal;
import com.github.L_Ender.cataclysm.entity.BossMonsters.Boss_monster;
import com.github.L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import com.github.L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import com.github.L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import com.github.L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import com.github.L_Ender.cataclysm.init.ModEffect;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.sniffer.Sniffer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class Ancient_Remnant_Entity
extends Boss_monster {
    public static final Animation REMNANT_BITE1 = Animation.create((int)69);
    public static final Animation REMNANT_BITE2 = Animation.create((int)65);
    public static final Animation REMNANT_CHARGE_PREPARE = Animation.create((int)125);
    public static final Animation REMNANT_TAIL_ATTACK1 = Animation.create((int)57);
    private static final EntityDataAccessor<Boolean> CHARGE = SynchedEntityData.m_135353_(Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> MODE_CHANCE = SynchedEntityData.m_135353_(Ancient_Remnant_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private AttackMode mode = AttackMode.CIRCLE;
    public float chargeProgress;
    public float prevchargeProgress;
    private int hunting_cooldown = 160;
    public int frame;
    public static final int MINE_COOLDOWN = 100;

    public Ancient_Remnant_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.f_21364_ = 15;
        this.m_274367_(1.5f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        Ancient_Remnant_Entity.setConfigattribute((LivingEntity)this, CMConfig.AncientRemnantHealthMultiplier, CMConfig.AncientRemnantDamageMultiplier);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, REMNANT_BITE1, REMNANT_CHARGE_PREPARE, REMNANT_BITE2, REMNANT_TAIL_ATTACK1};
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RemnantAttackGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RemnantChargeAttackGoal(this, REMNANT_CHARGE_PREPARE));
        this.f_21345_.m_25352_(0, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_BITE1, 29));
        this.f_21345_.m_25352_(0, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_BITE2, 25));
        this.f_21345_.m_25352_(0, (Goal)new RemnantAnimationAttackGoal(this, REMNANT_TAIL_ATTACK1, 13));
        this.f_21345_.m_25352_(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0, 80));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Sniffer.class, true));
    }

    public static AttributeSupplier.Builder ancient_ramant() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 70.0).m_22268_(Attributes.f_22279_, (double)0.33f).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected int m_7302_(int air) {
        return air;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public ItemEntity m_19983_(ItemStack stack) {
        ItemEntity itementity = this.m_5552_(stack, 0.0f);
        if (itementity != null) {
            itementity.m_146915_(true);
            itementity.m_32064_();
        }
        return itementity;
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        double range;
        if (!source.m_269533_(DamageTypeTags.f_268738_)) {
            damage = Math.min((float)CMConfig.AncientRemnantDamageCap, damage);
        }
        if ((range = this.calculateRange(source)) > CMConfig.AncientRemnantLongRangelimit * CMConfig.AncientRemnantLongRangelimit) {
            return false;
        }
        return super.m_6469_(source, damage);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGE, (Object)false);
        this.f_19804_.m_135372_(MODE_CHANCE, (Object)0);
    }

    public int getModeChance() {
        return (Integer)this.f_19804_.m_135370_(MODE_CHANCE);
    }

    public void setModeChance(int chance) {
        this.f_19804_.m_135381_(MODE_CHANCE, (Object)chance);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    public void setIsCharge(boolean isAnger) {
        this.f_19804_.m_135381_(CHARGE, (Object)isAnger);
    }

    public boolean getIsCharge() {
        return (Boolean)this.f_19804_.m_135370_(CHARGE);
    }

    public void m_8119_() {
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        this.prevchargeProgress = this.chargeProgress;
        if (this.getIsCharge() && this.chargeProgress < 3.0f) {
            this.chargeProgress += 1.0f;
        }
        if (!this.getIsCharge() && this.chargeProgress > 0.0f) {
            this.chargeProgress -= 1.0f;
        }
        if (this.hunting_cooldown > 0) {
            --this.hunting_cooldown;
        }
        this.Charge();
        ++this.frame;
        float moveX = (float)(this.m_20185_() - this.f_19854_);
        float moveZ = (float)(this.m_20189_() - this.f_19856_);
        float speed = Mth.m_14116_((float)(moveX * moveX + moveZ * moveZ));
        if (!this.m_20067_() && this.frame % 8 == 1 && (double)speed > 0.05 && this.getIsCharge() && this.m_20096_()) {
            this.m_5496_((SoundEvent)ModSounds.REMNANT_CHARGE_STEP.get(), 1.0f, 1.0f);
            ScreenShake_Entity.ScreenShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.1f, 0, 10);
        }
    }

    private void Charge() {
        if (this.getIsCharge()) {
            if (!this.m_9236_().f_46443_) {
                if (CMConfig.AncientRemnantBlockBreaking) {
                    this.ChargeBlockBreaking();
                } else if (ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this)) {
                    this.ChargeBlockBreaking();
                }
            }
            if (this.f_19797_ % 4 == 0) {
                for (LivingEntity Lentity : this.m_9236_().m_45976_(LivingEntity.class, this.m_20191_().m_82400_(1.5))) {
                    boolean flag;
                    if (this.m_7307_((Entity)Lentity) || Lentity instanceof Ancient_Remnant_Entity || Lentity == this || !(flag = Lentity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((double)((float)this.m_21133_(Attributes.f_22281_) * 1.5f) + Math.min(this.m_21133_(Attributes.f_22281_) * 1.5, (double)Lentity.m_21233_() * CMConfig.HarbingerChargeHpDamage)))) || !Lentity.m_20096_()) continue;
                    double d0 = Lentity.m_20185_() - this.m_20185_();
                    double d1 = Lentity.m_20189_() - this.m_20189_();
                    double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
                    float f = 1.5f;
                    Lentity.m_5997_(d0 / d2 * (double)f, 0.5, d1 / d2 * (double)f);
                }
            }
        }
    }

    private void ChargeBlockBreaking() {
        boolean flag = false;
        AABB aabb = this.m_20191_().m_82377_(0.5, 0.2, 0.5);
        for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)this.m_20186_()), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
            BlockState blockstate = this.m_9236_().m_8055_(blockpos);
            if (blockstate == Blocks.f_50016_.m_49966_() || !blockstate.canEntityDestroy((BlockGetter)this.m_9236_(), blockpos, (Entity)this) || blockstate.m_204336_(ModTag.REMNANT_IMMUNE) || !ForgeEventFactory.onEntityDestroyBlock((LivingEntity)this, (BlockPos)blockpos, (BlockState)blockstate)) continue;
            if (this.f_19796_.m_188503_(6) == 0 && !blockstate.m_155947_()) {
                Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.m_9236_(), (double)blockpos.m_123341_() + 0.5, (double)blockpos.m_123342_() + 0.5, (double)blockpos.m_123343_() + 0.5, blockstate, 20);
                flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
                fallingBlockEntity.m_20256_(fallingBlockEntity.m_20184_().m_82549_(this.m_20182_().m_82546_(fallingBlockEntity.m_20182_()).m_82542_((-1.2 + this.f_19796_.m_188500_()) / 3.0, 0.2 + this.m_217043_().m_188583_() * 0.15, (-1.2 + this.f_19796_.m_188500_()) / 3.0)));
                this.m_9236_().m_7967_((Entity)fallingBlockEntity);
                continue;
            }
            flag = this.m_9236_().m_46953_(blockpos, false, (Entity)this) || flag;
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == REMNANT_BITE1) {
            if (this.getAnimationTick() == 5) {
                this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BITE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 28) {
                this.AreaAttack(8.0f, 8.0f, 70.0f, 1.0f, 0.05f, 160, 0);
            }
        }
        if (this.getAnimation() == REMNANT_BITE2) {
            if (this.getAnimationTick() == 1) {
                this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BITE.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
            if (this.getAnimationTick() == 24) {
                this.AreaAttack(8.0f, 8.0f, 70.0f, 1.0f, 0.05f, 160, 0);
            }
        }
        if (this.getAnimation() == REMNANT_TAIL_ATTACK1 && this.getAnimationTick() == 16) {
            this.TailAreaAttack(8.0f, 8.0f, 1.05f, 120.0f, 1.0f, 0.05f, 200, 100);
        }
        if (this.getAnimation() == REMNANT_CHARGE_PREPARE) {
            if (this.getAnimationTick() == 1) {
                this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_CHARGE_PREPARE.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 15) {
                ScreenShake_Entity.ScreenShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.StompParticle(-0.1f, -0.75f);
            }
            if (this.getAnimationTick() == 41) {
                ScreenShake_Entity.ScreenShake(this.m_9236_(), this.m_20182_(), 30.0f, 0.1f, 0, 10);
                this.StompParticle(-0.1f, 0.75f);
            }
            if (this.getAnimationTick() == 62) {
                this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_CHARGE_ROAR.get(), SoundSource.HOSTILE, 3.0f, 1.0f);
            }
            if (this.getAnimationTick() == 132) {
                this.m_9236_().m_6269_((Player)null, (Entity)this, (SoundEvent)ModSounds.REMNANT_BREATHING.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            }
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Ancient_Remnant_Entity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + Math.min(this.m_21133_(Attributes.f_22281_) * (double)damage, (double)(entityHit.m_21233_() * hpdamage))));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ancient_Remnant_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag || stunticks <= 0) continue;
            entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), stunticks));
        }
    }

    private void TailAreaAttack(float range, float height, float height2, float arc, float damage, float hpdamage, int shieldbreakticks, int stunticks) {
        List<LivingEntity> entitiesHit = this.getTailEntityLivingBaseNearby(range, height, height2, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || this.m_7307_((Entity)entityHit) || entityHit instanceof Ancient_Remnant_Entity || entityHit == this) continue;
            boolean flag = entityHit.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + Math.min(this.m_21133_(Attributes.f_22281_) * (double)damage, (double)(entityHit.m_21233_() * hpdamage))));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ancient_Remnant_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            if (stunticks > 0) {
                entityHit.m_7292_(new MobEffectInstance((MobEffect)ModEffect.EFFECTSTUN.get(), stunticks));
            }
            double d0 = entityHit.m_20185_() - this.m_20185_();
            double d1 = entityHit.m_20189_() - this.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            entityHit.m_5997_(d0 / d2 * 4.0, 0.2, d1 / d2 * 4.0);
        }
    }

    public List<LivingEntity> getTailEntityLivingBaseNearby(double distanceX, double distanceMinY, double distanceMaxY, double distanceZ, double radius) {
        return this.getTailEntitiesNearby(LivingEntity.class, distanceX, distanceMinY, distanceMaxY, distanceZ, radius);
    }

    public <T extends Entity> List<T> getTailEntitiesNearby(Class<T> entityClass, double dX, double dY, double pY, double dZ, double r) {
        return this.m_9236_().m_6443_(entityClass, new AABB(this.m_20185_() - dX, this.m_20186_() - dY, this.m_20189_() - dZ, this.m_20185_() + dX, this.m_20186_() + pY, this.m_20189_() + dZ), e -> e != this && (double)this.m_20270_((Entity)e) <= r + (double)(e.m_20205_() / 2.0f) && e.m_20186_() <= this.m_20186_() + dY);
    }

    private void StompParticle(float vec, float math) {
        if (this.m_9236_().f_46443_) {
            for (int i1 = 0; i1 < 80 + this.f_19796_.m_188503_(12); ++i1) {
                double DeltaMovementX = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementY = this.m_217043_().m_188583_() * 0.07;
                double DeltaMovementZ = this.m_217043_().m_188583_() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                float f = Mth.m_14089_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.f_20883_ * ((float)Math.PI / 180)));
                double extraX = 0.5 * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 0.5 * (double)Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.m_9236_().m_8055_(hit.m_7495_());
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), DeltaMovementX, DeltaMovementY, DeltaMovementZ);
            }
        }
    }

    public boolean m_7307_(Entity entityIn) {
        if (entityIn == this) {
            return true;
        }
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof Ancient_Remnant_Entity) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    protected SoundEvent m_7515_() {
        return super.m_7515_();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return super.m_7975_(damageSourceIn);
    }

    protected SoundEvent m_5592_() {
        return super.m_5592_();
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    private static enum AttackMode {
        CIRCLE,
        MELEE,
        RANGE;

    }

    static class RemnantAttackGoal
    extends Goal {
        private final Ancient_Remnant_Entity mob;
        private LivingEntity target;
        private float circlingTime = 0.0f;
        private float MeleeModeTime = 0.0f;
        private static final int MELEE_MODE_TIME = 160;
        private float circleDistance = 18.0f;
        private boolean clockwise = false;

        public RemnantAttackGoal(Ancient_Remnant_Entity mob) {
            this.mob = mob;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            this.target = this.mob.m_5448_();
            return this.target != null && this.target.m_6084_() && this.mob.getAnimation() == IAnimatedEntity.NO_ANIMATION;
        }

        public boolean m_8045_() {
            this.target = this.mob.m_5448_();
            return this.target != null;
        }

        public void m_8056_() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0.0f;
            this.MeleeModeTime = 0.0f;
            this.circleDistance = 18 + this.mob.f_19796_.m_188503_(10);
            this.clockwise = this.mob.f_19796_.m_188499_();
            this.mob.m_21561_(true);
        }

        public void m_8041_() {
            this.mob.mode = AttackMode.CIRCLE;
            this.circlingTime = 0.0f;
            this.MeleeModeTime = 0.0f;
            this.circleDistance = 18 + this.mob.f_19796_.m_188503_(10);
            this.clockwise = this.mob.f_19796_.m_188499_();
            this.target = this.mob.m_5448_();
            if (!EntitySelector.f_20406_.test(this.target)) {
                this.mob.m_6710_(null);
            }
            this.mob.m_21573_().m_26573_();
            if (this.mob.m_5448_() == null) {
                this.mob.m_21561_(false);
                this.mob.m_21573_().m_26573_();
            }
        }

        public void m_8037_() {
            LivingEntity target = this.mob.m_5448_();
            if (target != null) {
                if (this.mob.mode == AttackMode.CIRCLE) {
                    this.mob.m_21391_((Entity)target, 30.0f, 30.0f);
                    BlockPos circlePos = this.getRemnantCirclePos(target);
                    if (circlePos != null) {
                        this.mob.m_21573_().m_26519_((double)circlePos.m_123341_() + 0.5, (double)circlePos.m_123342_(), (double)circlePos.m_123343_() + 0.5, 1.0);
                    }
                    if (this.circlingTime >= (float)this.mob.hunting_cooldown) {
                        int i = Math.max(this.mob.getModeChance(), 2);
                        this.mob.mode = this.mob.f_19796_.m_188503_(i) == 0 ? AttackMode.RANGE : AttackMode.MELEE;
                    } else if ((double)this.mob.m_20270_((Entity)target) < 7.0) {
                        this.mob.mode = AttackMode.MELEE;
                        this.mob.setAnimation(REMNANT_TAIL_ATTACK1);
                    }
                } else if (this.mob.mode == AttackMode.RANGE) {
                    if (this.mob.m_217043_().m_188501_() * 100.0f < 3.0f && (double)this.mob.m_20270_((Entity)target) > 10.0) {
                        this.mob.setAnimation(REMNANT_CHARGE_PREPARE);
                    }
                } else if (this.mob.mode == AttackMode.MELEE) {
                    this.mob.m_21573_().m_5624_((Entity)target, 1.0);
                    this.MeleeModeTime += 1.0f;
                    this.mob.m_21563_().m_24960_((Entity)target, 30.0f, 90.0f);
                    if (this.MeleeModeTime >= 160.0f) {
                        this.mob.mode = AttackMode.RANGE;
                    } else if (this.mob.m_217043_().m_188501_() * 100.0f < 15.0f && (double)this.mob.m_20270_((Entity)target) < 6.0) {
                        if (this.mob.f_19796_.m_188503_(2) == 0) {
                            this.mob.setAnimation(REMNANT_BITE1);
                        } else {
                            this.mob.setAnimation(REMNANT_BITE2);
                        }
                    } else if (this.mob.m_217043_().m_188501_() * 100.0f < 10.0f && (double)this.mob.m_20270_((Entity)target) < 7.0 && target.m_20186_() < this.mob.m_20186_() + 1.0) {
                        this.mob.setAnimation(REMNANT_TAIL_ATTACK1);
                    }
                }
            }
        }

        public BlockPos getRemnantCirclePos(LivingEntity target) {
            float angle = (float)Math.PI / 180 * (this.clockwise ? -this.circlingTime : this.circlingTime);
            double extraX = this.circleDistance * Mth.m_14031_((float)angle);
            double extraZ = this.circleDistance * Mth.m_14089_((float)angle);
            return BlockPos.m_274561_((double)(target.m_20185_() + 0.5 + extraX), (double)target.m_20186_(), (double)(target.m_20189_() + 0.5 + extraZ));
        }
    }

    static class RemnantChargeAttackGoal
    extends SimpleAnimationGoal<Ancient_Remnant_Entity> {
        public RemnantChargeAttackGoal(Ancient_Remnant_Entity entity, Animation animation) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
        }

        public void m_8056_() {
            ((Ancient_Remnant_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8056_();
        }

        public void m_8041_() {
            super.m_8041_();
            ((Ancient_Remnant_Entity)this.entity).hunting_cooldown = 100;
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
        }

        public void m_8037_() {
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < 62 && target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Remnant_Entity)this.entity).m_146922_(((Ancient_Remnant_Entity)this.entity).f_19859_);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < 122 && ((Ancient_Remnant_Entity)this.entity).getAnimationTick() > 62 && ((Ancient_Remnant_Entity)this.entity).m_20096_()) {
                Vec3 vector3d = ((Ancient_Remnant_Entity)this.entity).m_20184_();
                float f = ((Ancient_Remnant_Entity)this.entity).m_146908_() * ((float)Math.PI / 180);
                Vec3 vector3d1 = new Vec3((double)(-Mth.m_14031_((float)f)), ((Ancient_Remnant_Entity)this.entity).m_20184_().f_82480_, (double)Mth.m_14089_((float)f)).m_82490_(1.0).m_82549_(vector3d.m_82490_(0.5));
                ((Ancient_Remnant_Entity)this.entity).m_20334_(vector3d1.f_82479_, ((Ancient_Remnant_Entity)this.entity).m_20184_().f_82480_, vector3d1.f_82481_);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() == 62) {
                ((Ancient_Remnant_Entity)this.entity).setIsCharge(true);
            }
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() == 122) {
                ((Ancient_Remnant_Entity)this.entity).setIsCharge(false);
            }
        }
    }

    static class RemnantAnimationAttackGoal
    extends SimpleAnimationGoal<Ancient_Remnant_Entity> {
        private final int look;

        public RemnantAnimationAttackGoal(Ancient_Remnant_Entity entity, Animation animation, int look) {
            super(entity, animation);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
            this.look = look;
        }

        public void m_8056_() {
            ((Ancient_Remnant_Entity)this.entity).m_21573_().m_26573_();
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            }
            super.m_8056_();
        }

        public void m_8037_() {
            LivingEntity target = ((Ancient_Remnant_Entity)this.entity).m_5448_();
            if (((Ancient_Remnant_Entity)this.entity).getAnimationTick() < this.look && target != null) {
                ((Ancient_Remnant_Entity)this.entity).m_21391_((Entity)target, 30.0f, 30.0f);
                ((Ancient_Remnant_Entity)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                ((Ancient_Remnant_Entity)this.entity).m_146922_(((Ancient_Remnant_Entity)this.entity).f_19859_);
            }
        }
    }
}

