/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters.asm;

import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.Set;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public interface ITransformer {
    public static Optional<MethodNode> findMethod(ClassNode c, String name) {
        return c.methods.stream().filter(methodNode -> methodNode.name.equals(name)).findFirst();
    }

    public static Optional<MethodNode> findMethod(ClassNode c, String name, String desc) {
        return c.methods.stream().filter(methodNode -> methodNode.name.equals(name) && methodNode.desc.equals(desc)).findFirst();
    }

    public static void transformConstruct(MethodNode methodNode, String desc, String destNew) {
        for (AbstractInsnNode node : methodNode.instructions) {
            TypeInsnNode nodeNew;
            if (node.getOpcode() == 187) {
                nodeNew = (TypeInsnNode)node;
                if (!nodeNew.desc.equals(desc)) continue;
                nodeNew.desc = destNew;
                continue;
            }
            if (node.getOpcode() != 183) continue;
            nodeNew = (MethodInsnNode)node;
            if (!nodeNew.owner.equals(desc)) continue;
            nodeNew.owner = destNew;
        }
    }

    public static void transformInvoke(MethodNode methodNode, String srcOwner, String srcName, String srcDesc, String dstOwner, String dstName, String dstDesc) {
        for (AbstractInsnNode node : methodNode.instructions) {
            Handle h;
            if (node instanceof MethodInsnNode && (node.getOpcode() == 182 || node.getOpcode() == 183 || node.getOpcode() == 184)) {
                MethodInsnNode methodInsn = (MethodInsnNode)node;
                if (!methodInsn.owner.equals(srcOwner) || !methodInsn.name.equals(srcName) || !methodInsn.desc.equals(srcDesc)) continue;
                methodInsn.setOpcode(184);
                methodInsn.owner = dstOwner;
                methodInsn.name = dstName;
                methodInsn.desc = dstDesc;
                continue;
            }
            if (!(node instanceof InvokeDynamicInsnNode) || node.getOpcode() != 186) continue;
            InvokeDynamicInsnNode insnNode = (InvokeDynamicInsnNode)node;
            if (!(insnNode.bsmArgs[1] instanceof Handle) || !srcOwner.equals((h = (Handle)insnNode.bsmArgs[1]).getOwner()) || !srcName.equals(h.getName()) || !srcDesc.equals(h.getDesc())) continue;
            insnNode.bsmArgs[1] = new Handle(6, dstOwner, dstName, dstDesc, false);
        }
    }

    public static boolean transformInvokeLambda(MethodNode method, String owner, String name, String desc, String newOwner, String newName, String newDesc) {
        boolean ret = false;
        for (AbstractInsnNode node : method.instructions) {
            Handle h;
            int op = node.getOpcode();
            if (!(node instanceof InvokeDynamicInsnNode) || op != 186) continue;
            InvokeDynamicInsnNode insnNode = (InvokeDynamicInsnNode)node;
            if (!(insnNode.bsmArgs[1] instanceof Handle) || !(h = (Handle)insnNode.bsmArgs[1]).getOwner().equals(owner) || !h.getName().equals(name) || !h.getDesc().equals(desc)) continue;
            insnNode.bsmArgs[1] = new Handle(h.getTag(), newOwner, newName, newDesc, h.isInterface());
            ret = true;
        }
        return ret;
    }

    public static void injectBeforeReturn(MethodNode methodNode, String owner, String name, String id) {
        for (AbstractInsnNode node : methodNode.instructions) {
            if (!(node instanceof InsnNode) || node.getOpcode() != 177) continue;
            methodNode.instructions.insertBefore(node, (AbstractInsnNode)new MethodInsnNode(184, owner, name, id, false));
        }
    }

    public static MethodNode transformContains(MethodNode method) {
        ITransformer.transformInvoke(method, "java/lang/String", "contains", "(Ljava/lang/CharSequence;)Z", "me/towdium/jecharacters/utils/Match", "contains", "(Ljava/lang/String;Ljava/lang/CharSequence;)Z");
        ITransformer.transformInvoke(method, "kotlin/text/StringsKt", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Z)Z", "me/towdium/jecharacters/utils/Match", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence;Z)Z");
        ITransformer.transformInvoke(method, "kotlin/text/StringsKt", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence)Z", "me/towdium/jecharacters/utils/Match", "contains", "(Ljava/lang/CharSequence;Ljava/lang/CharSequence)Z");
        return method;
    }

    public static MethodNode transformSuffix(MethodNode method, String suffixClass) {
        ITransformer.transformConstruct(method, suffixClass, "me/towdium/jecharacters/utils/FakeArray");
        return method;
    }

    public static MethodNode transformEquals(MethodNode method) {
        ITransformer.transformInvoke(method, "java/lang/String", "equals", "(Ljava/lang/Object;)Z", "me/towdium/jecharacters/utils/Match", "equals", "(Ljava/lang/String;Ljava/lang/Object;)Z");
        return method;
    }

    public static MethodNode transformRegExp(MethodNode method) {
        ITransformer.transformInvoke(method, "java/util/regex/Pattern", "matcher", "(Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;", "me/towdium/jecharacters/utils/Match", "matcher", "(Ljava/util/regex/Pattern;Ljava/lang/CharSequence;)Ljava/util/regex/Matcher;");
        ITransformer.transformInvoke(method, "java/lang/String", "matches", "(Ljava/lang/String;)Z", "me/towdium/jecharacters/utils/Match", "matches", "(Ljava/lang/String;Ljava/lang/String;)Z");
        return method;
    }

    default public ClassNode transform(ClassNode node) {
        return node;
    }

    default public String internalName(ClassNode node) {
        return node.name.replace('/', '.');
    }

    default public boolean accept(String className) {
        return false;
    }

    public void init(JsonObject var1, Set<String> var2);

    public Set<String> targetClasses();
}

