/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.dynamic_resources.ctm;

import com.google.common.collect.ImmutableList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.MultiPartBakedModel;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.client.resources.model.WeightedBakedModel;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.registries.ForgeRegistries;
import org.embeddedt.modernfix.ModernFix;
import org.embeddedt.modernfix.ModernFixClient;
import org.embeddedt.modernfix.annotation.ClientOnlyMixin;
import org.embeddedt.modernfix.annotation.RequiresMod;
import org.embeddedt.modernfix.api.entrypoint.ModernFixClientIntegration;
import org.embeddedt.modernfix.api.helpers.ModelHelpers;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import team.chisel.ctm.client.model.AbstractCTMBakedModel;
import team.chisel.ctm.client.util.CTMPackReloadListener;

@Mixin(value={CTMPackReloadListener.class})
@RequiresMod(value="ctm")
@ClientOnlyMixin
public abstract class CTMPackReloadListenerMixin
implements ModernFixClientIntegration {
    @Shadow(remap=false)
    @Final
    private static Map<Holder.Reference<Block>, Predicate<RenderType>> blockRenderChecks;
    private static Map<Holder.Reference<Block>, Predicate<RenderType>> renderCheckOverrides;
    private static ChunkRenderTypeSet DEFAULT_TYPE_SET;

    @Shadow(remap=false)
    protected abstract Predicate<RenderType> getLayerCheck(BlockState var1, BakedModel var2);

    @Shadow(remap=false)
    protected abstract ChunkRenderTypeSet getExistingRenderCheck(Block var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        ModernFixClient.CLIENT_INTEGRATIONS.add(this);
    }

    @Overwrite(remap=false)
    private void refreshLayerHacks() {
        renderCheckOverrides.clear();
        if (blockRenderChecks.isEmpty()) {
            for (Block block : ForgeRegistries.BLOCKS.getValues()) {
                Holder.Reference holder = ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block);
                ChunkRenderTypeSet original = this.getExistingRenderCheck(block);
                if (original == null) {
                    original = DEFAULT_TYPE_SET;
                }
                blockRenderChecks.put((Holder.Reference<Block>)holder, arg_0 -> ((ChunkRenderTypeSet)original).contains(arg_0));
                ItemBlockRenderTypes.setRenderLayer((Block)block, type -> this.useOverrideIfPresent((Holder.Reference<Block>)holder, (RenderType)type));
            }
        }
    }

    private boolean useOverrideIfPresent(Holder.Reference<Block> delegate, RenderType type) {
        Predicate<RenderType> override = renderCheckOverrides.get(delegate);
        if (override == null) {
            override = blockRenderChecks.get(delegate);
        }
        return override.test(type);
    }

    @Override
    public BakedModel onBakedModelLoad(ResourceLocation location, UnbakedModel baseModel, BakedModel originalModel, ModelState modelState, ModelBakery bakery) {
        ImmutableList<BlockState> allStates;
        Holder.Reference delegate;
        if (!(location instanceof ModelResourceLocation)) {
            return originalModel;
        }
        if (!(originalModel instanceof AbstractCTMBakedModel || originalModel instanceof WeightedBakedModel || originalModel instanceof MultiPartBakedModel)) {
            return originalModel;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(location.m_135827_(), location.m_135815_()));
        Holder.Reference reference = delegate = block != null ? ForgeRegistries.BLOCKS.getDelegateOrThrow((Object)block) : null;
        if (block == null || block == Blocks.f_50016_ || renderCheckOverrides.containsKey(delegate)) {
            return originalModel;
        }
        try {
            allStates = ModelHelpers.getBlockStateForLocation((StateDefinition<Block, BlockState>)block.m_49965_(), (ModelResourceLocation)location);
        }
        catch (RuntimeException e) {
            ModernFix.LOGGER.error("Couldn't get state for MRL " + location, (Throwable)e);
            return originalModel;
        }
        for (BlockState state : allStates) {
            Predicate<RenderType> newPredicate = this.getLayerCheck(state, originalModel);
            if (newPredicate == null) continue;
            renderCheckOverrides.put((Holder.Reference<Block>)delegate, newPredicate);
            return originalModel;
        }
        return originalModel;
    }

    static {
        renderCheckOverrides = new ConcurrentHashMap<Holder.Reference<Block>, Predicate<RenderType>>();
        DEFAULT_TYPE_SET = ChunkRenderTypeSet.of((RenderType[])new RenderType[]{RenderType.m_110451_()});
    }
}

