/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.rewrite_registry;

import com.google.common.collect.BiMap;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import org.embeddedt.modernfix.annotation.IgnoreOutsideDev;
import org.embeddedt.modernfix.forge.registry.FastForgeRegistry;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ForgeRegistry.class}, remap=false)
@IgnoreOutsideDev
public class ForgeRegistryMixin<V> {
    @Shadow
    @Final
    @Mutable
    private BiMap<Integer, V> ids;
    @Shadow
    @Final
    @Mutable
    private BiMap<ResourceKey<V>, V> keys;
    @Shadow
    @Final
    private ResourceKey<Registry<V>> key;
    @Shadow
    @Final
    @Mutable
    private BiMap<ResourceLocation, V> names;
    @Shadow
    @Final
    @Mutable
    private BiMap owners;
    private FastForgeRegistry<V> fastRegistry;

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void replaceBackingMaps(CallbackInfo ci) {
        this.fastRegistry = new FastForgeRegistry<V>(this.key);
        this.ids = this.fastRegistry.getIds();
        this.keys = this.fastRegistry.getKeys();
        this.names = this.fastRegistry.getNames();
        this.owners = this.fastRegistry.getOwners();
    }

    @Inject(method={"freeze"}, at={@At(value="RETURN")})
    private void optimizeRegistry(CallbackInfo ci) {
        this.fastRegistry.optimize();
    }

    @Redirect(method={"sync"}, at=@At(value="INVOKE", target="Lcom/google/common/collect/BiMap;clear()V"))
    private void clearBiMap(BiMap map) {
        if (map == this.owners) {
            this.fastRegistry.clear();
        } else if (map != this.keys && map != this.names && map != this.ids) {
            map.clear();
        }
    }
}

