/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.config;

import java.util.Collection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ClipContext;
import org.jetbrains.annotations.ApiStatus;
import snownee.jade.Internals;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.Theme;

@ApiStatus.NonExtendable
public interface IWailaConfig {
    public static IWailaConfig get() {
        return Internals.getWailaConfig();
    }

    public IConfigGeneral getGeneral();

    public IConfigOverlay getOverlay();

    public IConfigFormatting getFormatting();

    public IPluginConfig getPlugin();

    public static enum BossBarOverlapMode {
        NO_OPERATION,
        HIDE_BOSS_BAR,
        HIDE_TOOLTIP,
        PUSH_DOWN;

    }

    public static enum FluidMode {
        NONE(ClipContext.Fluid.NONE),
        ANY(ClipContext.Fluid.ANY),
        SOURCE_ONLY(ClipContext.Fluid.SOURCE_ONLY);

        public final ClipContext.Fluid ctx;

        private FluidMode(ClipContext.Fluid ctx) {
            this.ctx = ctx;
        }
    }

    public static enum DisplayMode {
        HOLD_KEY,
        TOGGLE,
        LITE;

    }

    public static enum TTSMode {
        TOGGLE,
        PRESS;

    }

    public static enum IconMode {
        TOP,
        CENTERED,
        HIDE;

    }

    @ApiStatus.NonExtendable
    public static interface IConfigFormatting {
        public void setModName(String var1);

        public String getModName();

        public Component registryName(String var1);

        @Deprecated
        public Component title(Object var1);
    }

    @ApiStatus.NonExtendable
    public static interface IConfigOverlay {
        public void setOverlayPosX(float var1);

        public void setOverlayPosY(float var1);

        public void setOverlayScale(float var1);

        public void setAnchorX(float var1);

        public void setAnchorY(float var1);

        public float getOverlayPosX();

        public float getOverlayPosY();

        public float getOverlayScale();

        public float getAnchorX();

        public float getAnchorY();

        public void setFlipMainHand(boolean var1);

        public boolean getFlipMainHand();

        public float tryFlip(float var1);

        public void setSquare(boolean var1);

        public boolean getSquare();

        public float getAutoScaleThreshold();

        public float getAlpha();

        public Theme getTheme();

        public Collection<Theme> getThemes();

        public void setAlpha(float var1);

        public void applyTheme(ResourceLocation var1);

        public static int applyAlpha(int color, float alpha) {
            int prevAlphaChannel = color >> 24 & 0xFF;
            if (prevAlphaChannel > 0) {
                alpha *= (float)prevAlphaChannel / 256.0f;
            }
            int alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f));
            return color & 0xFFFFFF | alphaChannel << 24;
        }

        public boolean shouldShowIcon();

        public void setIconMode(IconMode var1);

        public IconMode getIconMode();

        public void setAnimation(boolean var1);

        public boolean getAnimation();

        public void setDisappearingDelay(float var1);

        public float getDisappearingDelay();
    }

    @ApiStatus.NonExtendable
    public static interface IConfigGeneral {
        public void setDisplayTooltip(boolean var1);

        public boolean getDisplayEntities();

        public boolean getDisplayBosses();

        public boolean getDisplayBlocks();

        public void setDisplayBlocks(boolean var1);

        public void setDisplayEntities(boolean var1);

        public void setDisplayBosses(boolean var1);

        public void setDisplayMode(DisplayMode var1);

        public void setHideFromDebug(boolean var1);

        public void setHideFromTabList(boolean var1);

        public void toggleTTS();

        public void setTTSMode(TTSMode var1);

        public void setDisplayFluids(boolean var1);

        public void setDisplayFluids(FluidMode var1);

        public void setItemModNameTooltip(boolean var1);

        public boolean shouldDisplayTooltip();

        public DisplayMode getDisplayMode();

        public boolean shouldHideFromDebug();

        public boolean shouldHideFromTabList();

        public boolean shouldEnableTextToSpeech();

        public TTSMode getTTSMode();

        public boolean shouldDisplayFluids();

        public FluidMode getDisplayFluids();

        public boolean showItemModNameTooltip();

        public float getReachDistance();

        public void setReachDistance(float var1);

        public BossBarOverlapMode getBossBarOverlapMode();

        public void setBossBarOverlapMode(BossBarOverlapMode var1);

        public void setDebug(boolean var1);

        public boolean isDebug();
    }
}

