/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.block;

import com.refinedmods.refinedstorage.block.BlockDirection;
import com.refinedmods.refinedstorage.block.CableBlock;
import com.refinedmods.refinedstorage.block.shape.ShapeCache;
import com.refinedmods.refinedstorage.blockentity.ExporterBlockEntity;
import com.refinedmods.refinedstorage.container.ExporterContainerMenu;
import com.refinedmods.refinedstorage.container.factory.BlockEntityMenuProvider;
import com.refinedmods.refinedstorage.render.ConstantsCable;
import com.refinedmods.refinedstorage.util.BlockUtils;
import com.refinedmods.refinedstorage.util.CollisionUtils;
import com.refinedmods.refinedstorage.util.NetworkUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class ExporterBlock
extends CableBlock {
    private static final VoxelShape LINE_NORTH_1 = ExporterBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)2.0);
    private static final VoxelShape LINE_NORTH_2 = ExporterBlock.m_49796_((double)5.0, (double)5.0, (double)2.0, (double)11.0, (double)11.0, (double)4.0);
    private static final VoxelShape LINE_NORTH_3 = ExporterBlock.m_49796_((double)3.0, (double)3.0, (double)4.0, (double)13.0, (double)13.0, (double)6.0);
    private static final VoxelShape LINE_NORTH = Shapes.m_83124_((VoxelShape)LINE_NORTH_1, (VoxelShape[])new VoxelShape[]{LINE_NORTH_2, LINE_NORTH_3});
    private static final VoxelShape LINE_EAST_1 = ExporterBlock.m_49796_((double)14.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape LINE_EAST_2 = ExporterBlock.m_49796_((double)12.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0, (double)11.0);
    private static final VoxelShape LINE_EAST_3 = ExporterBlock.m_49796_((double)10.0, (double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)13.0);
    private static final VoxelShape LINE_EAST = Shapes.m_83124_((VoxelShape)LINE_EAST_1, (VoxelShape[])new VoxelShape[]{LINE_EAST_2, LINE_EAST_3});
    private static final VoxelShape LINE_SOUTH_1 = ExporterBlock.m_49796_((double)6.0, (double)6.0, (double)14.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape LINE_SOUTH_2 = ExporterBlock.m_49796_((double)5.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0, (double)14.0);
    private static final VoxelShape LINE_SOUTH_3 = ExporterBlock.m_49796_((double)3.0, (double)3.0, (double)10.0, (double)13.0, (double)13.0, (double)12.0);
    private static final VoxelShape LINE_SOUTH = Shapes.m_83124_((VoxelShape)LINE_SOUTH_1, (VoxelShape[])new VoxelShape[]{LINE_SOUTH_2, LINE_SOUTH_3});
    private static final VoxelShape LINE_WEST_1 = ExporterBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)2.0, (double)10.0, (double)10.0);
    private static final VoxelShape LINE_WEST_2 = ExporterBlock.m_49796_((double)2.0, (double)5.0, (double)5.0, (double)4.0, (double)11.0, (double)11.0);
    private static final VoxelShape LINE_WEST_3 = ExporterBlock.m_49796_((double)4.0, (double)3.0, (double)3.0, (double)6.0, (double)13.0, (double)13.0);
    private static final VoxelShape LINE_WEST = Shapes.m_83124_((VoxelShape)LINE_WEST_1, (VoxelShape[])new VoxelShape[]{LINE_WEST_2, LINE_WEST_3});
    private static final VoxelShape LINE_UP_1 = ExporterBlock.m_49796_((double)6.0, (double)14.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape LINE_UP_2 = ExporterBlock.m_49796_((double)5.0, (double)12.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0);
    private static final VoxelShape LINE_UP_3 = ExporterBlock.m_49796_((double)3.0, (double)10.0, (double)3.0, (double)13.0, (double)12.0, (double)13.0);
    private static final VoxelShape LINE_UP = Shapes.m_83124_((VoxelShape)LINE_UP_1, (VoxelShape[])new VoxelShape[]{LINE_UP_2, LINE_UP_3});
    private static final VoxelShape LINE_DOWN_1 = ExporterBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)2.0, (double)10.0);
    private static final VoxelShape LINE_DOWN_2 = ExporterBlock.m_49796_((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape LINE_DOWN_3 = ExporterBlock.m_49796_((double)3.0, (double)4.0, (double)3.0, (double)13.0, (double)6.0, (double)13.0);
    private static final VoxelShape LINE_DOWN = Shapes.m_83124_((VoxelShape)LINE_DOWN_1, (VoxelShape[])new VoxelShape[]{LINE_DOWN_2, LINE_DOWN_3});

    public ExporterBlock() {
        super(BlockUtils.DEFAULT_GLASS_PROPERTIES);
    }

    @Override
    public BlockDirection getDirection() {
        return BlockDirection.ANY;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return ConstantsCable.addCoverVoxelShapes(ShapeCache.getOrCreate(state, s -> {
            VoxelShape shape = ExporterBlock.getCableShape(s);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getLineShape((BlockState)s));
            return shape;
        }), world, pos);
    }

    private VoxelShape getLineShape(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)this.getDirection().getProperty());
        if (direction == Direction.NORTH) {
            return LINE_NORTH;
        }
        if (direction == Direction.EAST) {
            return LINE_EAST;
        }
        if (direction == Direction.SOUTH) {
            return LINE_SOUTH;
        }
        if (direction == Direction.WEST) {
            return LINE_WEST;
        }
        if (direction == Direction.UP) {
            return LINE_UP;
        }
        if (direction == Direction.DOWN) {
            return LINE_DOWN;
        }
        return Shapes.m_83040_();
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ExporterBlockEntity(pos, state);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.f_46443_ && CollisionUtils.isInBounds(this.getLineShape(state), pos, hit.m_82450_())) {
            return NetworkUtils.attemptModify(level, pos, player, () -> NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), new BlockEntityMenuProvider<ExporterBlockEntity>((Component)Component.m_237115_((String)"gui.refinedstorage.exporter"), (blockEntity, windowId, inventory, p) -> new ExporterContainerMenu((ExporterBlockEntity)blockEntity, player, windowId), pos), (BlockPos)pos));
        }
        return InteractionResult.SUCCESS;
    }
}

