/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common;

import com.illusivesoulworks.colytra.common.crafting.ElytraAttachmentRecipe;
import com.illusivesoulworks.colytra.platform.Services;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.apache.commons.lang3.tuple.Pair;

public class ColytraConfig {
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final Server SERVER;
    private static final String CONFIG_PREFIX = "gui.colytra.config.";

    public static void reload() {
        ElytraAttachmentRecipe.VALID_ITEMS.clear();
        ((List)ColytraConfig.SERVER.itemsList.get()).forEach(id -> {
            Item item = Services.PLATFORM.getItem(ResourceLocation.m_135820_((String)id));
            if (item != null) {
                ElytraAttachmentRecipe.VALID_ITEMS.add(item);
            }
        });
    }

    static {
        Pair specPair = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.EnumValue<ListType> itemListType;
        public final SpectreConfigSpec.ConfigValue<List<? extends String>> itemsList;
        public final SpectreConfigSpec.EnumValue<FusionType> fusionType;
        public final SpectreConfigSpec.IntValue energyCost;

        public Server(SpectreConfigSpec.Builder builder) {
            this.itemListType = builder.comment("Determines if itemsList contains allowed items or denied items.").translation("gui.colytra.config.itemListType").defineEnum("itemListType", (Enum)ListType.DENY);
            this.itemsList = builder.comment("The items for crafting with elytras.").translation("gui.colytra.config.itemsList").defineList("itemsList", new ArrayList(), s -> {
                String str;
                return s instanceof String && ResourceLocation.m_135830_((String)(str = (String)s));
            });
            this.fusionType = builder.comment("Determines how the combined elytra chestplates will behave.\nNORMAL: Elytras will exist separately from the chestplate, able to be separated later.\nUNISON: Elytras will fuse completely with the chestplate, unable to be separated.\nPERFECT: Elytras will fuse completely with the chestplate and flying will not use durability.").translation("gui.colytra.config.fusionType").defineEnum("fusionType", (Enum)FusionType.NORMAL);
            this.energyCost = builder.comment("The energy cost per second of fall flying if fusionType is UNISON and the chestplate uses energy.").translation("gui.colytra.config.energyCost").defineInRange("energyCost", 1000, 0, Integer.MAX_VALUE);
        }
    }

    public static enum FusionType {
        NORMAL,
        UNISON,
        PERFECT;

    }

    public static enum ListType {
        DENY,
        ALLOW;

    }
}

