/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.colytra.common;

import com.illusivesoulworks.colytra.common.ColytraConfig;
import com.illusivesoulworks.colytra.common.ElytraTag;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.gameevent.GameEvent;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class CommonEvents {
    public static final AttributeModifier FLIGHT_MODIFIER = new AttributeModifier(UUID.fromString("668bdbee-32b6-4c4b-bf6a-5a30f4d02e37"), "Flight modifier", 1.0, AttributeModifier.Operation.ADDITION);
    private static final Triple<ItemStack, Integer, Integer> EMPTY_RESULT = new ImmutableTriple((Object)ItemStack.f_41583_, (Object)0, (Object)0);

    public static boolean updateColytra(LivingEntity livingEntity, boolean tickElytra) {
        ItemStack stack = livingEntity.m_6844_(EquipmentSlot.CHEST);
        ItemStack elytraStack = ElytraTag.getElytra(stack);
        if (!elytraStack.m_41619_() && ElytraTag.isUseable(stack, elytraStack)) {
            if (ColytraConfig.SERVER.fusionType.get() != ColytraConfig.FusionType.PERFECT && tickElytra) {
                int fallFlyingTicks = livingEntity.m_21256_();
                int i = fallFlyingTicks + 1;
                if (!livingEntity.m_9236_().m_5776_() && i % 10 == 0) {
                    int j = i / 10;
                    if (j % 2 == 0) {
                        ElytraTag.damageElytra(livingEntity, stack, elytraStack, 1);
                    }
                    livingEntity.m_146850_(GameEvent.f_223705_);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean repairColytraWithXp(ExperienceOrb experienceOrb, Player player, Consumer<Integer> xpSetter) {
        if (ColytraConfig.SERVER.fusionType.get() != ColytraConfig.FusionType.NORMAL || player.m_9236_().m_5776_()) {
            return false;
        }
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack elytraStack = ElytraTag.getElytra(chestStack);
        if (elytraStack.m_41619_() || elytraStack.m_41773_() <= 0 || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)elytraStack) <= 0) {
            return false;
        }
        int i = Math.min(CommonEvents.xpToDurability(experienceOrb.m_20801_()), elytraStack.m_41773_());
        if (i <= 0) {
            return false;
        }
        player.f_36101_ = 2;
        player.m_7938_((Entity)experienceOrb, 1);
        xpSetter.accept(experienceOrb.m_20801_() - CommonEvents.durabilityToXp(i));
        elytraStack.m_41721_(elytraStack.m_41773_() - i);
        ElytraTag.setElytra(chestStack, elytraStack);
        if (experienceOrb.m_20801_() > 0) {
            player.m_6756_(experienceOrb.m_20801_());
        }
        experienceOrb.m_146870_();
        return true;
    }

    private static int durabilityToXp(int durability) {
        return durability / 2;
    }

    private static int xpToDurability(int xp) {
        return xp * 2;
    }

    public static Triple<ItemStack, Integer, Integer> repairColytra(ItemStack input, ItemStack ingredient, String name) {
        if (ColytraConfig.SERVER.fusionType.get() != ColytraConfig.FusionType.NORMAL) {
            return EMPTY_RESULT;
        }
        ItemStack stack = ElytraTag.getElytra(input);
        if (stack.m_41619_()) {
            return EMPTY_RESULT;
        }
        int toRepair = stack.m_41773_();
        if (ingredient.m_41720_() != Items.f_42714_ || toRepair == 0) {
            return EMPTY_RESULT;
        }
        int membraneToUse = 0;
        while (toRepair > 0) {
            toRepair -= 108;
            ++membraneToUse;
        }
        membraneToUse = Math.min(membraneToUse, ingredient.m_41613_());
        int newDamage = Math.max(stack.m_41773_() - membraneToUse * 108, 0);
        ItemStack output = input.m_41777_();
        ItemStack outputElytra = stack.m_41777_();
        outputElytra.m_41721_(newDamage);
        outputElytra.m_41742_(stack.m_41610_() * 2 + 1);
        ElytraTag.setElytra(output, outputElytra);
        int xpCost = membraneToUse + input.m_41610_() + stack.m_41610_();
        if (name != null && !name.isEmpty() && !name.equals(input.m_41786_().getString())) {
            output.m_41714_((Component)Component.m_237113_((String)name));
            ++xpCost;
        }
        return new MutableTriple((Object)output, (Object)membraneToUse, (Object)xpCost);
    }
}

