/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vectorwing.farmersdelight.common.block.state.CanvasSign;
import vectorwing.farmersdelight.common.registry.ModAtlases;

@OnlyIn(value=Dist.CLIENT)
public class CanvasSignRenderer
extends SignRenderer {
    public static final Vec3 TEXT_OFFSET = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private final SignRenderer.SignModel signModel;
    private final Font font;

    public CanvasSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.signModel = new SignRenderer.SignModel(context.m_173582_(ModelLayers.m_171291_((WoodType)WoodType.f_61831_)));
        this.font = context.m_173586_();
    }

    public void m_6922_(SignBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState state = blockEntity.m_58900_();
        SignBlock block = (SignBlock)state.m_60734_();
        SignRenderer.SignModel model = this.signModel;
        model.f_112507_.f_104207_ = block instanceof StandingSignBlock;
        DyeColor dye = null;
        if (block instanceof CanvasSign) {
            CanvasSign canvasSign = (CanvasSign)block;
            dye = canvasSign.getBackgroundColor();
        }
        this.renderSignWithText(blockEntity, poseStack, bufferSource, packedLight, packedOverlay, state, block, dye, (Model)model);
    }

    protected void renderSignWithText(SignBlockEntity signBlockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, BlockState state, SignBlock block, @Nullable DyeColor dye, Model model) {
        poseStack.m_85836_();
        this.m_276777_(poseStack, -block.m_276903_(state), state);
        this.renderSign(poseStack, bufferSource, packedLight, packedOverlay, dye, model);
        this.m_278841_(signBlockEntity.m_58899_(), signBlockEntity.m_277142_(), poseStack, bufferSource, packedLight, signBlockEntity.m_245065_(), signBlockEntity.m_245123_(), true);
        this.m_278841_(signBlockEntity.m_58899_(), signBlockEntity.m_277159_(), poseStack, bufferSource, packedLight, signBlockEntity.m_245065_(), signBlockEntity.m_245123_(), false);
        poseStack.m_85849_();
    }

    protected void m_276777_(PoseStack poseStack, float angle, BlockState state) {
        poseStack.m_252880_(0.5f, 0.75f * this.m_278770_(), 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
        if (!(state.m_60734_() instanceof StandingSignBlock)) {
            poseStack.m_252880_(0.0f, -0.3125f, -0.4375f);
        }
    }

    protected void renderSign(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, @Nullable DyeColor dye, Model model) {
        poseStack.m_85836_();
        float rootScale = this.m_278770_();
        poseStack.m_85841_(rootScale, -rootScale, -rootScale);
        Material material = this.getCanvasSignMaterial(dye);
        VertexConsumer vertexConsumer = material.m_119194_(bufferSource, arg_0 -> ((Model)model).m_103119_(arg_0));
        this.m_245885_(poseStack, packedLight, packedOverlay, model, vertexConsumer);
        poseStack.m_85849_();
    }

    protected void m_245885_(PoseStack poseStack, int packedLight, int packedOverlay, Model model, VertexConsumer vertexConsumer) {
        SignRenderer.SignModel signModel = (SignRenderer.SignModel)model;
        signModel.f_173655_.m_104301_(poseStack, vertexConsumer, packedLight, packedOverlay);
    }

    protected void m_278841_(BlockPos pos, SignText text, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int textLineHeight, int maxTextLineWidth, boolean isFrontText) {
        int light;
        boolean hasOutline;
        int baseColor;
        int darkColor;
        poseStack.m_85836_();
        this.translateSignText(poseStack, isFrontText, this.m_278725_());
        FormattedCharSequence[] formattedCharSequenceList = text.m_277130_(Minecraft.m_91087_().m_167974_(), component -> {
            List list = this.font.m_92923_((FormattedText)component, maxTextLineWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (text.m_276843_()) {
            darkColor = CanvasSignRenderer.getDarkColor(text, true);
            baseColor = text.m_276773_().m_41071_();
            hasOutline = CanvasSignRenderer.isOutlineVisible(pos, baseColor);
            light = 0xF000F0;
        } else {
            baseColor = darkColor = CanvasSignRenderer.getDarkColor(text, false);
            hasOutline = false;
            light = packedLight;
        }
        int verticalOffset = 2 * textLineHeight + this.getCustomVerticalOffset();
        for (int i = 0; i < 4; ++i) {
            FormattedCharSequence formattedCharSequence = formattedCharSequenceList[i];
            float x = -this.font.m_92724_(formattedCharSequence) / 2;
            float y = i * textLineHeight - verticalOffset;
            if (hasOutline) {
                this.font.m_168645_(formattedCharSequence, x, y, baseColor, darkColor, poseStack.m_85850_().m_252922_(), bufferSource, light);
                continue;
            }
            this.font.m_272191_(formattedCharSequence, x, y, baseColor, false, poseStack.m_85850_().m_252922_(), bufferSource, Font.DisplayMode.POLYGON_OFFSET, 0, light);
        }
        poseStack.m_85849_();
    }

    private void translateSignText(PoseStack poseStack, boolean isFrontText, Vec3 pos) {
        if (!isFrontText) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        float textScale = 0.015625f * this.m_278631_();
        poseStack.m_85837_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        poseStack.m_85841_(textScale, -textScale, textScale);
    }

    public static boolean isOutlineVisible(BlockPos pos, int textColor) {
        if (textColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localPlayer = minecraft.f_91074_;
        if (localPlayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localPlayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    protected static int getDarkColor(SignText text, boolean isOutlineVisible) {
        int textColor = text.m_276773_().m_41071_();
        if (textColor == DyeColor.BLACK.m_41071_() && text.m_276843_()) {
            return -988212;
        }
        double brightness = isOutlineVisible ? 0.4 : 0.6;
        int red = (int)((double)FastColor.ARGB32.m_13665_((int)textColor) * brightness);
        int green = (int)((double)FastColor.ARGB32.m_13667_((int)textColor) * brightness);
        int blue = (int)((double)FastColor.ARGB32.m_13669_((int)textColor) * brightness);
        return FastColor.ARGB32.m_13660_((int)0, (int)red, (int)green, (int)blue);
    }

    Vec3 m_278725_() {
        return TEXT_OFFSET;
    }

    public int getCustomVerticalOffset() {
        return -1;
    }

    public Material getCanvasSignMaterial(@Nullable DyeColor dyeColor) {
        return ModAtlases.getCanvasSignMaterial(dyeColor);
    }
}

