/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.client.screens.TravelersBackpackScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;

public abstract class WidgetBase
implements Renderable,
GuiEventListener,
NarratableEntry {
    public final TravelersBackpackScreen screen;
    protected int x;
    protected int y;
    protected int zOffset = 0;
    protected int width;
    protected int height;
    protected boolean isHovered;
    protected boolean isWidgetActive = false;
    protected boolean isVisible;
    protected boolean showTooltip;

    public WidgetBase(TravelersBackpackScreen screen, int x, int y, int width, int height) {
        this.screen = screen;
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        boolean bl = this.isHovered = mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        if (this.zOffset != 0) {
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, (float)this.zOffset);
        }
        RenderSystem.enableDepthTest();
        this.renderBg(guiGraphics, Minecraft.m_91087_(), mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        if (this.zOffset != 0) {
            guiGraphics.m_280168_().m_85849_();
        }
    }

    abstract void renderBg(GuiGraphics var1, Minecraft var2, int var3, int var4);

    abstract void renderTooltip(GuiGraphics var1, int var2, int var3);

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (this.isHovered) {
            this.setWidgetStatus(!this.isWidgetActive);
            this.screen.playUIClickSound();
            return true;
        }
        return false;
    }

    public void setWidgetStatus(boolean status) {
        this.isWidgetActive = status;
    }

    public boolean isWidgetActive() {
        return this.isWidgetActive;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visibility) {
        this.isVisible = visibility;
    }

    public void setTooltipVisible(boolean visible) {
        this.showTooltip = visible;
    }

    public boolean isSettingsChild() {
        return true;
    }

    public boolean in(int mouseX, int mouseY, int x, int y, int width, int height) {
        return x <= mouseX && mouseX <= x + width && y <= mouseY && mouseY <= y + height;
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.NONE;
    }

    public void m_142291_(NarrationElementOutput pNarrationElementOutput) {
    }

    public int[] getWidgetSizeAndPos() {
        int[] size = new int[]{this.x, this.y, this.width, this.height};
        return size;
    }
}

