/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.handlers;

import com.mojang.brigadier.CommandDispatcher;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.blockentity.TravelersBackpackBlockEntity;
import com.tiviacz.travelersbackpack.blocks.SleepingBagBlock;
import com.tiviacz.travelersbackpack.blocks.TravelersBackpackBlock;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackCapability;
import com.tiviacz.travelersbackpack.capability.TravelersBackpackWearable;
import com.tiviacz.travelersbackpack.capability.entity.IEntityTravelersBackpack;
import com.tiviacz.travelersbackpack.capability.entity.TravelersBackpackEntityCapability;
import com.tiviacz.travelersbackpack.capability.entity.TravelersBackpackEntityWearable;
import com.tiviacz.travelersbackpack.commands.AccessBackpackCommand;
import com.tiviacz.travelersbackpack.commands.ClearBackpackCommand;
import com.tiviacz.travelersbackpack.commands.RestoreBackpackCommand;
import com.tiviacz.travelersbackpack.commands.UnpackBackpackCommand;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.common.recipes.ShapedBackpackRecipe;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.SleepingBagItem;
import com.tiviacz.travelersbackpack.items.TierUpgradeItem;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.network.ClientboundSyncCapabilityPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import com.tiviacz.travelersbackpack.util.Reference;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.EnderManAngerEvent;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerSetSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.command.ConfigCommand;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

@Mod.EventBusSubscriber(modid="travelersbackpack", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventHandler {
    private static boolean checkAbilitiesForRemoval = true;
    private static long nextBackpackCountCheck = 0L;
    private static final int BACKPACK_COUNT_CHECK_COOLDOWN = 100;

    @SubscribeEvent
    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(ITravelersBackpack.class);
        event.register(IEntityTravelersBackpack.class);
    }

    @SubscribeEvent
    public static void playerSetSpawn(PlayerSetSpawnEvent event) {
        Level level = event.getEntity().m_9236_();
        if (event.getNewSpawn() != null) {
            Block block = level.m_8055_(event.getNewSpawn()).m_60734_();
            if (!level.f_46443_ && block instanceof SleepingBagBlock && !TravelersBackpackConfig.enableSleepingBagSpawnPoint) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void playerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Block storageSlots2;
        TravelersBackpackBlockEntity blockEntity;
        BlockEntity blockEntity2;
        Object item;
        ItemStack stack = event.getItemStack();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        if (TravelersBackpackConfig.enableBackpackRightClickUnequip && CapabilityUtils.isWearingBackpack(player) && !level.f_46443_ && player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && player.m_21120_(InteractionHand.MAIN_HAND).m_41619_()) {
            ItemStack backpackStack = CapabilityUtils.getWearingBackpack(player);
            UseOnContext context = new UseOnContext(level, player, InteractionHand.MAIN_HAND, backpackStack, event.getHitVec());
            Item item2 = backpackStack.m_41720_();
            if (item2 instanceof TravelersBackpackItem && ((TravelersBackpackItem)((Object)(item = (TravelersBackpackItem)item2))).m_40576_(new BlockPlaceContext(context)) == InteractionResult.m_19078_((boolean)level.f_46443_)) {
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                level.m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.05f, (1.0f + (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f) * 0.7f);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                if (TravelersBackpack.enableCurios()) {
                    int backpackSlot = ((SlotResult)CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, p -> ItemStack.m_150942_((ItemStack)p, (ItemStack)backpackStack)).get()).slotContext().index();
                    CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).map(iCuriosItemHandler -> iCuriosItemHandler.getStacksHandler(SlotTypePreset.BACK.getIdentifier())).ifPresent(iCurioStacksHandler -> ((ICurioStacksHandler)iCurioStacksHandler.get()).getStacks().setStackInSlot(backpackSlot, ItemStack.f_41583_));
                }
                CapabilityUtils.synchronise(player);
                CapabilityUtils.synchroniseToOthers(player);
                event.setCanceled(true);
                return;
            }
        }
        if (player.m_6144_() && event.getHand() == InteractionHand.MAIN_HAND && (item = player.m_21120_(InteractionHand.MAIN_HAND).m_41720_()) instanceof SleepingBagItem) {
            SleepingBagItem item3 = (SleepingBagItem)((Object)item);
            item = level.m_7702_(pos);
            if (item instanceof TravelersBackpackBlockEntity) {
                blockEntity2 = (TravelersBackpackBlockEntity)item;
                ItemStack oldSleepingBag = blockEntity2.getProperSleepingBag(blockEntity2.getSleepingBagColor()).m_60734_().m_5456_().m_7968_();
                blockEntity2.setSleepingBagColor(ShapedBackpackRecipe.getProperColor(item3));
                if (!level.f_46443_) {
                    Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_7494_().m_123342_(), (double)pos.m_123343_(), (ItemStack)oldSleepingBag);
                    stack.m_41774_(1);
                }
                player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                player.m_21011_(InteractionHand.MAIN_HAND, true);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
        if (player.m_6144_() && player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == ModItems.BLANK_UPGRADE.get() && (blockEntity2 = level.m_7702_(pos)) instanceof TravelersBackpackBlockEntity && (blockEntity = (TravelersBackpackBlockEntity)blockEntity2).getTier() != Tiers.LEATHER) {
            int fluidAmountRight;
            int fluidAmountLeft;
            int storageSlots2 = blockEntity.getTier().getAllSlots() + 9;
            NonNullList list = NonNullList.m_122779_();
            for (int i2 = 0; i2 < storageSlots2; ++i2) {
                ItemStack stackInSlot = blockEntity.getCombinedHandler().getStackInSlot(i2);
                if (stackInSlot.m_41619_()) continue;
                list.add((Object)stackInSlot);
                blockEntity.getCombinedHandler().setStackInSlot(i2, ItemStack.f_41583_);
            }
            list.addAll(TierUpgradeItem.getUpgradesForTier(blockEntity.getTier()));
            if (!blockEntity.getSlotManager().getUnsortableSlots().isEmpty()) {
                blockEntity.getSlotManager().getUnsortableSlots().removeIf(i -> i > Tiers.LEATHER.getStorageSlots() - 7);
            }
            if (!blockEntity.getSlotManager().getMemorySlots().isEmpty()) {
                blockEntity.getSlotManager().getMemorySlots().removeIf(p -> (Integer)p.getFirst() > Tiers.LEATHER.getStorageSlots() - 7);
            }
            int n = fluidAmountLeft = blockEntity.getLeftTank().isEmpty() ? 0 : blockEntity.getLeftTank().getFluidAmount();
            if (fluidAmountLeft > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getLeftTank().drain(fluidAmountLeft - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            int n2 = fluidAmountRight = blockEntity.getRightTank().isEmpty() ? 0 : blockEntity.getRightTank().getFluidAmount();
            if (fluidAmountRight > Tiers.LEATHER.getTankCapacity()) {
                blockEntity.getRightTank().drain(fluidAmountRight - Tiers.LEATHER.getTankCapacity(), IFluidHandler.FluidAction.EXECUTE);
            }
            if (!level.f_46443_) {
                Containers.m_19010_((Level)level, (BlockPos)pos.m_7494_(), (NonNullList)list);
            }
            blockEntity.resetTier();
            player.m_21011_(InteractionHand.MAIN_HAND, true);
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
            return;
        }
        if (event.getLevel().f_46443_) {
            return;
        }
        if (TravelersBackpackConfig.enableBackpackBlockWearable && (storageSlots2 = event.getLevel().m_8055_(event.getPos()).m_60734_()) instanceof TravelersBackpackBlock) {
            TravelersBackpackBlock block = (TravelersBackpackBlock)storageSlots2;
            if (player.m_6144_() && !CapabilityUtils.isWearingBackpack(player)) {
                blockEntity2 = (TravelersBackpackBlockEntity)level.m_7702_(pos);
                ItemStack backpack = new ItemStack((ItemLike)block, 1);
                if (!TravelersBackpack.enableCurios()) {
                    Direction bagDirection = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                    if (level.m_46597_(pos, Blocks.f_50016_.m_49966_())) {
                        blockEntity2.transferToItemStack(backpack);
                        CapabilityUtils.equipBackpack(event.getEntity(), backpack);
                        player.m_21011_(InteractionHand.MAIN_HAND, true);
                        if (blockEntity2.isSleepingBagDeployed()) {
                            level.m_46597_(pos.m_121945_(bagDirection), Blocks.f_50016_.m_49966_());
                            level.m_46597_(pos.m_121945_(bagDirection).m_121945_(bagDirection), Blocks.f_50016_.m_49966_());
                        }
                        event.setCancellationResult(InteractionResult.SUCCESS);
                        event.setCanceled(true);
                        return;
                    }
                } else {
                    blockEntity2.transferToItemStack(backpack);
                    CuriosApi.getCuriosHelper().getCurio(backpack).ifPresent(arg_0 -> ForgeEventHandler.lambda$playerRightClickBlock$6(player, backpack, level, pos, (TravelersBackpackBlockEntity)blockEntity2, event, arg_0));
                }
            }
        }
        if (event.getLevel().f_46443_ || event.getEntity().m_6144_()) {
            return;
        }
        if (stack.m_41720_() == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            BlockState blockState = event.getLevel().m_8055_(event.getPos());
            if (BackpackDyeRecipe.hasColor(stack) && blockState.m_60734_() instanceof LayeredCauldronBlock && (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_) > 0) {
                stack.m_41783_().m_128473_("Color");
                LayeredCauldronBlock.m_153559_((BlockState)blockState, (Level)event.getLevel(), (BlockPos)event.getPos());
                event.getLevel().m_6263_(null, (double)event.getPos().m_123341_(), (double)event.getPos().m_123342_(), (double)event.getPos().m_123342_(), SoundEvents.f_11781_, SoundSource.BLOCKS, 1.0f, 1.0f);
                event.setCancellationResult(InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public static void onEnderManAngerEvent(EnderManAngerEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.pumpkinAbility(event);
        }
    }

    @SubscribeEvent
    public static void blockBlazeProjectile(ProjectileImpactEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.blazeAbility(event);
        }
    }

    @SubscribeEvent
    public static void livingChangeTarget(LivingChangeTargetEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ghastAbility(event);
        }
    }

    @SubscribeEvent
    public static void onHit(AttackEntityEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.beeAbility(event);
        }
    }

    @SubscribeEvent
    public static void onExpPickup(PlayerXpEvent.PickupXp event) {
        if (TravelersBackpackConfig.enableBackpackAbilities) {
            BackpackAbilities.ABILITIES.lapisAbility(event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ItemEntity itemEntity;
        block7: {
            block6: {
                Entity entity = event.getEntity();
                if (entity instanceof LivingEntity) {
                    IEntityTravelersBackpack travelersBackpack;
                    LazyOptional<IEntityTravelersBackpack> cap;
                    LivingEntity living = (LivingEntity)entity;
                    if (!event.loadedFromDisk() && TravelersBackpackConfig.spawnEntitiesWithBackpack && (cap = CapabilityUtils.getEntityCapability(living)).isPresent() && Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && !(travelersBackpack = (IEntityTravelersBackpack)cap.resolve().get()).hasWearable() && event.getLevel().m_213780_().m_216339_(0, TravelersBackpackConfig.spawnChance) == 0) {
                        boolean isNether = living.m_6095_() == EntityType.f_20511_ || living.m_6095_() == EntityType.f_20497_;
                        RandomSource rand = event.getLevel().f_46441_;
                        ItemStack backpack = isNether ? ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_NETHER_BACKPACK_ENTRIES.size() - 1)).m_7968_() : ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.get(rand.m_216332_(0, ModItems.COMPATIBLE_OVERWORLD_BACKPACK_ENTRIES.size() - 1)).m_7968_();
                        backpack.m_41784_().m_128405_("SleepingBagColor", DyeColor.values()[rand.m_216332_(0, DyeColor.values().length - 1)].m_41060_());
                        travelersBackpack.setWearable(backpack);
                        travelersBackpack.synchronise();
                    }
                }
                if (!((entity = event.getEntity()) instanceof ItemEntity)) break block6;
                itemEntity = (ItemEntity)entity;
                if (TravelersBackpackConfig.invulnerableBackpack) break block7;
            }
            return;
        }
        if (itemEntity.m_32055_().m_41720_() instanceof TravelersBackpackItem) {
            itemEntity.m_149678_();
            itemEntity.m_20331_(true);
        }
    }

    @SubscribeEvent
    public static void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        LivingEntity livingEntity;
        Object travelersBackpack;
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            travelersBackpack = new TravelersBackpackWearable(player);
            event.addCapability(TravelersBackpackCapability.ID, TravelersBackpackCapability.createProvider((ITravelersBackpack)travelersBackpack));
        }
        if ((travelersBackpack = event.getObject()) instanceof LivingEntity && Reference.ALLOWED_TYPE_ENTRIES.contains((livingEntity = (LivingEntity)travelersBackpack).m_6095_())) {
            travelersBackpack = new TravelersBackpackEntityWearable(livingEntity);
            event.addCapability(TravelersBackpackEntityCapability.ID, TravelersBackpackEntityCapability.createProvider((IEntityTravelersBackpack)travelersBackpack));
        }
    }

    @SubscribeEvent
    public static void playerDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CapabilityUtils.isWearingBackpack(player = (Player)livingEntity)) {
            if (TravelersBackpackConfig.enableBackpackAbilities && BackpackAbilities.creeperAbility(event)) {
                return;
            }
            if (TravelersBackpack.isAnyGraveModInstalled()) {
                return;
            }
            if (!player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                BackpackUtils.onPlayerDeath(player.m_9236_(), player, CapabilityUtils.getWearingBackpack(player));
            }
            CapabilityUtils.synchronise((Player)event.getEntity());
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getEntity().m_6095_()) && CapabilityUtils.isWearingBackpack(event.getEntity())) {
            event.getEntity().m_19983_(CapabilityUtils.getWearingBackpack(event.getEntity()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onPlayerDrops(LivingDropsEvent event) {
        LivingEntity livingEntity;
        if (TravelersBackpack.isAnyGraveModInstalled() && (livingEntity = event.getEntity()) instanceof Player) {
            Player player = (Player)livingEntity;
            if (player.m_9236_().m_46469_().m_46207_(GameRules.f_46133_)) {
                return;
            }
            if (CapabilityUtils.isWearingBackpack(player) && !player.m_9236_().f_46443_) {
                ItemStack stack = CapabilityUtils.getWearingBackpack(player);
                ItemEntity itemEntity = new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                event.getDrops().add(itemEntity);
                CapabilityUtils.getCapability(player).ifPresent(ITravelersBackpack::removeWearable);
                CapabilityUtils.synchronise(player);
            }
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        oldPlayer.revive();
        CapabilityUtils.getCapability(oldPlayer).ifPresent(oldTravelersBackpack -> CapabilityUtils.getCapability(event.getEntity()).ifPresent(newTravelersBackpack -> {
            newTravelersBackpack.setWearable(oldTravelersBackpack.getWearable());
            newTravelersBackpack.setContents(oldTravelersBackpack.getWearable());
        }));
    }

    @SubscribeEvent
    public static void playerChangeDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        CapabilityUtils.synchronise(event.getEntity());
    }

    @SubscribeEvent
    public static void entityJoin(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            CapabilityUtils.synchronise(player);
        }
    }

    @SubscribeEvent
    public static void playerTracking(PlayerEvent.StartTracking event) {
        ServerPlayer target;
        if (event.getTarget() instanceof Player && !event.getTarget().m_9236_().f_46443_) {
            target = (ServerPlayer)event.getTarget();
            CapabilityUtils.getCapability((Player)target).ifPresent(c -> TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundSyncCapabilityPacket(CapabilityUtils.getWearingBackpack((Player)target).m_41739_(new CompoundTag()), target.m_19879_(), true)));
        }
        if (Reference.ALLOWED_TYPE_ENTRIES.contains(event.getTarget().m_6095_()) && !event.getTarget().m_9236_().f_46443_) {
            target = (LivingEntity)event.getTarget();
            CapabilityUtils.getEntityCapability((LivingEntity)target).ifPresent(arg_0 -> ForgeEventHandler.lambda$playerTracking$12(event, (LivingEntity)target, arg_0));
        }
    }

    @SubscribeEvent
    public static void playerTick(TickEvent.PlayerTickEvent event) {
        if (TravelersBackpackConfig.enableBackpackAbilities && event.phase == TickEvent.Phase.END && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
            TravelersBackpackContainer.abilityTick(event.player);
            if (!checkAbilitiesForRemoval && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_REMOVAL_LIST, CapabilityUtils.getWearingBackpack(event.player))) {
                checkAbilitiesForRemoval = true;
            }
        }
        if (!(!checkAbilitiesForRemoval || event.phase != TickEvent.Phase.END || event.player.m_9236_().f_46443_ || CapabilityUtils.isWearingBackpack(event.player) && TravelersBackpackConfig.enableBackpackAbilities)) {
            BackpackAbilities.ABILITIES.armorAbilityRemovals(event.player);
            checkAbilitiesForRemoval = false;
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.END || !TravelersBackpackConfig.tooManyBackpacksSlowness || nextBackpackCountCheck > event.level.m_46467_()) {
            return;
        }
        nextBackpackCountCheck = event.level.m_46467_() + 100L;
        event.level.m_6907_().forEach(player -> {
            AtomicInteger numberOfBackpacks = ForgeEventHandler.checkBackpacksForSlowness(player);
            if (numberOfBackpacks.get() == 0) {
                return;
            }
            int maxNumberOfBackpacks = TravelersBackpackConfig.maxNumberOfBackpacks;
            if (numberOfBackpacks.get() > maxNumberOfBackpacks) {
                int numberOfSlownessLevels = Math.min(10, (int)Math.ceil((double)(numberOfBackpacks.get() - maxNumberOfBackpacks) * TravelersBackpackConfig.slownessPerExcessedBackpack));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, numberOfSlownessLevels - 1, false, false));
            }
        });
    }

    public static AtomicInteger checkBackpacksForSlowness(Player player) {
        AtomicInteger atomic = new AtomicInteger(0);
        for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            if (!(((ItemStack)player.m_150109_().f_35974_.get(i)).m_41720_() instanceof TravelersBackpackItem)) continue;
            atomic.incrementAndGet();
        }
        if (((ItemStack)player.m_150109_().f_35976_.get(0)).m_41720_() instanceof TravelersBackpackItem) {
            atomic.incrementAndGet();
        }
        return atomic;
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        new AccessBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new RestoreBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new ClearBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        new UnpackBackpackCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConfigCommand.register((CommandDispatcher)event.getDispatcher());
    }

    @SubscribeEvent
    public static void explosionDetonate(ExplosionEvent.Detonate event) {
        for (int i = 0; i < event.getAffectedEntities().size(); ++i) {
            ItemEntity itemEntity;
            Entity entity = (Entity)event.getAffectedEntities().get(i);
            if (!(entity instanceof ItemEntity) || !((itemEntity = (ItemEntity)entity).m_32055_().m_41720_() instanceof TravelersBackpackItem)) continue;
            event.getAffectedEntities().remove(i);
        }
    }

    @SubscribeEvent
    public static void addVillagerTrade(VillagerTradesEvent event) {
        if (TravelersBackpackConfig.enableVillagerTrade && event.getType() == VillagerProfession.f_35594_) {
            ((List)event.getTrades().get(5)).add(new BackpackVillagerTrade());
        }
    }

    private static /* synthetic */ void lambda$playerTracking$12(PlayerEvent.StartTracking event, LivingEntity target, IEntityTravelersBackpack c) {
        TravelersBackpack.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new ClientboundSyncCapabilityPacket(CapabilityUtils.getWearingBackpack(target).m_41739_(new CompoundTag()), target.m_19879_(), false));
    }

    private static /* synthetic */ void lambda$playerRightClickBlock$6(Player player, ItemStack backpack, Level level, BlockPos pos, TravelersBackpackBlockEntity blockEntity, PlayerInteractEvent.RightClickBlock event, ICurio curio) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            Map curios = handler.getCurios();
            for (Map.Entry entry : curios.entrySet()) {
                IDynamicStackHandler stackHandler = ((ICurioStacksHandler)entry.getValue()).getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack present = stackHandler.getStackInSlot(i);
                    Set tags = CuriosApi.getCuriosHelper().getCurioTags(backpack.m_41720_());
                    String id = (String)entry.getKey();
                    if (!present.m_41619_() || !tags.contains(id) && !tags.contains(SlotTypePreset.CURIO.getIdentifier()) && (tags.isEmpty() || !id.equals(SlotTypePreset.CURIO.getIdentifier())) || !curio.canEquip(id, (LivingEntity)player)) continue;
                    Direction bagDirection = (Direction)level.m_8055_(pos).m_61143_((Property)TravelersBackpackBlock.FACING);
                    if (!level.m_46597_(pos, Blocks.f_50016_.m_49966_())) continue;
                    stackHandler.setStackInSlot(i, backpack.m_41777_());
                    player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_11678_, SoundSource.PLAYERS, 1.0f, (1.0f + (player.m_9236_().f_46441_.m_188501_() - player.m_9236_().f_46441_.m_188501_()) * 0.2f) * 0.7f);
                    player.m_21011_(InteractionHand.MAIN_HAND, true);
                    if (blockEntity.isSleepingBagDeployed()) {
                        level.m_46597_(pos.m_121945_(bagDirection), Blocks.f_50016_.m_49966_());
                        level.m_46597_(pos.m_121945_(bagDirection).m_121945_(bagDirection), Blocks.f_50016_.m_49966_());
                    }
                    event.setCancellationResult(InteractionResult.SUCCESS);
                    event.setCanceled(true);
                    return;
                }
            }
        });
    }

    private static class BackpackVillagerTrade
    implements VillagerTrades.ItemListing {
        private BackpackVillagerTrade() {
        }

        @Nullable
        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42616_, random.m_188503_(64) + 48), new ItemStack((ItemLike)((Item)ModItems.VILLAGER_TRAVELERS_BACKPACK.get()).m_5456_(), 1), 1, 5, 0.5f);
        }
    }
}

