/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.network;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class ServerboundSpecialActionPacket {
    private final byte screenID;
    private final byte typeOfAction;
    private final double scrollDelta;

    public ServerboundSpecialActionPacket(byte screenID, byte typeOfAction, double scrollDelta) {
        this.screenID = screenID;
        this.typeOfAction = typeOfAction;
        this.scrollDelta = scrollDelta;
    }

    public static ServerboundSpecialActionPacket decode(FriendlyByteBuf buffer) {
        byte screenID = buffer.readByte();
        byte typeOfAction = buffer.readByte();
        double scrollDelta = buffer.readDouble();
        return new ServerboundSpecialActionPacket(screenID, typeOfAction, scrollDelta);
    }

    public static void encode(ServerboundSpecialActionPacket message, FriendlyByteBuf buffer) {
        buffer.writeByte((int)message.screenID);
        buffer.writeByte((int)message.typeOfAction);
        buffer.writeDouble(message.scrollDelta);
    }

    public static void handle(ServerboundSpecialActionPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer serverPlayer = ((NetworkEvent.Context)ctx.get()).getSender();
            if (serverPlayer != null) {
                if (message.typeOfAction == 0) {
                    ServerActions.swapTool((Player)serverPlayer, message.scrollDelta);
                } else if (message.typeOfAction == 1) {
                    ServerActions.switchHoseMode((Player)serverPlayer, message.scrollDelta);
                } else if (message.typeOfAction == 2) {
                    ServerActions.toggleHoseTank((Player)serverPlayer);
                } else if (message.typeOfAction == 3) {
                    ServerActions.emptyTank(message.scrollDelta, (Player)serverPlayer, (Level)serverPlayer.m_284548_(), message.screenID);
                } else if (message.typeOfAction == 4 && CapabilityUtils.isWearingBackpack((Player)serverPlayer)) {
                    TravelersBackpackContainer.openGUI(serverPlayer, CapabilityUtils.getWearingBackpack((Player)serverPlayer), (byte)2);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

