/*
 * Decompiled with CFR 0.152.
 */
package io.github.reserveword.imblocker;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import io.github.reserveword.imblocker.Common;

public class IMManager {
    private static final User32 u;
    private static boolean state;

    private static native WinNT.HANDLE ImmGetContext(WinDef.HWND var0);

    private static native WinNT.HANDLE ImmAssociateContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native boolean ImmReleaseContext(WinDef.HWND var0, WinNT.HANDLE var1);

    private static native WinNT.HANDLE ImmCreateContext();

    private static native boolean ImmDestroyContext(WinNT.HANDLE var0);

    private static void makeOnImp() {
        WinDef.HWND hwnd = u.GetForegroundWindow();
        WinNT.HANDLE himc = IMManager.ImmGetContext(hwnd);
        if (himc == null) {
            himc = IMManager.ImmCreateContext();
            IMManager.ImmAssociateContext(hwnd, himc);
        }
        IMManager.ImmReleaseContext(hwnd, himc);
    }

    private static void makeOffImp() {
        WinDef.HWND hwnd = u.GetForegroundWindow();
        WinNT.HANDLE himc = IMManager.ImmAssociateContext(hwnd, null);
        if (himc != null) {
            IMManager.ImmDestroyContext(himc);
        }
        IMManager.ImmReleaseContext(hwnd, himc);
    }

    private static boolean toggleImp() {
        WinDef.HWND hwnd = u.GetForegroundWindow();
        WinNT.HANDLE himc = IMManager.ImmGetContext(hwnd);
        if (himc == null) {
            himc = IMManager.ImmCreateContext();
            IMManager.ImmAssociateContext(hwnd, himc);
            IMManager.ImmReleaseContext(hwnd, himc);
            return true;
        }
        himc = IMManager.ImmAssociateContext(hwnd, null);
        IMManager.ImmDestroyContext(himc);
        IMManager.ImmReleaseContext(hwnd, himc);
        return false;
    }

    public static void makeOn() {
        if (!state) {
            IMManager.makeOnImp();
            state = true;
        }
    }

    public static void makeOff() {
        if (state) {
            IMManager.makeOffImp();
            state = false;
        }
    }

    public static void makeState(boolean on) {
        if (state == on) {
            return;
        }
        if (on) {
            IMManager.makeOnImp();
            state = true;
        } else {
            IMManager.makeOffImp();
            state = false;
        }
    }

    public static void syncState() {
        WinDef.HWND hwnd = u.GetForegroundWindow();
        WinNT.HANDLE himc = IMManager.ImmGetContext(hwnd);
        if (himc == null == state) {
            Common.LOGGER.warn("IM state inconsistent! state={}, im={}", (Object)state, (Object)(himc != null ? 1 : 0));
            IMManager.toggle();
        }
    }

    public static boolean getState() {
        return state;
    }

    public static boolean toggle() {
        state = IMManager.toggleImp();
        return state;
    }

    static {
        Native.register((String)"imm32");
        u = User32.INSTANCE;
        state = true;
    }
}

